/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.config;

import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import galaxyspace.GalaxySpace;
import galaxyspace.core.config.GSConfigDimensions;
import java.io.File;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GSConfigCore {
    public static boolean loaded;
    static Configuration config;
    public static boolean recipesRockets;
    public static boolean enableCheckVersion;
    public static boolean enableCapes;
    public static boolean enableNewMenu;
    public static int coefficientFuelGenerator;
    public static int coefficientGeothermalGenerator;
    public static int coefficientSolarWindPanel;
    public static int coefficientSolarPanel;
    public static int idSolarRadiation;
    public static int crystalBossInvisibilityIntervall;
    public static int crystalBossInvisibilityDuration;
    public static double crystalBossInvisibilityProbability;
    public static float baseBossDamage;
    public static boolean enableACentauri;
    public static boolean enableBarnarda;
    public static boolean enableVega;
    public static boolean enableTCeti;
    public static boolean enableMethaneParticle;
    public static boolean enableFogVenus;
    public static float spaceStationStarBrightness;
    public static boolean enableLeadGeneration;
    public static boolean enableOresGeneration;
    public static String[] oregenIDs;
    public static double destroyModule_a;
    public static double destroyModule_b;
    public static double destroyModuleMaxCPS;
    public static int euPerModule;
    public static int maxModules;
    public static double destroyModuleBase_chance;
    public static String[] powerFactors;
    public static double powerFactorDefault;
    public static int coolantConsumption;
    public static FluidStack coolantFluid;

    public GSConfigCore(File file) {
        if (!loaded) {
            config = new Configuration(file);
            GSConfigCore.syncConfig(true);
        }
    }

    public static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        try {
            if (!GSConfigCore.config.isChild && load) {
                config.load();
            }
            Property prop = config.get("general", "Advanced Recipes Rocket", true);
            prop.comment = "Enable/Disable advanced recipes rocket (Tier 1-8).";
            prop.setLanguageKey("gc.configgui.recipesRockets").setRequiresMcRestart(true);
            recipesRockets = prop.getBoolean();
            propOrder.add(prop.getName());
            prop = config.get("general", "enableCheckVersion", false);
            prop.comment = "Enable/Disable Check Version.";
            prop.setLanguageKey("gc.configgui.enableCheckVersion").setRequiresMcRestart(true);
            enableCheckVersion = prop.getBoolean();
            propOrder.add(prop.getName());
            prop = config.get("general", "enableCapes", true);
            prop.comment = "Enable/Disable Fetching Donator Capes";
            prop.setLanguageKey("gc.configgui.enableCapes").setRequiresMcRestart(false);
            enableCapes = prop.getBoolean();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableACentauri", true);
            prop.comment = "Enable/Disable aCentauri System.";
            prop.setLanguageKey("gc.configgui.enableACentauri").setRequiresMcRestart(true);
            enableACentauri = prop.getBoolean();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableBarnarda", true);
            prop.comment = "Enable/Disable Barnarda System.";
            prop.setLanguageKey("gc.configgui.enableBarnarda").setRequiresMcRestart(true);
            enableBarnarda = prop.getBoolean();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableVega", true);
            prop.comment = "Enable/Disable Vega System.";
            prop.setLanguageKey("gc.configgui.enableVega").setRequiresMcRestart(true);
            enableVega = prop.getBoolean();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableTCeti", true);
            prop.comment = "Enable/Disable tCeti System.";
            prop.setLanguageKey("gc.configgui.enableTCeti").setRequiresMcRestart(true);
            enableTCeti = prop.getBoolean();
            propOrder.add(prop.getName());
            prop = config.get("worldgen", "enableLeadGeneration", true);
            prop.comment = "Enable/Disable Generation Lead on Overworld.";
            prop.setLanguageKey("gc.configgui.enableLeadGeneration").setRequiresMcRestart(true);
            enableLeadGeneration = prop.getBoolean();
            propOrder.add(prop.getName());
            prop = config.get("worldgen", "enableOresGeneration", true);
            prop.comment = "Enable/Disable Generation Ores on Planets/Moon (Global Config).";
            prop.setLanguageKey("gc.configgui.enableOresGeneration").setRequiresMcRestart(true);
            enableOresGeneration = prop.getBoolean();
            propOrder.add(prop.getName());
            prop = config.get("general", "enableNewMenu", true);
            prop.comment = "Enable/Disable new Main Menu.";
            prop.setLanguageKey("gc.configgui.enableNewMenu").setRequiresMcRestart(true);
            enableNewMenu = prop.getBoolean();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableMethaneParticle", true);
            prop.comment = "Enable/Disable Methane Particles.";
            prop.setLanguageKey("gc.configgui.enableMethaneParticle").setRequiresMcRestart(true);
            enableMethaneParticle = prop.getBoolean();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientFuelGenerator", coefficientFuelGenerator);
            prop.comment = "Fuel Generator power factor";
            prop.setLanguageKey("gc.configgui.coefficientFuelGenerator").setRequiresMcRestart(true);
            coefficientFuelGenerator = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientGeothermalGenerator", coefficientGeothermalGenerator);
            prop.comment = "Geothermal Generator power factor";
            prop.setLanguageKey("gc.configgui.coefficientGeothermalGenerator").setRequiresMcRestart(true);
            coefficientGeothermalGenerator = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientSolarWindPanel", coefficientSolarWindPanel);
            prop.comment = "Solar Wind Panel power factor";
            prop.setLanguageKey("gc.configgui.coefficientSolarWindPanel").setRequiresMcRestart(true);
            coefficientSolarWindPanel = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientSolarPanel", coefficientSolarPanel);
            prop.comment = "Gybrid Solar Panel power factor";
            prop.setLanguageKey("gc.configgui.coefficientSolarPanel").setRequiresMcRestart(true);
            coefficientSolarPanel = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("worldgen", "Other mods ores for GC to generate on GS planets", new String[0]);
            prop.comment = "Enter IDs of other mods' ores here for Galacticraft to generate them on GalaxySpace planets. Format is BlockName or BlockName:metadata. Use optional parameters at end of each line: /RARE /UNCOMMON or /COMMON for rarity in a chunk; /DEEP /SHALLOW or /BOTH for height; /SINGLE /STANDARD or /LARGE for clump size; /XTRARANDOM for ores sometimes there sometimes not at all.  /ONLYMOON or /ONLYMARS if wanted on one planet only.  If nothing specified, defaults are /COMMON, /BOTH and /STANDARD.  Repeat lines to generate a huge quantity of ores.";
            prop.comment = "/ONLYPHOBOS, /ONLYDEIMOS, /ONLYEUROPA, /ONLYIO, /ONLYENCELADUS, /ONLYVENUS, /ONLYMERCURY, /ONLYCERES if wanted on one planet only.";
            prop.setLanguageKey("gc.configgui.otherModOreGenIDs");
            oregenIDs = prop.getStringList();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "enableFogVenus", true);
            prop.comment = "Enable/Disable Fog on Venus.";
            prop.setLanguageKey("gc.configgui.enableFogVenus").setRequiresMcRestart(true);
            enableFogVenus = prop.getBoolean();
            propOrder.add(prop.getName());
            prop = config.get("dimensions", "spaceStationStarBrightness", 0.8, "How bright stars are rendered on skyboxes of space stations.", 0.0, 1.0);
            spaceStationStarBrightness = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("general", "idSolarRadiation", idSolarRadiation);
            prop.comment = "ID Potion 'Solar Radiation'";
            prop.setLanguageKey("gc.configgui.idSolarRadiation").setRequiresMcRestart(true);
            idSolarRadiation = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "crystalBossInvisibilityInterval", 100);
            prop.comment = "Every x ticks, the Crystal Boss tries to make itself invisible";
            prop.setMinValue(1);
            crystalBossInvisibilityIntervall = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "crystalBossInvisibilityDuration", 60);
            prop.comment = "How long the Crystal Boss can make itself invisible";
            prop.setMinValue(1).setMaxValue(1000000);
            crystalBossInvisibilityDuration = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("general", "crystalBossInvisibilityProbability", 0.5);
            prop.comment = "How high the probability is, that the Crystal Boss will make itself invisible";
            prop.setMinValue(0.0).setMaxValue(1.0);
            crystalBossInvisibilityProbability = prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("general", "baseBossDamage", 3.0);
            prop.comment = "How much damage the player can deal at most to Evolved Crystal Boss, Evolved Blaze Boss and Evolved Ghast Boss (These bosses are supposed to be beaten by their own fireballs!)";
            prop.setMinValue(0.0).setMaxValue(3.4028234663852886E38);
            baseBossDamage = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("dysonSwarm", "destroyModule_a", 5.0E-5).setRequiresMcRestart(true);
            prop.comment = "Each hour, n of m modules are destroyed according to this formula: n = m * (2 * base_chance) / (exp(-a * (m - 1))+exp(b * cps)), where cps is computation per second. This sets the parameter a.";
            prop.setMinValue(0.0).setMaxValue(1.0);
            destroyModule_a = prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("dysonSwarm", "destroyModule_b", 3.0E-5).setRequiresMcRestart(true);
            prop.comment = "Each hour, n of m modules are destroyed according to this formula: n = m * (2 * base_chance) / (exp(-a * (m - 1))+exp(b * cps)), where cps is computation per second. This sets the parameter b.";
            prop.setMinValue(0.0).setMaxValue(1.0);
            destroyModule_b = prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("dysonSwarm", "destroyModuleBase_chance", 0.066).setRequiresMcRestart(true);
            prop.comment = "Each hour, n of m modules are destroyed according to this formula: n = m * (2 * base_chance) / (exp(-a * (m - 1))+exp(b * cps)), where cps is computation per second. This sets the parameter base_chance.";
            prop.setMinValue(0.0).setMaxValue(1.0);
            destroyModuleBase_chance = prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("dysonSwarm", "maxModules", 10000).setRequiresMcRestart(true);
            prop.comment = "The maximum number of modules the dyson swarm can take";
            prop.setMinValue(1).setMaxValue(Integer.MAX_VALUE);
            maxModules = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dysonSwarm", "destroyModuleMaxCPS", 100000.0).setRequiresMcRestart(true);
            prop.comment = "The maximum computation per second that will help prevent modules from collision";
            prop.setMinValue(0.0).setMaxValue(Double.MAX_VALUE);
            destroyModuleMaxCPS = prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("dysonSwarm", "euPerModule", 10000000);
            prop.comment = "How much EU the Dyson Swarm Command Center produces per module per tick. Default is 10,000,000 EU/t";
            prop.setMinValue(1).setMaxValue(Integer.MAX_VALUE);
            euPerModule = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dysonSwarm", "powerFactors", new String[]{"0:1.0", GSConfigDimensions.dimensionIDMakemake + ":0.15", ConfigManagerCore.idDimensionMoon + ":1.0", ConfigManagerMars.dimensionIDMars + ":0.81", ConfigManagerAsteroids.dimensionIDAsteroids + ":0.61", GSConfigDimensions.dimensionIDCentauriBb + ":2.28", GSConfigDimensions.dimensionIDBarnardaC + ":2.31", GSConfigDimensions.dimensionIDKuiperBelt + ":0.16", GSConfigDimensions.dimensionIDEuropa + ":0.44", GSConfigDimensions.dimensionIDIo + ":0.44", GSConfigDimensions.dimensionIDMercury + ":1.61", GSConfigDimensions.dimensionIDPhobos + ":0.81", GSConfigDimensions.dimensionIDVenus + ":1.76", GSConfigDimensions.dimensionIDDeimos + ":0.81", GSConfigDimensions.dimensionIDEnceladus + ":0.32", GSConfigDimensions.dimensionIDCeres + ":0.6", GSConfigDimensions.dimensionIDGanymede + ":0.44", GSConfigDimensions.dimensionIDTitan + ":0.32", GSConfigDimensions.dimensionIDCallisto + ":0.32", GSConfigDimensions.dimensionIDOberon + ":0.23", GSConfigDimensions.dimensionIDProteus + ":0.23", GSConfigDimensions.dimensionIDTriton + ":0.18", GSConfigDimensions.dimensionIDPluto + ":0.16", ConfigHandler.ross128BAID + ":1.12", ConfigHandler.ross128BID + ":1.12", GSConfigDimensions.dimensionIDBarnardaE + ":1.41", GSConfigDimensions.dimensionIDBarnardaF + ":1.26", GSConfigDimensions.dimensionIDHaumea + ":0.15", GSConfigDimensions.dimensionIDVegaB + ":1.98", GSConfigDimensions.dimensionIDTCetiE + ":1.34", GSConfigDimensions.dimensionIDMiranda + ":0.23", "SS_Overworld:1.1", "SS_planet.mars:0.89", "SS_planet.venus:1.94", "SS_planet.jupiter:0.48", "SS_planet.saturn:0.36", "SS_planet.uranus:0.25", "SS_planet.neptune:0.2", "UW_Garden:0.01", "UW_Mining:0.01", "UW_Void:0.01"});
            prop.setRequiresMcRestart(true);
            prop.comment = "Define a power factor for each dimension ID The total energy output of Dyson Swarm multiblocks is multiplied by these values. Format is \"DIMID:FACTOR\" (DIMID for Space Stations is \"SS_unlocalizedNameOfBodyToOrbit\", for Utility Worlds dimensions \"UW_Garden\", \"UW_Mining\" and \"UW_Void\")";
            powerFactors = prop.getStringList();
            propOrder.add(prop.getName());
            prop = config.get("dysonSwarm", "powerFactorDefault", 0.0);
            prop.comment = "If a power factor for a dimensions is not set, this value will be used.";
            prop.setMinValue(0.0);
            powerFactorDefault = prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("dysonSwarm", "coolantConsumption", 3600000);
            prop.comment = "How much coolant is consumed per hour.";
            prop.setMinValue(0);
            coolantConsumption = prop.getInt();
            propOrder.add(prop.getName());
            prop = config.get("dysonSwarm", "coolantFluid", "cryotheum");
            prop.comment = "Name of the coolant";
            Fluid cryotheum = FluidRegistry.getFluid((String)prop.getString()) != null ? FluidRegistry.getFluid((String)prop.getString()) : FluidRegistry.getFluid((String)"ic2coolant");
            coolantFluid = new FluidStack(cryotheum, coolantConsumption);
            propOrder.add(prop.getName());
            config.setCategoryPropertyOrder("general", propOrder);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            GalaxySpace.error("A problem occured while loading the core config!");
            e.printStackTrace();
        }
    }

    static {
        coefficientFuelGenerator = 1;
        coefficientGeothermalGenerator = 1;
        coefficientSolarWindPanel = 1;
        coefficientSolarPanel = 1;
        crystalBossInvisibilityIntervall = 1;
        idSolarRadiation = 29;
        oregenIDs = new String[0];
    }
}

