/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multiblock;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.multitileentity.enums.GT_MultiTileCasing;
import gregtech.api.multitileentity.multiblock.base.Controller;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.api.task.tasks.PollutionTask;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtilityMuTE;
import gregtech.common.tileentities.machines.multiblock.logic.CokeOvenProcessingLogic;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class CokeOven
extends Controller<CokeOven, CokeOvenProcessingLogic> {
    private static IStructureDefinition<CokeOven> STRUCTURE_DEFINITION = null;
    private static final Vec3Impl OFFSET = new Vec3Impl(1, 1, 0);
    private static final String MAIN = "Main";
    private static final int POLLUTION_AMOUNT = 10;

    public CokeOven() {
        this.setElectric(false);
        new PollutionTask<CokeOven>(this).setPollutionPerSecond(10);
    }

    public void construct(ItemStack trigger, boolean hintsOnly) {
        this.buildState.startBuilding(this.getStartingStructureOffset());
        this.buildPiece(MAIN, trigger, hintsOnly, this.buildState.stopBuilding());
    }

    @Override
    public boolean checkMachine() {
        this.buildState.startBuilding(this.getStartingStructureOffset());
        return this.checkPiece(MAIN, this.buildState.stopBuilding());
    }

    public int survivalConstruct(ItemStack trigger, int elementBudget, ISurvivalBuildEnvironment env) {
        this.buildState.startBuilding(this.getStartingStructureOffset());
        return this.survivalBuildPiece(MAIN, trigger, this.buildState.stopBuilding(), elementBudget, env, false);
    }

    @Override
    public short getCasingRegistryID() {
        return 0;
    }

    @Override
    public int getCasingMeta() {
        return GT_MultiTileCasing.CokeOven.getId();
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Coke Oven").addInfo("Used for charcoal").beginStructureBlock(3, 3, 3, true).addCasingInfoExactly("Coke Oven Bricks", 25, false).addPollutionAmount(10).toolTipFinisher(GT_Values.AuthorBlueWeabo);
        return tt;
    }

    @Override
    public Vec3Impl getStartingStructureOffset() {
        return OFFSET;
    }

    @Override
    public IStructureDefinition<CokeOven> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(MAIN, (String[][])new String[][]{{"AAA", "A~A", "AAA"}, {"AAA", "A-A", "AAA"}, {"AAA", "AAA", "AAA"}}).addElement('A', GT_StructureUtilityMuTE.ofMuTECasings(MultiBlockPart.ITEM_IN | MultiBlockPart.ITEM_OUT, GT_MultiTileCasing.CokeOven.getCasing())).build();
        }
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean hasFluidInput() {
        return false;
    }

    @Override
    protected void addTitleTextStyle(ModularWindow.Builder builder, String title) {
        int TAB_PADDING = 3;
        int TITLE_PADDING = 2;
        int titleWidth = 0;
        int titleHeight = 0;
        if (NetworkUtils.isClient()) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            List titleLines = fontRenderer.func_78271_c(title, this.getGUIWidth() - 10);
            titleWidth = titleLines.size() > 1 ? this.getGUIWidth() - 10 : fontRenderer.func_78256_a(title);
            titleHeight = titleLines.size() * fontRenderer.field_78288_b + (titleLines.size() - 1);
        }
        DrawableWidget tab = new DrawableWidget();
        TextWidget text = new TextWidget(title).setDefaultColor(this.getTitleColor()).setTextAlignment(Alignment.CenterLeft).setMaxWidth(titleWidth);
        if (GT_Mod.gregtechproxy.mTitleTabStyle == 1) {
            tab.setDrawable((IDrawable)this.getGUITextureSet().getTitleTabAngular()).setPos(0, -(titleHeight + 3) + 1).setSize(this.getGUIWidth(), titleHeight + 6);
            text.setPos(5, -titleHeight + 3);
        } else {
            tab.setDrawable((IDrawable)this.getGUITextureSet().getTitleTabDark()).setPos(0, -(titleHeight + 6) + 1).setSize(titleWidth + 10, titleHeight + 6 - 1);
            text.setPos(5, -titleHeight);
        }
        ((ModularWindow.Builder)builder.widget((Widget)tab)).widget((Widget)text);
    }

    @Override
    public String getLocalName() {
        return StatCollector.func_74838_a((String)"gt.multiBlock.controller.cokeOven");
    }

    @Override
    @Nonnull
    protected CokeOvenProcessingLogic createProcessingLogic() {
        return new CokeOvenProcessingLogic();
    }
}

