/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_LargeTurbine_GasAdvanced
extends GT_MetaTileEntity_LargeTurbine {
    public GT_MetaTileEntity_LargeTurbine_GasAdvanced(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbine_GasAdvanced(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][colorIndex + 1];
        iTextureArray[1] = aFacing == side ? (aActive ? TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW_ACTIVE5).build() : (this.hasTurbine() ? TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW5).build() : TextureFactory.builder().addIcon(Textures.BlockIcons.LARGETURBINE_NEW_EMPTY5).build())) : Textures.BlockIcons.casingTexturePages[1][57];
        return iTextureArray;
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Gas Turbine").addInfo("Warning: This is an experimental multiblock, subject to changes ").addInfo("Controller block for the Large Advanced Gas Turbine").addInfo("Needs a Turbine, place inside controller").addInfo("Only accepts gases above 800k EU/bucket").addInfo("Has no maximum EU/t output, only depends on the Dynamo Hatch").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 4, true).addController("Front center").addCasingInfoRange("Advanced Gas Turbine Casing", 8, 30, false).addDynamoHatch("Back center", 1).addMaintenanceHatch("Side centered", 2).addMufflerHatch("Side centered", 2).addInputHatch("Gas Fuel, Side centered", 2).toolTipFinisher("Gregtech");
        return tt;
    }

    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null) {
            return 0;
        }
        GT_Recipe tFuel = RecipeMaps.gasTurbineFuels.getBackend().findFuel(aLiquid);
        if (tFuel != null) {
            return tFuel.mSpecialValue;
        }
        return 0;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeTurbine_GasAdvanced(this.mName);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.gasTurbineFuels;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -2;
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings8;
    }

    @Override
    public byte getCasingMeta() {
        return 9;
    }

    @Override
    public int getCasingTextureIndex() {
        return 185;
    }

    @Override
    public boolean isNewStyleRendering() {
        return true;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return GT_Mod.gregtechproxy.mPollutionLargeGasTurbinePerSecond;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, int aOptFlow, int aBaseEff, int overflowMultiplier, float[] flowMultipliers) {
        if (aFluids.size() >= 1) {
            int tEU = 0;
            int actualOptimalFlow = 0;
            FluidStack firstFuelType = new FluidStack(aFluids.get(0), 0);
            int fuelValue = this.getFuelValue(firstFuelType);
            if (fuelValue < 100) {
                return 0;
            }
            if (aOptFlow < fuelValue) {
                this.realOptFlow = 1.0;
                this.depleteInput(new FluidStack(firstFuelType, 1));
                ++this.storedFluid;
                return GT_Utility.safeInt((long)aOptFlow * (long)aBaseEff / 10000L);
            }
            actualOptimalFlow = GT_Utility.safeInt((long)((float)aOptFlow * flowMultipliers[1] / (float)fuelValue));
            this.realOptFlow = actualOptimalFlow;
            int remainingFlow = GT_Utility.safeInt((long)((float)actualOptimalFlow * (1.5f * (float)overflowMultiplier)));
            int flow = 0;
            int totalFlow = 0;
            this.storedFluid = 0;
            for (FluidStack aFluid : aFluids) {
                if (!aFluid.isFluidEqual(firstFuelType)) continue;
                flow = Math.min(aFluid.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluid, flow));
                this.storedFluid += aFluid.amount;
                remainingFlow -= flow;
                totalFlow += flow;
            }
            if (totalFlow <= 0) {
                return 0;
            }
            tEU = GT_Utility.safeInt((long)totalFlow * (long)fuelValue);
            if (totalFlow != actualOptimalFlow) {
                float efficiency = this.getOverflowEfficiency(totalFlow, actualOptimalFlow, overflowMultiplier);
                tEU = (int)((float)tEU * efficiency);
            }
            if ((long)(tEU = GT_Utility.safeInt((long)tEU * (long)aBaseEff / 10000L)) > this.getMaximumOutput()) {
                tEU = GT_Utility.safeInt(this.getMaximumOutput());
            }
            return tEU;
        }
        return 0;
    }

    @Override
    float getOverflowEfficiency(int totalFlow, int actualOptimalFlow, int overflowMultiplier) {
        float efficiency = 0.0f;
        efficiency = totalFlow > actualOptimalFlow ? 1.0f - (float)Math.abs(totalFlow - actualOptimalFlow) / ((float)actualOptimalFlow * (float)(overflowMultiplier * 3 - 1)) : 1.0f - Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
        return efficiency;
    }
}

