/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DrillerBase;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;

public abstract class GT_MetaTileEntity_ConcreteBackfillerBase
extends GT_MetaTileEntity_DrillerBase {
    private int mLastXOff = 0;
    private int mLastZOff = 0;
    private int clientYHead;
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();

    public GT_MetaTileEntity_ConcreteBackfillerBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.initRecipeResults();
    }

    public GT_MetaTileEntity_ConcreteBackfillerBase(String aName) {
        super(aName);
        this.initRecipeResults();
    }

    private void initRecipeResults() {
        this.addResultMessage(2, true, "backfiller_working");
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip(String aStructureName) {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Concrete Backfiller").addInfo("Controller Block for the " + aStructureName).addInfo("Will fill in areas below it with light concrete. This goes through walls").addInfo("Use it to remove any spawning locations beneath your base to reduce lag").addInfo("Will pull back the pipes after it finishes that layer").addInfo("Radius is " + this.getRadius() + " blocks").addSeparator().beginStructureBlock(3, 7, 3, false).addController("Front bottom").addOtherStructurePart(casings, "form the 3x1x3 Base").addOtherStructurePart(casings, "1x3x1 pillar above the center of the base (2 minimum total)").addOtherStructurePart(this.getFrameMaterial().mName + " Frame Boxes", "Each pillar's side and 1x3x1 on top").addEnergyHatch("1x " + GT_Values.VN[this.getMinTier()] + "+, Any base casing", 1).addMaintenanceHatch("Any base casing", 1).addInputBus("Mining Pipes, optional, any base casing", 1).addInputHatch("GT Concrete, any base casing", 1).addOutputBus("Mining Pipes, optional, any base casing", 1).toolTipFinisher("Gregtech");
        return tt;
    }

    protected abstract int getRadius();

    @Override
    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mInputHatches.isEmpty() && this.mEnergyHatches.size() == 1;
    }

    @Override
    protected List<IHatchElement<? super GT_MetaTileEntity_DrillerBase>> getAllowedHatches() {
        return ImmutableList.of((Object)GT_HatchElement.InputHatch, (Object)GT_HatchElement.InputBus, (Object)GT_HatchElement.Maintenance, (Object)GT_HatchElement.Energy);
    }

    @Override
    protected void setElectricityStats() {
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        int tier = Math.max(1, GT_Utility.getTier(this.getMaxInputVoltage()));
        this.mEUt = -6 * (1 << (tier << 1));
        this.mMaxProgresstime = (this.workState == 2 ? 240 : 80) / (1 << tier);
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
    }

    @Override
    protected boolean workingUpward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.isRefillableBlock(xPipe, yHead - 1, zPipe)) {
            return this.tryRefillBlock(xPipe, yHead - 1, zPipe);
        }
        int radius = this.getRadius();
        if (this.mLastXOff == 0 && this.mLastZOff == 0) {
            this.mLastXOff = -radius;
            this.mLastZOff = -radius;
        }
        if (yHead != yDrill) {
            for (int i = this.mLastXOff; i <= radius; ++i) {
                int j;
                int n = j = i == this.mLastXOff ? this.mLastZOff : -radius;
                while (j <= radius) {
                    if (this.isRefillableBlock(xPipe + i, yHead, zPipe + j)) {
                        this.mLastXOff = i;
                        this.mLastZOff = j;
                        return this.tryRefillBlock(xPipe + i, yHead, zPipe + j);
                    }
                    ++j;
                }
            }
        }
        if (this.tryPickPipe()) {
            this.mLastXOff = 0;
            this.mLastZOff = 0;
            return true;
        }
        this.workState = 0;
        this.stopMachine(ShutDownReasonRegistry.NONE);
        this.setShutdownReason(StatCollector.func_74838_a((String)"GT5U.gui.text.backfiller_finished"));
        return false;
    }

    private boolean isRefillableBlock(int aX, int aY, int aZ) {
        IGregTechTileEntity aBaseTile = this.getBaseMetaTileEntity();
        if (!aBaseTile.getBlock(aX, aY, aZ).isAir((IBlockAccess)aBaseTile.getWorld(), aX, aY, aZ) || aBaseTile.getBlock(aX, aY, aZ).func_149688_o().func_76220_a()) {
            return false;
        }
        return GT_Utility.setBlockByFakePlayer(this.getFakePlayer(aBaseTile), aX, aY, aZ, GregTech_API.sBlockConcretes, 8, true);
    }

    private boolean tryRefillBlock(int aX, int aY, int aZ) {
        if (!this.tryConsumeFluid()) {
            this.setRuntimeFailureReason(CheckRecipeResultRegistry.BACKFILLER_NO_CONCRETE);
            return false;
        }
        this.getBaseMetaTileEntity().getWorld().func_147465_d(aX, aY, aZ, GregTech_API.sBlockConcretes, 8, 3);
        return true;
    }

    private boolean tryConsumeFluid() {
        if (!this.depleteInput(Materials.Concrete.getMolten(144L))) {
            this.mMaxProgresstime = 0;
            return false;
        }
        return true;
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> StatCollector.func_74837_a((String)"GT5U.gui.text.backfiller_current_area", (Object[])new Object[]{numberFormat.format((long)this.clientYHead)})).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(widget -> this.getBaseMetaTileEntity().isActive() && this.workState == 2))).widget((Widget)new FakeSyncWidget.IntegerSyncer(this::getYHead, newInt -> {
            this.clientYHead = newInt;
        }))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.workState, newInt -> {
            this.workState = newInt;
        }));
    }
}

