/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTech_API;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.covers.redstone.GT_Cover_AdvancedRedstoneReceiverBase;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_NumericWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_ToggleButtonWidget;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public abstract class GT_Cover_AdvancedWirelessRedstoneBase<T extends WirelessData>
extends GT_CoverBehaviorBase<T> {
    public GT_Cover_AdvancedWirelessRedstoneBase(Class<T> typeToken, ITexture coverTexture) {
        super(typeToken, coverTexture);
    }

    public static Byte getSignalAt(UUID uuid, int frequency, GT_Cover_AdvancedRedstoneReceiverBase.GateMode mode) {
        Map<Integer, Map<Long, Byte>> frequencies = GregTech_API.sAdvancedWirelessRedstone.get(String.valueOf(uuid));
        if (frequencies == null) {
            return (byte)0;
        }
        Map<Long, Byte> signals = frequencies.get(frequency);
        if (signals == null) {
            signals = new ConcurrentHashMap<Long, Byte>();
        }
        switch (mode) {
            case AND: {
                return (byte)(signals.values().stream().map(signal -> signal > 0).reduce(true, (signalA, signalB) -> signalA != false && signalB != false) != false ? 15 : 0);
            }
            case NAND: {
                return (byte)(signals.values().stream().map(signal -> signal > 0).reduce(true, (signalA, signalB) -> signalA != false && signalB != false) != false ? 0 : 15);
            }
            case OR: {
                return (byte)(signals.values().stream().map(signal -> signal > 0).reduce(false, (signalA, signalB) -> signalA != false || signalB != false) != false ? 15 : 0);
            }
            case NOR: {
                return (byte)(signals.values().stream().map(signal -> signal > 0).reduce(false, (signalA, signalB) -> signalA != false || signalB != false) != false ? 0 : 15);
            }
            case SINGLE_SOURCE: {
                if (signals.values().isEmpty()) {
                    return (byte)0;
                }
                return signals.values().iterator().next();
            }
        }
        return (byte)0;
    }

    public static void removeSignalAt(UUID uuid, int frequency, long hash) {
        Map<Integer, Map<Long, Byte>> frequencies = GregTech_API.sAdvancedWirelessRedstone.get(String.valueOf(uuid));
        if (frequencies == null) {
            return;
        }
        frequencies.computeIfPresent(frequency, (freq, longByteMap) -> {
            longByteMap.remove(hash);
            return longByteMap.isEmpty() ? null : longByteMap;
        });
    }

    public static void setSignalAt(UUID uuid, int frequency, long hash, byte value) {
        Map frequencies = GregTech_API.sAdvancedWirelessRedstone.computeIfAbsent(String.valueOf(uuid), k -> new ConcurrentHashMap());
        Map signals = frequencies.computeIfAbsent(frequency, k -> new ConcurrentHashMap());
        signals.put(hash, value);
    }

    public static long hashCoverCoords(ICoverable tile, ForgeDirection side) {
        return (((((long)tile.getXCoord() << 20) + (long)tile.getZCoord() << 10) + (long)tile.getYCoord() << 10) + (long)tile.getWorld().field_73011_w.field_76574_g << 4) + (long)side.ordinal();
    }

    @Override
    public boolean letsEnergyInImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOutImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidInImpl(ForgeDirection side, int aCoverID, T aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOutImpl(ForgeDirection side, int aCoverID, T aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsInImpl(ForgeDirection side, int aCoverID, T aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOutImpl(ForgeDirection side, int aCoverID, T aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public String getDescriptionImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return GT_Utility.trans("081", "Frequency: ") + ((WirelessData)aCoverVariable).frequency + ", Transmission: " + (((WirelessData)aCoverVariable).uuid == null ? "Public" : "Private");
    }

    @Override
    public int getTickRateImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return 5;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    public static abstract class WirelessData
    implements ISerializableObject {
        protected int frequency;
        protected UUID uuid;

        public WirelessData(int frequency, UUID uuid) {
            this.frequency = frequency;
            this.uuid = uuid;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public int getFrequency() {
            return this.frequency;
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("frequency", this.frequency);
            if (this.uuid != null) {
                tag.func_74778_a("uuid", this.uuid.toString());
            }
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeInt(this.frequency);
            aBuf.writeBoolean(this.uuid != null);
            if (this.uuid != null) {
                aBuf.writeLong(this.uuid.getLeastSignificantBits());
                aBuf.writeLong(this.uuid.getMostSignificantBits());
            }
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.frequency = tag.func_74762_e("frequency");
            if (tag.func_74764_b("uuid")) {
                this.uuid = UUID.fromString(tag.func_74779_i("uuid"));
            }
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            this.frequency = aBuf.readInt();
            if (aBuf.readBoolean()) {
                this.uuid = new UUID(aBuf.readLong(), aBuf.readLong());
            }
            return this;
        }
    }

    protected abstract class AdvancedWirelessRedstoneBaseUIFactory
    extends GT_CoverBehaviorBase.UIFactory {
        protected static final int startX = 10;
        protected static final int startY = 25;
        protected static final int spaceX = 18;
        protected static final int spaceY = 18;

        public AdvancedWirelessRedstoneBaseUIFactory(GT_CoverUIBuildContext buildContext) {
            super(GT_Cover_AdvancedWirelessRedstoneBase.this, buildContext);
        }

        @Override
        protected int getGUIWidth() {
            return 250;
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            int privateExtraColumn = this.isShiftPrivateLeft() ? 1 : 5;
            CoverDataControllerWidget<WirelessData> dataController = new CoverDataControllerWidget<WirelessData>(this::getCoverData, this::setCoverData, GT_Cover_AdvancedWirelessRedstoneBase.this);
            dataController.setPos(10, 25);
            this.addUIForDataController(dataController);
            ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(dataController)).widget(new TextWidget(GT_Utility.trans("246", "Frequency")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(100, 29 + 18 * this.getFrequencyRow()))).widget(new TextWidget(GT_Utility.trans("602", "Use Private Frequency")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(10 + 18 * privateExtraColumn, 29 + 18 * this.getButtonRow()));
        }

        protected void addUIForDataController(CoverDataControllerWidget<T> controller) {
            ((CoverDataControllerWidget)controller.addFollower((Widget)new CoverDataFollower_NumericWidget(), coverData -> coverData.frequency, (coverData, state) -> {
                coverData.frequency = state.intValue();
                return coverData;
            }, widget -> widget.setScrollValues(1.0, 1000.0, 10.0).setBounds(0.0, 2.147483647E9).setPos(1, 2 + 18 * this.getFrequencyRow()).setSize(86, 12))).addFollower((Widget)CoverDataFollower_ToggleButtonWidget.ofCheck(), coverData -> coverData.uuid != null, (coverData, state) -> {
                coverData.uuid = state != false ? this.getUIBuildContext().getPlayer().func_110124_au() : null;
                return coverData;
            }, widget -> widget.setPos(0, 18 * this.getButtonRow()));
        }

        protected abstract int getFrequencyRow();

        protected abstract int getButtonRow();

        protected abstract boolean isShiftPrivateLeft();
    }
}

