/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_ToggleButtonWidget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_NeedMaintainance
extends GT_CoverBehavior {
    public GT_Cover_NeedMaintainance(ITexture coverTexture) {
        super(coverTexture);
    }

    public static boolean isRotor(ItemStack rotor) {
        return rotor != null && rotor.func_77973_b() instanceof GT_MetaGenerated_Tool && rotor.func_77960_j() >= 170 && rotor.func_77960_j() <= 176;
    }

    @Override
    public boolean isRedstoneSensitive(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        IGregTechTileEntity tTileEntity;
        IMetaTileEntity mTileEntity;
        boolean needsRepair = false;
        if (aTileEntity instanceof IGregTechTileEntity && (mTileEntity = (tTileEntity = (IGregTechTileEntity)aTileEntity).getMetaTileEntity()) instanceof GT_MetaTileEntity_MultiBlockBase) {
            GT_MetaTileEntity_MultiBlockBase multi = (GT_MetaTileEntity_MultiBlockBase)mTileEntity;
            int ideal = multi.getIdealStatus();
            int real = multi.getRepairStatus();
            ItemStack tRotor = multi.getRealInventory()[1];
            int coverVar = aCoverVariable >>> 1;
            if (coverVar < 5) {
                if (ideal - real > coverVar) {
                    needsRepair = true;
                }
            } else if (coverVar == 5 || coverVar == 6) {
                if (GT_Cover_NeedMaintainance.isRotor(tRotor)) {
                    long mExpectedDamage;
                    long tMax = GT_MetaGenerated_Tool.getToolMaxDamage(tRotor);
                    long tCur = GT_MetaGenerated_Tool.getToolDamage(tRotor);
                    needsRepair = coverVar == 5 ? tCur >= tMax * 8L / 10L : tCur + (mExpectedDamage = Math.round(Math.min((double)(multi.mEUt / multi.damageFactorLow), Math.pow(multi.mEUt, multi.damageFactorHigh)))) * 2L >= tMax;
                } else {
                    needsRepair = true;
                }
            }
        }
        if (aCoverVariable % 2 == 0) {
            needsRepair = !needsRepair;
        }
        aTileEntity.setOutputRedstoneSignal(side, (byte)(needsRepair ? 0 : 15));
        aTileEntity.setOutputRedstoneSignal(side.getOpposite(), (byte)(needsRepair ? 0 : 15));
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 14) < 0) {
            aCoverVariable = 13;
        }
        switch (aCoverVariable) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("056", "Emit if 1 Maintenance Needed"));
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("057", "Emit if 1 Maintenance Needed(inverted)"));
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("058", "Emit if 2 Maintenance Needed"));
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("059", "Emit if 2 Maintenance Needed(inverted)"));
                break;
            }
            case 4: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("060", "Emit if 3 Maintenance Needed"));
                break;
            }
            case 5: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("061", "Emit if 3 Maintenance Needed(inverted)"));
                break;
            }
            case 6: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("062", "Emit if 4 Maintenance Needed"));
                break;
            }
            case 7: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("063", "Emit if 4 Maintenance Needed(inverted)"));
                break;
            }
            case 8: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("064", "Emit if 5 Maintenance Needed"));
                break;
            }
            case 9: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("065", "Emit if 5 Maintenance Needed(inverted)"));
                break;
            }
            case 10: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("066", "Emit if rotor needs maintenance low accuracy mod"));
                break;
            }
            case 11: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("067", "Emit if rotor needs maintenance low accuracy mod(inverted)"));
                break;
            }
            case 12: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("068", "Emit if rotor needs maintenance high accuracy mod"));
                break;
            }
            case 13: {
                GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("069", "Emit if rotor needs maintenance high accuracy mod(inverted)"));
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsEnergyIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 60;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new NeedMaintainanceUIFactory(buildContext).createWindow();
    }

    private class NeedMaintainanceUIFactory
    extends GT_CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public NeedMaintainanceUIFactory(GT_CoverUIBuildContext buildContext) {
            super(GT_Cover_NeedMaintainance.this, buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            String[] tooltipText = new String[]{GT_Utility.trans("056", "Emit if 1 Maintenance Needed"), GT_Utility.trans("058", "Emit if 2 Maintenance Needed"), GT_Utility.trans("060", "Emit if 3 Maintenance Needed"), GT_Utility.trans("062", "Emit if 4 Maintenance Needed"), GT_Utility.trans("064", "Emit if 5 Maintenance Needed"), GT_Utility.trans("066", "Emit if rotor needs maintenance low accuracy mod"), GT_Utility.trans("068", "Emit if rotor needs maintenance high accuracy mod")};
            String[] buttonText = new String[]{GT_Utility.trans("247", "1 Issue"), GT_Utility.trans("248", "2 Issues"), GT_Utility.trans("249", "3 Issues"), GT_Utility.trans("250", "4 Issues"), GT_Utility.trans("251", "5 Issues"), GT_Utility.trans("252", "Rotor < 80%"), GT_Utility.trans("253", "Rotor < 100%"), GT_Utility.trans("INVERTED", "Inverted"), GT_Utility.trans("NORMAL", "Normal")};
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<ISerializableObject.LegacyCoverData>(this::getCoverData, this::setCoverData, GT_Cover_NeedMaintainance.this, (index, coverData) -> this.isEnabled((int)index, GT_Cover_NeedMaintainance.convert(coverData)), (index, coverData) -> new ISerializableObject.LegacyCoverData(this.getNewCoverVariable((int)index, GT_Cover_NeedMaintainance.convert(coverData)))).addToggleButton(0, CoverDataFollower_ToggleButtonWidget.ofCheck(), widget -> widget.addTooltip(tooltipText[0]).setPos(0, 0)).addToggleButton(1, CoverDataFollower_ToggleButtonWidget.ofCheck(), widget -> widget.addTooltip(tooltipText[1]).setPos(0, 18)).addToggleButton(2, CoverDataFollower_ToggleButtonWidget.ofCheck(), widget -> widget.addTooltip(tooltipText[2]).setPos(0, 36)).addToggleButton(3, CoverDataFollower_ToggleButtonWidget.ofCheck(), widget -> widget.addTooltip(tooltipText[3]).setPos(0, 54)).addToggleButton(4, CoverDataFollower_ToggleButtonWidget.ofCheck(), widget -> widget.addTooltip(tooltipText[4]).setPos(76, 0)).addToggleButton(5, CoverDataFollower_ToggleButtonWidget.ofCheck(), widget -> widget.addTooltip(tooltipText[5]).setPos(76, 18)).addToggleButton(6, CoverDataFollower_ToggleButtonWidget.ofCheck(), widget -> widget.addTooltip(tooltipText[6]).setPos(76, 36)).addToggleButton(7, CoverDataFollower_ToggleButtonWidget.ofRedstone(), widget -> widget.setPos(76, 54)).setPos(10, 25))).widget(new TextWidget(buttonText[0]).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 29))).widget(new TextWidget(buttonText[1]).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 47))).widget(new TextWidget(buttonText[2]).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 65))).widget(new TextWidget(buttonText[3]).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 83))).widget(new TextWidget(buttonText[4]).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(104, 29))).widget(new TextWidget(buttonText[5]).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(104, 47))).widget(new TextWidget(buttonText[6]).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(104, 65))).widget(TextWidget.dynamicString(() -> this.isEnabled(7, GT_Cover_NeedMaintainance.convert((ISerializableObject.LegacyCoverData)this.getCoverData())) ? buttonText[7] : buttonText[8]).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(104, 83));
        }

        private int getNewCoverVariable(int id, int coverVariable) {
            boolean checked;
            boolean bl = checked = (coverVariable & 1) > 0;
            if (id == 7) {
                if (checked) {
                    return coverVariable & 0xFFFFFFFE;
                }
                return coverVariable | 1;
            }
            return coverVariable & 1 | id << 1;
        }

        private boolean isEnabled(int id, int coverVariable) {
            if (id == 7) {
                return (coverVariable & 1) > 0;
            }
            return coverVariable >>> 1 == id;
        }
    }
}

