/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.maps;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapBackendPropertiesBuilder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FormingPressBackend
extends RecipeMapBackend {
    public FormingPressBackend(RecipeMapBackendPropertiesBuilder propertiesBuilder) {
        super(propertiesBuilder);
    }

    @Override
    protected GT_Recipe modifyFoundRecipe(GT_Recipe recipe, ItemStack[] items, FluidStack[] fluids, @Nullable ItemStack specialSlot) {
        for (ItemStack mold : items) {
            if (!ItemList.Shape_Mold_Credit.isStackEqual(mold, false, true)) continue;
            NBTTagCompound nbt = mold.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            if (!nbt.func_74764_b("credit_security_id")) {
                nbt.func_74772_a("credit_security_id", System.nanoTime());
            }
            mold.func_77982_d(nbt);
            recipe = recipe.copy();
            recipe.mCanBeBuffered = false;
            recipe.mOutputs[0].func_77982_d(nbt);
            return recipe;
        }
        return recipe;
    }

    @Override
    protected GT_Recipe findFallback(ItemStack[] items, FluidStack[] fluids, @Nullable ItemStack specialSlot) {
        if (items.length < 2) {
            return null;
        }
        return this.findRenamingRecipe(items);
    }

    @Nullable
    private GT_Recipe findRenamingRecipe(ItemStack[] inputs) {
        ItemStack mold = this.findNameMoldIndex(inputs);
        if (mold == null) {
            return null;
        }
        ItemStack input = this.findStackToRename(inputs, mold);
        if (input == null) {
            return null;
        }
        ItemStack output = GT_Utility.copyAmount(1, input);
        if (output == null) {
            return null;
        }
        output.func_151001_c(mold.func_82833_r());
        return GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(0, mold), GT_Utility.copyAmount(1, input)).itemOutputs(output).duration(128).eut(8).noBuffer().nbtSensitive().build().orElse(null);
    }

    @Nullable
    private ItemStack findNameMoldIndex(ItemStack[] inputs) {
        for (ItemStack stack : inputs) {
            if (!ItemList.Shape_Mold_Name.isStackEqual(stack, false, true)) continue;
            return stack;
        }
        return null;
    }

    @Nullable
    private ItemStack findStackToRename(ItemStack[] inputs, ItemStack mold) {
        for (ItemStack stack : inputs) {
            if (stack == mold || stack == null) continue;
            return stack;
        }
        return null;
    }
}

