/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.Locale;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public enum RecipeCategorySetting {
    ENABLE,
    MERGE,
    HIDE;

    public static final RecipeCategorySetting[] VALUES;
    public static final String[] NAMES;

    public static RecipeCategorySetting getDefault() {
        return ENABLE;
    }

    public String toName() {
        return this.toString().toLowerCase(Locale.ENGLISH);
    }

    public static RecipeCategorySetting find(String name) {
        for (RecipeCategorySetting setting : VALUES) {
            if (!setting.toName().equals(name)) continue;
            return setting;
        }
        return RecipeCategorySetting.getDefault();
    }

    static {
        VALUES = RecipeCategorySetting.values();
        NAMES = (String[])Stream.of(VALUES).map(RecipeCategorySetting::toName).toArray(String[]::new);
    }
}

