/*
 * Decompiled with CFR 0.152.
 */
package pers.gwyog.gtneioreplugin.plugin.gregtech5;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_OreDictUnificator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import pers.gwyog.gtneioreplugin.plugin.gregtech5.PluginGT5Base;
import pers.gwyog.gtneioreplugin.plugin.item.ItemDimensionDisplay;
import pers.gwyog.gtneioreplugin.util.DimensionHelper;
import pers.gwyog.gtneioreplugin.util.GT5OreSmallHelper;

public class PluginGT5SmallOreStat
extends PluginGT5Base {
    private static final int SMALL_ORE_BASE_META = 16000;

    public void drawExtras(int recipe) {
        GT5OreSmallHelper.OreSmallWrapper oreSmall = this.getSmallOre(recipe);
        this.drawSmallOreName(oreSmall);
        this.drawSmallOreInfo(oreSmall);
        this.drawDimNames();
        this.drawSeeAllRecipesLabel();
    }

    private void drawSmallOreName(GT5OreSmallHelper.OreSmallWrapper oreSmall) {
        String oreName = PluginGT5SmallOreStat.getGTOreLocalizedName((short)(oreSmall.oreMeta + 16000));
        PluginGT5SmallOreStat.drawLine("gtnop.gui.nei.oreName", oreName, 2, 18);
    }

    private void drawSmallOreInfo(GT5OreSmallHelper.OreSmallWrapper oreSmall) {
        PluginGT5SmallOreStat.drawLine("gtnop.gui.nei.genHeight", oreSmall.worldGenHeightRange, 2, 31);
        PluginGT5SmallOreStat.drawLine("gtnop.gui.nei.amount", String.valueOf(oreSmall.amountPerChunk), 2, 44);
        PluginGT5SmallOreStat.drawLine("gtnop.gui.nei.chanceDrops", "", 2, 83 + this.getRestrictBiomeOffset());
        PluginGT5SmallOreStat.drawLine("gtnop.gui.nei.worldNames", "", 2, 100);
    }

    private GT5OreSmallHelper.OreSmallWrapper getSmallOre(int recipe) {
        CachedOreSmallRecipe crecipe = (CachedOreSmallRecipe)((Object)this.arecipes.get(recipe));
        return GT5OreSmallHelper.mapOreSmallWrapper.get(crecipe.oreGenName);
    }

    public int getRestrictBiomeOffset() {
        return GT5OreSmallHelper.restrictBiomeSupport ? 0 : -13;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOutputId())) {
            for (ItemStack stack : GT5OreSmallHelper.oreSmallList) {
                this.loadCraftingRecipes(stack);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack stack) {
        if (stack.func_77977_a().startsWith("gt.blockores")) {
            short oreMeta = (short)(stack.func_77960_j() % 1000);
            this.loadSmallOre(oreMeta, this.getMaximumMaterialIndex(oreMeta, true));
        } else if (GT5OreSmallHelper.mapOreDropUnlocalizedNameToOreMeta.containsKey(stack.func_77977_a())) {
            short oreMeta = GT5OreSmallHelper.mapOreDropUnlocalizedNameToOreMeta.get(stack.func_77977_a());
            this.loadSmallOre(oreMeta, 7);
        } else {
            super.loadCraftingRecipes(stack);
        }
    }

    public void loadUsageRecipes(ItemStack stack) {
        String dimension = ItemDimensionDisplay.getDimension(stack);
        if (dimension == null) {
            return;
        }
        for (GT5OreSmallHelper.OreSmallWrapper oreVein : GT5OreSmallHelper.mapOreSmallWrapper.values()) {
            if (!Arrays.asList(this.getDimNameArrayFromVeinName(oreVein.oreGenName)).contains(dimension)) continue;
            this.addSmallOre(oreVein, 7);
        }
    }

    private void loadSmallOre(short oreMeta, int maximumIndex) {
        GT5OreSmallHelper.OreSmallWrapper smallOre = this.getSmallOre(oreMeta);
        if (smallOre != null) {
            this.addSmallOre(smallOre, maximumIndex);
        }
    }

    private GT5OreSmallHelper.OreSmallWrapper getSmallOre(short oreMeta) {
        for (GT5OreSmallHelper.OreSmallWrapper oreSmallWorldGen : GT5OreSmallHelper.mapOreSmallWrapper.values()) {
            if (oreSmallWorldGen.oreMeta != oreMeta) continue;
            return oreSmallWorldGen;
        }
        return null;
    }

    private void addSmallOre(GT5OreSmallHelper.OreSmallWrapper smallOre, int maximumIndex) {
        this.arecipes.add(new CachedOreSmallRecipe(smallOre.oreGenName, smallOre.getMaterialDrops(maximumIndex), this.getStoneDusts(maximumIndex), GT5OreSmallHelper.mapOreMetaToOreDrops.get(smallOre.oreMeta)));
    }

    private List<ItemStack> getStoneDusts(int maximumIndex) {
        ArrayList<ItemStack> materialDustStackList = new ArrayList<ItemStack>();
        for (int i = 0; i < maximumIndex; ++i) {
            materialDustStackList.add(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)GT5OreSmallHelper.getDroppedDusts()[i], (long)1L));
        }
        return materialDustStackList;
    }

    @Override
    public String getOutputId() {
        return "GTOrePluginOreSmall";
    }

    @Override
    public String getRecipeName() {
        return I18n.func_135052_a((String)"gtnop.gui.smallOreStat.name", (Object[])new Object[0]);
    }

    private String[] getDimNameArrayFromVeinName(String veinName) {
        GT5OreSmallHelper.OreSmallWrapper oreSmall = GT5OreSmallHelper.mapOreSmallWrapper.get(veinName);
        String[] dims = DimensionHelper.parseDimNames(GT5OreSmallHelper.bufferedDims.get(oreSmall));
        Arrays.sort(dims, Comparator.comparingInt(s -> Arrays.asList(DimensionHelper.DimNameDisplayed).indexOf(s)));
        return dims;
    }

    public class CachedOreSmallRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final String oreGenName;
        public final PositionedStack positionedStackOreSmall;
        public final PositionedStack positionedStackMaterialDust;
        public final List<PositionedStack> positionedDropStackList;
        private final List<PositionedStack> dimensionDisplayItems;

        public CachedOreSmallRecipe(String oreGenName, List<ItemStack> stackList, List<ItemStack> materialDustStackList, List<ItemStack> dropStackList) {
            super((TemplateRecipeHandler)PluginGT5SmallOreStat.this);
            this.dimensionDisplayItems = new ArrayList<PositionedStack>();
            this.oreGenName = oreGenName;
            this.positionedStackOreSmall = new PositionedStack(stackList, 2, 0);
            this.positionedStackMaterialDust = new PositionedStack(materialDustStackList, 43, 79 + PluginGT5SmallOreStat.this.getRestrictBiomeOffset());
            ArrayList<PositionedStack> positionedDropStackList = new ArrayList<PositionedStack>();
            int i = 1;
            for (ItemStack stackDrop : dropStackList) {
                positionedDropStackList.add(new PositionedStack((Object)stackDrop, 43 + 20 * (i % 4), 79 + 16 * (i++ / 4) + PluginGT5SmallOreStat.this.getRestrictBiomeOffset()));
            }
            this.positionedDropStackList = positionedDropStackList;
            this.setDimensionDisplayItems();
        }

        private void setDimensionDisplayItems() {
            int x = 2;
            int y = 110;
            int count = 0;
            int itemsPerLine = 9;
            int itemSize = 18;
            for (String dim : PluginGT5SmallOreStat.this.getDimNameArrayFromVeinName(this.oreGenName)) {
                ItemStack item = ItemDimensionDisplay.getItem(dim);
                if (item == null) continue;
                int xPos = x + itemSize * (count % itemsPerLine);
                int yPos = y + itemSize * (count / itemsPerLine);
                this.dimensionDisplayItems.add(new PositionedStack((Object)item, xPos, yPos, false));
                ++count;
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.dimensionDisplayItems;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> outputs = new ArrayList<PositionedStack>();
            this.positionedStackOreSmall.setPermutationToRender(PluginGT5SmallOreStat.this.cycleticks / 20 % this.positionedStackOreSmall.items.length);
            this.positionedStackMaterialDust.setPermutationToRender(PluginGT5SmallOreStat.this.cycleticks / 20 % this.positionedStackMaterialDust.items.length);
            outputs.add(this.positionedStackOreSmall);
            outputs.add(this.positionedStackMaterialDust);
            outputs.addAll(this.positionedDropStackList);
            return outputs;
        }
    }
}

