/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders.recipe;

import binnie.extratrees.genetics.ExtraTreeSpecies;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IIndividual;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.plugins.PluginArboriculture;
import gregtech.api.enums.Mods;
import gregtech.api.util.GT_ModHandler;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.GregtechMetaTileEntityTreeFarm;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RecipeLoader_TreeFarm {
    public static void generateRecipes() {
        RecipeLoader_TreeFarm.generateVanillaTrees();
        if (Mods.IndustrialCraft2.isModLoaded()) {
            RecipeLoader_TreeFarm.generateIC2Trees();
        }
        if (Mods.TinkerConstruct.isModLoaded()) {
            RecipeLoader_TreeFarm.generateTinkersTrees();
        }
        if (Mods.GTPlusPlus.isModLoaded()) {
            RecipeLoader_TreeFarm.generateGTPPTrees();
        }
        if (Mods.TwilightForest.isModLoaded()) {
            RecipeLoader_TreeFarm.generateTwilightForestTrees();
        }
        if (Mods.GalaxySpace.isModLoaded()) {
            RecipeLoader_TreeFarm.generateGalaxySpaceTrees();
        }
        if (Mods.GalacticraftAmunRa.isModLoaded()) {
            RecipeLoader_TreeFarm.generateAmunRaTrees();
        }
        if (Mods.Thaumcraft.isModLoaded()) {
            RecipeLoader_TreeFarm.generateThaumcraftTrees();
        }
        if (Mods.ThaumicBases.isModLoaded()) {
            RecipeLoader_TreeFarm.generateThaumicBasesTrees();
        }
        if (Mods.TaintedMagic.isModLoaded()) {
            RecipeLoader_TreeFarm.generateTaintedMagicTrees();
        }
        if (Mods.ForbiddenMagic.isModLoaded()) {
            RecipeLoader_TreeFarm.generateForbiddenMagicTrees();
        }
        if (Mods.Witchery.isModLoaded()) {
            RecipeLoader_TreeFarm.generateWitcheryTrees();
        }
        if (Mods.Natura.isModLoaded()) {
            RecipeLoader_TreeFarm.generateNaturaTrees();
        }
        if (Mods.BiomesOPlenty.isModLoaded()) {
            RecipeLoader_TreeFarm.generateBOPTrees();
        }
        if (Mods.PamsHarvestCraft.isModLoaded()) {
            RecipeLoader_TreeFarm.generatePamsTrees();
        }
        if (Mods.PamsHarvestTheNether.isModLoaded()) {
            RecipeLoader_TreeFarm.generatePamsNetherTrees();
        }
        if (Mods.Forestry.isModLoaded()) {
            RecipeLoader_TreeFarm.generateForestryTrees();
        }
        if (Mods.ExtraTrees.isModLoaded()) {
            RecipeLoader_TreeFarm.generateExtraTreesTrees();
        }
    }

    private static void generateVanillaTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(new ItemStack(Blocks.field_150345_g, 1, 0), new ItemStack(Blocks.field_150364_r, 1, 0), new ItemStack((Block)Blocks.field_150362_t, 1, 0), new ItemStack(Items.field_151034_e, 1, 0));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(new ItemStack(Blocks.field_150345_g, 1, 1), new ItemStack(Blocks.field_150364_r, 2, 1), new ItemStack((Block)Blocks.field_150362_t, 1, 1), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(new ItemStack(Blocks.field_150345_g, 1, 2), new ItemStack(Blocks.field_150364_r, 1, 2), new ItemStack((Block)Blocks.field_150362_t, 1, 2), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(new ItemStack(Blocks.field_150345_g, 1, 3), new ItemStack(Blocks.field_150364_r, 2, 3), new ItemStack((Block)Blocks.field_150362_t, 1, 3), new ItemStack(Items.field_151100_aR, 1, 3));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(new ItemStack(Blocks.field_150345_g, 1, 4), new ItemStack(Blocks.field_150363_s, 1, 0), new ItemStack((Block)Blocks.field_150361_u, 1, 0), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(new ItemStack(Blocks.field_150345_g, 1, 5), new ItemStack(Blocks.field_150363_s, 1, 1), new ItemStack((Block)Blocks.field_150361_u, 1, 1), new ItemStack(Items.field_151034_e, 1, 0));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(new ItemStack((Block)Blocks.field_150338_P, 1, 0), new ItemStack(Blocks.field_150420_aW, 1, 0), null, null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(new ItemStack((Block)Blocks.field_150337_Q, 1, 0), new ItemStack(Blocks.field_150419_aX, 1, 0), null, null);
    }

    private static void generateIC2Trees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockRubSapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockRubWood", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"blockRubLeaves", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemHarz", (long)1L, (int)0));
    }

    private static void generateTinkersTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"slime.sapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"slime.gel", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"slime.leaves", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"strangeFood", (long)1L, (int)0));
    }

    private static void generateGTPPTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"blockRainforestOakSapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"blockRainforestOakLog", (long)3L, (int)0), GT_ModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"blockRainforestOakLeaves", (long)1L, (int)0), new ItemStack(Items.field_151034_e, 1, 0));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"blockPineSapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"blockPineLogLog", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"blockPineLeaves", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.GTPlusPlus.ID, (String)"item.BasicAgrichemItem", (long)1L, (int)24));
    }

    private static void generateTwilightForestTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFSapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLog", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLeaves", (long)1L, (int)0), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFSapling", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLog", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLeaves", (long)1L, (int)1), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFSapling", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLog", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLeaves", (long)1L, (int)2), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFSapling", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLog", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.DarkLeaves", (long)1L, (int)0), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFSapling", (long)1L, (int)4), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLog", (long)4L, (int)0), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFSapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLeaves", (long)1L, (int)0), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFSapling", (long)1L, (int)5), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFMagicLog", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFMagicLeaves", (long)1L, (int)0), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFSapling", (long)1L, (int)6), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFMagicLog", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFMagicLeaves", (long)1L, (int)1), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFSapling", (long)1L, (int)8), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFMagicLog", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFMagicLeaves", (long)1L, (int)3), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFSapling", (long)1L, (int)9), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLog", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLeaves", (long)1L, (int)3), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFThorns", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFThorns", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFThorns", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLeaves3", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFThornRose", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"item.magicBeans", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.HugeStalk", (long)5L, (int)0), GT_ModHandler.getModItem((String)Mods.TwilightForest.ID, (String)"tile.TFLeaves3", (long)1L, (int)1), null);
    }

    private static void generateGalaxySpaceTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.GalaxySpace.ID, (String)"barnardaCsapling", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.GalaxySpace.ID, (String)"barnardaClog", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.GalaxySpace.ID, (String)"barnardaCleaves", (long)1L, (int)0), null);
    }

    private static void generateAmunRaTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.GalacticraftAmunRa.ID, (String)"tile.saplings", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.GalacticraftAmunRa.ID, (String)"tile.log1", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.GalacticraftAmunRa.ID, (String)"tile.null", (long)1L, (int)0), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.GalacticraftAmunRa.ID, (String)"tile.saplings", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.GalacticraftAmunRa.ID, (String)"tile.wood1", (long)1L, (int)0), null, GT_ModHandler.getModItem((String)Mods.GalacticraftAmunRa.ID, (String)"tile.wood1", (long)1L, (int)1));
    }

    private static void generateNaturaTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"florasapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"redwood", (long)5L, (int)1), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"florasapling", (long)2L, (int)0), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"floraleaves", (long)2L, (int)0), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"redwood", (long)2L, (int)0));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"florasapling", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"tree", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"floraleaves", (long)1L, (int)1), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"florasapling", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"tree", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"floraleaves", (long)1L, (int)2), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"florasapling", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"tree", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"floraleavesnocolor", (long)1L, (int)0), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"florasapling", (long)1L, (int)4), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"tree", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"floraleavesnocolor", (long)1L, (int)1), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"florasapling", (long)1L, (int)5), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"bloodwood", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"floraleavesnocolor", (long)1L, (int)2), new ItemStack(Items.field_151137_ax, 1, 0));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"florasapling", (long)1L, (int)6), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Dark Tree", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Dark Leaves", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Natura.netherfood", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"florasapling", (long)1L, (int)7), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Dark Tree", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Dark Leaves", (long)1L, (int)3), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Sapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Tree", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Leaves", (long)1L, (int)0), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Sapling", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Tree", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Leaves", (long)1L, (int)1), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Sapling", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Tree", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Leaves", (long)1L, (int)2), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Sapling", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Tree", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Leaves", (long)1L, (int)3), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Rare Sapling", (long)1L, (int)4), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"willow", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"floraleavesnocolor", (long)1L, (int)3), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Glowshroom", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"greenGlowshroom", (long)1L, (int)0), null, null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Glowshroom", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"purpleGlowshroom", (long)1L, (int)0), null, null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"Glowshroom", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.Natura.ID, (String)"blueGlowshroom", (long)1L, (int)0), null, null);
    }

    private static void generateBOPTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)0), new ItemStack(Blocks.field_150364_r, 1, 0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"appleLeaves", (long)1L, (int)0), new ItemStack(Items.field_151034_e, 2, 0));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)1), new ItemStack(Blocks.field_150364_r, 1, 2), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves1", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"food", (long)1L, (int)8));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"bamboo", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves1", (long)1L, (int)9), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs2", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves1", (long)1L, (int)2), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)4), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs1", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves1", (long)1L, (int)3), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)5), new ItemStack(Blocks.field_150364_r, 1, 0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves2", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"food", (long)1L, (int)8));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)6), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs1", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves2", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"misc", (long)1L, (int)13));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)7), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs2", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves2", (long)1L, (int)2), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)8), new ItemStack(Blocks.field_150363_s, 1, 1), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves2", (long)1L, (int)3), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)9), new ItemStack(Blocks.field_150364_r, 1, 0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves3", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"food", (long)1L, (int)8));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)10), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs1", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves3", (long)1L, (int)1), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)11), new ItemStack(Blocks.field_150364_r, 1, 0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves3", (long)1L, (int)2), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)12), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs1", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves3", (long)1L, (int)3), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)13), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs4", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves4", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"food", (long)1L, (int)8));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)14), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs4", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"leaves4", (long)1L, (int)1), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"saplings", (long)1L, (int)15), new ItemStack(Blocks.field_150364_r, 1, 0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"persimmonLeaves", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"food", (long)2L, (int)8));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedSaplings", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs1", (long)4L, (int)0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedSaplings", (long)2L, (int)0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedLeaves1", (long)2L, (int)0), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedSaplings", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs2", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedLeaves1", (long)1L, (int)1), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedSaplings", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs2", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedLeaves1", (long)1L, (int)2), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedSaplings", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs3", (long)2L, (int)0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedLeaves1", (long)1L, (int)3), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedSaplings", (long)1L, (int)4), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs3", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedLeaves2", (long)1L, (int)0), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedSaplings", (long)1L, (int)5), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs4", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedLeaves2", (long)1L, (int)1), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedSaplings", (long)1L, (int)6), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs4", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedLeaves2", (long)1L, (int)2), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedSaplings", (long)1L, (int)7), new ItemStack(Blocks.field_150364_r, 1, 0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"colorizedLeaves2", (long)1L, (int)3), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(new ItemStack((Block)Blocks.field_150328_O, 1, 0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs3", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"petals", (long)1L, (int)0), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(new ItemStack((Block)Blocks.field_150327_N, 1, 0), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"logs3", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.BiomesOPlenty.ID, (String)"petals", (long)1L, (int)1), null);
    }

    private static void addPamTree(String name, int meta) {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)("pam" + name + "Sapling"), (long)1L, (int)0), new ItemStack(Blocks.field_150364_r, 1, meta), new ItemStack((Block)Blocks.field_150362_t, 1, meta), GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)(name + "Item"), (long)2L, (int)0));
    }

    private static void generatePamsTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamappleSapling", (long)1L, (int)0), new ItemStack(Blocks.field_150364_r, 1, 0), new ItemStack((Block)Blocks.field_150362_t, 1, 0), new ItemStack(Items.field_151034_e, 2, 0));
        RecipeLoader_TreeFarm.addPamTree("almond", 3);
        RecipeLoader_TreeFarm.addPamTree("apricot", 3);
        RecipeLoader_TreeFarm.addPamTree("avocado", 0);
        RecipeLoader_TreeFarm.addPamTree("banana", 3);
        RecipeLoader_TreeFarm.addPamTree("cashew", 3);
        RecipeLoader_TreeFarm.addPamTree("cherry", 0);
        RecipeLoader_TreeFarm.addPamTree("chestnut", 0);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamcinnamonSapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamCinnamon", (long)1L, (int)0), new ItemStack((Block)Blocks.field_150362_t, 1, 3), GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"cinnamonItem", (long)2L, (int)0));
        RecipeLoader_TreeFarm.addPamTree("coconut", 3);
        RecipeLoader_TreeFarm.addPamTree("date", 3);
        RecipeLoader_TreeFarm.addPamTree("dragonfruit", 3);
        RecipeLoader_TreeFarm.addPamTree("durian", 3);
        RecipeLoader_TreeFarm.addPamTree("fig", 3);
        RecipeLoader_TreeFarm.addPamTree("grapefruit", 3);
        RecipeLoader_TreeFarm.addPamTree("lemon", 3);
        RecipeLoader_TreeFarm.addPamTree("lime", 3);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pammapleSapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamMaple", (long)1L, (int)0), new ItemStack((Block)Blocks.field_150362_t, 1, 1), GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"maplesyrupItem", (long)2L, (int)0));
        RecipeLoader_TreeFarm.addPamTree("mango", 3);
        RecipeLoader_TreeFarm.addPamTree("nutmeg", 0);
        RecipeLoader_TreeFarm.addPamTree("olive", 0);
        RecipeLoader_TreeFarm.addPamTree("orange", 3);
        RecipeLoader_TreeFarm.addPamTree("papaya", 3);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pampaperbarkSapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.PamsHarvestCraft.ID, (String)"pamPaperbark", (long)1L, (int)0), new ItemStack((Block)Blocks.field_150362_t, 1, 3), new ItemStack(Items.field_151121_aF, 1, 0));
        RecipeLoader_TreeFarm.addPamTree("peach", 3);
        RecipeLoader_TreeFarm.addPamTree("pear", 0);
        RecipeLoader_TreeFarm.addPamTree("pecan", 3);
        RecipeLoader_TreeFarm.addPamTree("peppercorn", 3);
        RecipeLoader_TreeFarm.addPamTree("persimmon", 3);
        RecipeLoader_TreeFarm.addPamTree("pistachio", 3);
        RecipeLoader_TreeFarm.addPamTree("plum", 0);
        RecipeLoader_TreeFarm.addPamTree("pomegranate", 3);
        RecipeLoader_TreeFarm.addPamTree("starfruit", 3);
        RecipeLoader_TreeFarm.addPamTree("vanillabean", 3);
        RecipeLoader_TreeFarm.addPamTree("walnut", 0);
        RecipeLoader_TreeFarm.addPamTree("gooseberry", 0);
    }

    private static void generatePamsNetherTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"netherSapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"netherLog", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"netherLeaves", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.PamsHarvestTheNether.ID, (String)"ignisfruitItem", (long)2L, (int)0));
    }

    private static void generateThaumcraftTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCustomPlant", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockMagicalLog", (long)2L, (int)0), GT_ModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockMagicalLeaves", (long)1L, (int)0), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockCustomPlant", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockMagicalLog", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockMagicalLeaves", (long)1L, (int)1), null);
    }

    private static void generateThaumicBasesTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"goldenOakSapling", (long)1L, (int)0), new ItemStack(Blocks.field_150364_r, 1, 0), GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"genLeaves", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Thaumcraft.ID, (String)"blockMagicalLeaves", (long)1L, (int)0), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"goldenOakSapling", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"genLogs", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"genLeaves", (long)1L, (int)1), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"goldenOakSapling", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"genLogs", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"genLeaves", (long)1L, (int)2), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"goldenOakSapling", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"genLogs", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.ThaumicBases.ID, (String)"genLeaves", (long)1L, (int)3), null);
    }

    private static void generateTaintedMagicTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.TaintedMagic.ID, (String)"BlockWarpwoodSapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.TaintedMagic.ID, (String)"BlockWarpwoodLog", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.TaintedMagic.ID, (String)"BlockWarpwoodLeaves", (long)1L, (int)0), null);
    }

    private static void generateForbiddenMagicTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"TaintSapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"TaintLog", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"TaintLeaves", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"TaintFruit", (long)1L, (int)0));
    }

    private static void generateWitcheryTrees() {
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Witchery.ID, (String)"witchsapling", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Witchery.ID, (String)"witchlog", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Witchery.ID, (String)"witchleaves", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.Witchery.ID, (String)"ingredient", (long)1L, (int)63));
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Witchery.ID, (String)"witchsapling", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.Witchery.ID, (String)"witchlog", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.Witchery.ID, (String)"witchleaves", (long)1L, (int)1), null);
        GregtechMetaTileEntityTreeFarm.registerTreeProducts(GT_ModHandler.getModItem((String)Mods.Witchery.ID, (String)"witchsapling", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.Witchery.ID, (String)"witchlog", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.Witchery.ID, (String)"witchleaves", (long)1L, (int)2), null);
    }

    private static void generateForestryTrees() {
        for (TreeDefinition tree : TreeDefinition.values()) {
            ItemStack[] produceList;
            String speciesUID = tree.getUID();
            ItemStack sapling = tree.getMemberStack(EnumGermlingType.SAPLING);
            EnumWoodType woodType = (EnumWoodType)ReflectionUtils.getField(tree, "woodType");
            ItemStack log = woodType != null ? TreeManager.woodItemAccess.getLog(woodType, false) : (ItemStack)ReflectionUtils.getField(tree, "vanillaWood");
            ItemStack leaves = new ItemStack((Block)PluginArboriculture.blocks.leaves, 1, 0);
            if (speciesUID != null) {
                NBTTagCompound nbtTagCompound = new NBTTagCompound();
                nbtTagCompound.func_74778_a("species", speciesUID);
                leaves.func_77982_d(nbtTagCompound);
            }
            ItemStack fruit = null;
            ITree individual = tree.getIndividual();
            if (individual.canBearFruit() && (produceList = individual.getProduceList()) != null && produceList.length > 0) {
                fruit = individual.getProduceList()[0];
            }
            GregtechMetaTileEntityTreeFarm.registerForestryTree(speciesUID, sapling == null ? null : sapling.func_77946_l(), log == null ? null : log.func_77946_l(), leaves == null ? null : leaves.func_77946_l(), fruit == null ? null : fruit.func_77946_l());
        }
    }

    private static void generateExtraTreesTrees() {
        for (ExtraTreeSpecies species : ExtraTreeSpecies.values()) {
            ItemStack[] produceList;
            String speciesUID = species.getUID();
            ITree individual = TreeManager.treeRoot.templateAsIndividual(species.getTemplate());
            ItemStack sapling = TreeManager.treeRoot.getMemberStack((IIndividual)individual, 0);
            ItemStack log = null;
            if (species.getLog() != null) {
                log = species.getLog().getItemStack();
            }
            ItemStack leaves = new ItemStack((Block)PluginArboriculture.blocks.leaves, 1, 0);
            if (speciesUID != null) {
                NBTTagCompound nbtTagCompound = new NBTTagCompound();
                nbtTagCompound.func_74778_a("species", speciesUID);
                leaves.func_77982_d(nbtTagCompound);
            }
            ItemStack fruit = null;
            if (individual.canBearFruit() && (produceList = individual.getProduceList()) != null && produceList.length > 0) {
                fruit = individual.getProduceList()[0];
            }
            GregtechMetaTileEntityTreeFarm.registerForestryTree(speciesUID, sapling == null ? null : sapling.func_77946_l(), log == null ? null : log.func_77946_l(), leaves == null ? null : leaves.func_77946_l(), fruit == null ? null : fruit.func_77946_l());
        }
    }
}

