/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class GregtechMetaTileEntity_MassFabricator
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_MassFabricator>
implements ISurvivalConstructable {
    public static int sUUAperUUM = 1;
    public static int sUUASpeedBonus = 4;
    public static int sDurationMultiplier = 3200;
    public static String mCasingName1 = "Matter Fabricator Casing";
    public static String mCasingName2 = "Containment Casing";
    public static String mCasingName3 = "Matter Generation Coil";
    private int mMode = 0;
    private static final int MODE_SCRAP = 1;
    private static final int MODE_UU = 0;
    public static boolean sRequiresUUA = false;
    private static final FluidStack[] mUU = new FluidStack[2];
    private static final ItemStack[] mScrap = new ItemStack[2];
    private int mCasing;
    private static IStructureDefinition<GregtechMetaTileEntity_MassFabricator> STRUCTURE_DEFINITION = null;
    public static boolean sInit = false;

    public GregtechMetaTileEntity_MassFabricator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_MassFabricator(String aName) {
        super(aName);
    }

    @Override
    public String getMachineType() {
        return "Mass Fabricator / Recycler";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Matter Fabricator").addInfo("Speed: +0% | EU Usage: 80%").addInfo("Parallel: Scrap = 64 | UU = 8 * Tier").addInfo("Produces UU-A, UU-M & Scrap").addInfo("Change mode with screwdriver").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(5, 4, 5, true).addController("Front Center").addCasingInfoMin(mCasingName3, 9, false).addCasingInfoMin(mCasingName2, 24, false).addCasingInfoMin(mCasingName1, 36, false).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Active_Animated;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Animated;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(9);
    }

    public void onConfigLoad(GT_Config aConfig) {
        super.onConfigLoad(aConfig);
        sDurationMultiplier = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUM_Duration_Multiplier", sDurationMultiplier);
        sUUAperUUM = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_per_UUM", sUUAperUUM);
        sUUASpeedBonus = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_Speed_Bonus", sUUASpeedBonus);
        sRequiresUUA = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_Requirement", sRequiresUUA);
    }

    public static void init() {
        if (!sInit) {
            if (mScrap[0] == null) {
                GregtechMetaTileEntity_MassFabricator.mScrap[0] = ItemUtils.getSimpleStack(ItemUtils.getItemFromFQRN("IC2:itemScrap"));
            }
            if (mScrap[1] == null) {
                GregtechMetaTileEntity_MassFabricator.mScrap[1] = ItemUtils.getSimpleStack(ItemUtils.getItemFromFQRN("IC2:itemScrapbox"));
            }
            if (mUU[0] == null) {
                GregtechMetaTileEntity_MassFabricator.mUU[0] = Materials.UUAmplifier.getFluid(100L);
            }
            if (mUU[1] == null) {
                GregtechMetaTileEntity_MassFabricator.mUU[1] = Materials.UUMatter.getFluid(100L);
            }
            sInit = true;
        }
    }

    public IStructureDefinition<GregtechMetaTileEntity_MassFabricator> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}, {"CGGGC", "G---G", "G---G", "G---G", "CGGGC"}, {"CGGGC", "G---G", "G---G", "G---G", "CGGGC"}, {"CC~CC", "CHHHC", "CHHHC", "CHHHC", "CCCCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_MassFabricator.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(TAE.GTPP_INDEX(9)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)9))})).addElement('H', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)8)).addElement('G', StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)15)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 2, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 3, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 2, 3, 0) && this.mCasing >= 36 && this.checkHatch();
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiMassFabricator;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_MassFabricator(this.mName);
    }

    public RecipeMap<?> getRecipeMap() {
        return this.mMode == 1 ? RecipeMaps.recyclerRecipes : GTPPRecipeMaps.multiblockMassFabricatorRecipes;
    }

    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.recyclerRecipes, GTPPRecipeMaps.multiblockMassFabricatorRecipes);
    }

    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)new ProcessingLogic(){

            @NotNull
            public CheckRecipeResult process() {
                GregtechMetaTileEntity_MassFabricator.init();
                return super.process();
            }

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GT_Recipe recipe) {
                if (GregtechMetaTileEntity_MassFabricator.this.mMode == 1 && recipe.mOutputs == null) {
                    return SimpleCheckRecipeResult.ofSuccess((String)"no_scrap");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Nonnull
            protected Stream<GT_Recipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
                if (GregtechMetaTileEntity_MassFabricator.this.mMode == 1) {
                    if (this.inputItems != null) {
                        for (ItemStack item : this.inputItems) {
                            ItemStack[] itemStackArray;
                            if (item == null || item.field_77994_a == 0) continue;
                            ItemStack aPotentialOutput = GT_ModHandler.getRecyclerOutput((ItemStack)GT_Utility.copyAmount((int)1, (ItemStack)item), (int)0);
                            ItemStack[] itemStackArray2 = new ItemStack[]{GT_Utility.copyAmount((int)1, (ItemStack)item)};
                            if (aPotentialOutput == null) {
                                itemStackArray = null;
                            } else {
                                ItemStack[] itemStackArray3 = new ItemStack[1];
                                itemStackArray = itemStackArray3;
                                itemStackArray3[0] = aPotentialOutput;
                            }
                            GT_Recipe recipe = new GT_Recipe(false, itemStackArray2, itemStackArray, null, new int[]{2000}, null, null, 40, MaterialUtils.getVoltageForTier(1), 0);
                            return Stream.of(recipe);
                        }
                    }
                    return Stream.empty();
                }
                return super.findRecipeMatches(map);
            }
        }.setEuModifier(0.8f)).setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        logic.enablePerfectOverclock();
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.mMode == 1 ? 64 : 8 * Math.max(1, GT_Utility.getTier((long)this.getMaxInputVoltage()));
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int aMode = this.mMode + 1;
        if (aMode > 1) {
            this.mMode = 0;
            PlayerUtils.messagePlayer(aPlayer, "Mode [" + this.mMode + "]: Matter/AmpliFabricator");
        } else if (aMode == 1) {
            this.mMode = 1;
            PlayerUtils.messagePlayer(aPlayer, "Mode [" + this.mMode + "]: Recycler");
        } else {
            this.mMode = 1;
            PlayerUtils.messagePlayer(aPlayer, "Mode [" + this.mMode + "]: Recycler");
        }
        this.mLastRecipe = null;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mMode", this.mMode);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mMode = aNBT.func_74762_e("mMode");
        super.loadNBTData(aNBT);
    }
}

