/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.render;

import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.proxy.ClientProxy;
import gtPlusPlus.core.util.data.AES;
import gtPlusPlus.core.util.data.FileUtils;
import gtPlusPlus.core.util.math.MathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;

public class GTPP_CapeRenderer
extends RenderPlayer {
    private static final ResourceLocation[] mCapes = new ResourceLocation[]{new ResourceLocation("miscutils:textures/OrangeHD.png"), new ResourceLocation("miscutils:textures/FancyCapeHD.png"), new ResourceLocation("miscutils:textures/TesterCapeHD.png"), new ResourceLocation("miscutils:textures/PatreonCapeHD.png"), new ResourceLocation("miscutils:textures/DevCapeHD.png")};
    private final boolean mInit = this.init();
    private static boolean hasResourceChecked = false;
    private static boolean hasSetRenderer = false;
    private boolean hasCape = false;
    private ResourceLocation tResource = null;

    private boolean init() {
        if (this.mInit) {
            return false;
        }
        return CapeUtils.init();
    }

    public synchronized void receiveRenderSpecialsEvent(RenderPlayerEvent.Specials.Pre aEvent) {
        if (this.field_76990_c == null) {
            hasSetRenderer = false;
        }
        if (!hasSetRenderer && RenderManager.field_78727_a != null) {
            this.func_76976_a(RenderManager.field_78727_a);
            hasSetRenderer = true;
        }
        if (hasSetRenderer) {
            if (!CORE.ConfigSwitches.enableCustomCapes) {
                return;
            }
            if (!CapeUtils.mapsPopulated) {
                if (!CapeUtils.cacheReady) {
                    return;
                }
                CapeUtils.writeCacheToMaps();
                CapeUtils.mapsPopulated = true;
            }
            if (hasResourceChecked && !this.hasCape && !CORE.DEVENV) {
                return;
            }
            AbstractClientPlayer aPlayer = (AbstractClientPlayer)aEvent.entityPlayer;
            if (!hasResourceChecked) {
                String aPlayerUUID;
                String string = aPlayerUUID = aPlayer != null ? aPlayer.func_146103_bH().getId().toString() : "BAD";
                if (aPlayerUUID.equals("BAD")) {
                    return;
                }
                if (this.tResource == null && CORE.DEVENV) {
                    this.tResource = mCapes[4];
                    this.hasCape = true;
                }
                String aPlayerName = ClientProxy.playerName;
                if (!this.hasCape) {
                    for (Pair aData : CapeUtils.mOrangeCapes) {
                        if (!((String)aData.getKey()).equals(aPlayerUUID) && !aPlayerName.equals(aData.getValue())) continue;
                        this.tResource = mCapes[0];
                        this.hasCape = true;
                        break;
                    }
                }
                if (!this.hasCape) {
                    for (Pair aData : CapeUtils.mMiscCapes) {
                        if (!((String)aData.getKey()).equals(aPlayerUUID) && !aPlayerName.equals(aData.getValue())) continue;
                        this.tResource = mCapes[1];
                        this.hasCape = true;
                        break;
                    }
                }
                if (!this.hasCape) {
                    for (Pair aData : CapeUtils.mBetaTestCapes) {
                        if (!((String)aData.getKey()).equals(aPlayerUUID) && !aPlayerName.equals(aData.getValue())) continue;
                        this.tResource = mCapes[2];
                        this.hasCape = true;
                        break;
                    }
                }
                if (!this.hasCape) {
                    for (Pair aData : CapeUtils.mPatreonCapes) {
                        if (!((String)aData.getKey()).equals(aPlayerUUID) && !aPlayerName.equals(aData.getValue())) continue;
                        this.tResource = mCapes[3];
                        this.hasCape = true;
                        break;
                    }
                }
                if (!this.hasCape) {
                    for (Pair aData : CapeUtils.mDevCapes) {
                        if (!((String)aData.getKey()).equals(aPlayerUUID) && !aPlayerName.equals(aData.getValue())) continue;
                        this.tResource = mCapes[4];
                        this.hasCape = true;
                        break;
                    }
                }
                hasResourceChecked = true;
            }
            if (hasResourceChecked) {
                this.renderCapeOnPlayer(aEvent, aPlayer);
            }
        }
    }

    private boolean renderCapeOnPlayer(RenderPlayerEvent.Specials.Pre aEvent, AbstractClientPlayer aPlayer) {
        float aPartialTicks = aEvent.partialRenderTick;
        try {
            if (this.tResource == null && CORE.DEVENV) {
                this.tResource = mCapes[3];
            }
            if (GT_Utility.getFullInvisibility((EntityPlayer)aPlayer) || aPlayer.func_82150_aj() || GT_Utility.getPotion((EntityLivingBase)aPlayer, (int)Potion.field_76441_p.field_76415_H)) {
                aEvent.setCanceled(true);
                return false;
            }
            if (this.tResource != null && !aPlayer.func_82238_cc()) {
                this.func_110776_a(this.tResource);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
                double d0 = aPlayer.field_71091_bM + (aPlayer.field_71094_bP - aPlayer.field_71091_bM) * (double)aPartialTicks - (aPlayer.field_70169_q + (aPlayer.field_70165_t - aPlayer.field_70169_q) * (double)aPartialTicks);
                double d1 = aPlayer.field_71096_bN + (aPlayer.field_71095_bQ - aPlayer.field_71096_bN) * (double)aPartialTicks - (aPlayer.field_70167_r + (aPlayer.field_70163_u - aPlayer.field_70167_r) * (double)aPartialTicks);
                double d2 = aPlayer.field_71097_bO + (aPlayer.field_71085_bR - aPlayer.field_71097_bO) * (double)aPartialTicks - (aPlayer.field_70166_s + (aPlayer.field_70161_v - aPlayer.field_70166_s) * (double)aPartialTicks);
                float f6 = aPlayer.field_70760_ar + (aPlayer.field_70761_aq - aPlayer.field_70760_ar) * aPartialTicks;
                double d3 = MathHelper.func_76126_a((float)(f6 * (float)Math.PI / 180.0f));
                double d4 = -MathHelper.func_76134_b((float)(f6 * (float)Math.PI / 180.0f));
                float f7 = (float)d1 * 10.0f;
                float f8 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                float f9 = (float)(d0 * d4 - d2 * d3) * 100.0f;
                if (f7 < -6.0f) {
                    f7 = -6.0f;
                }
                if (f7 > 32.0f) {
                    f7 = 32.0f;
                }
                if (f8 < 0.0f) {
                    f8 = 0.0f;
                }
                float f10 = aPlayer.field_71107_bF + (aPlayer.field_71109_bG - aPlayer.field_71107_bF) * aPartialTicks;
                f7 += MathHelper.func_76126_a((float)((aPlayer.field_70141_P + (aPlayer.field_70140_Q - aPlayer.field_70141_P) * aPartialTicks) * 6.0f)) * 32.0f * f10;
                if (aPlayer.func_70093_af()) {
                    f7 += 25.0f;
                }
                GL11.glRotatef((float)(6.0f + f8 / 2.0f + f7), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(f9 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(-f9 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                ((ModelBiped)this.field_77045_g).func_78111_c(0.0625f);
                GL11.glPopMatrix();
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static class CapeUtils {
        private static char SPLIT_CHARACTER = (char)167;
        private static AES sAES;
        private static volatile boolean cacheReady;
        private static boolean mapsPopulated;
        private static final AutoMap<Pair<String, String>> mOrangeCapes;
        private static final AutoMap<Pair<String, String>> mMiscCapes;
        private static final AutoMap<Pair<String, String>> mBetaTestCapes;
        private static final AutoMap<Pair<String, String>> mPatreonCapes;
        private static final AutoMap<Pair<String, String>> mDevCapes;

        private CapeUtils() {
        }

        private static boolean init() {
            CapeUtils.handleOldCapeCache();
            if (CORE.DEVENV) {
                return true;
            }
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    if (CapeUtils.shouldDownloadCapeList()) {
                        CapeUtils.downloadCapeList();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                cacheReady = true;
            });
            return true;
        }

        private static boolean shouldDownloadCapeList() {
            if (!CapeUtils.doesCapeCacheExistLocally()) {
                return true;
            }
            return CapeUtils.isCapeCacheWeekOld();
        }

        private static boolean isCapeCacheWeekOld() {
            Date dateNow;
            if (!CapeUtils.doesCapeCacheExistLocally()) {
                return true;
            }
            File dat = CapeUtils.getCapeCache();
            Date dateLastMod = new Date(dat.lastModified());
            return dateLastMod.before(dateNow = new Date(System.currentTimeMillis() - 604800000L));
        }

        private static void downloadCapeList() {
            try {
                File dat = CapeUtils.getCapeCache();
                File temp = CapeUtils.allocateTempFile();
                InputStream inputStream = new URL("https://alkcorp.overminddl1.com/CapeCache.dat").openStream();
                FileOutputStream fileOS = new FileOutputStream(temp);
                IOUtils.copy((InputStream)inputStream, (OutputStream)fileOS);
                if (CapeUtils.isDownloadedCapeListBigger(temp)) {
                    fileOS = new FileOutputStream(dat);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)fileOS);
                }
            }
            catch (Throwable t) {
                Logger.INFO("Unable to download GT++ cape list.");
            }
        }

        private static boolean isDownloadedCapeListBigger(File aFile) {
            double aExistingFileSize = CapeUtils.doesCapeCacheExistLocally() ? CapeUtils.getCapeCache().length() : 0L;
            double aNewFileSize = aFile.length();
            return aNewFileSize > aExistingFileSize;
        }

        private static void handleOldCapeCache() {
            File aCacheFile = FileUtils.getFile("GTPP", "dat");
            if (FileUtils.doesFileExist(aCacheFile)) {
                aCacheFile.delete();
            }
        }

        private static boolean doesCapeCacheExistLocally() {
            File aCacheFile = FileUtils.getFile("CapeCache", "dat");
            return FileUtils.doesFileExist(aCacheFile);
        }

        private static File getCapeCache() {
            File aCacheFile = FileUtils.getFile("CapeCache", "dat");
            if (FileUtils.doesFileExist(aCacheFile)) {
                FileUtils.createFile(aCacheFile);
            }
            return aCacheFile;
        }

        public static final List<String> getDataFromCache() {
            File aCacheFile = CapeUtils.getCapeCache();
            List<String> aCache = FileUtils.readLines(aCacheFile);
            if (aCache != null && !aCache.isEmpty()) {
                return aCache;
            }
            return new AutoMap<String>();
        }

        private static File allocateTempFile() {
            File tempFile = null;
            try {
                tempFile = File.createTempFile("gtpp-", null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (tempFile == null) {
                tempFile = FileUtils.createFile("", "gtpp-" + MathUtils.randInt(Short.MAX_VALUE, 0x3FFFFFFF), "tmp");
            }
            tempFile.deleteOnExit();
            return tempFile;
        }

        public static final void writeCacheToMaps() {
            List<String> aCacheData = CapeUtils.getDataFromCache();
            if (aCacheData != null && !aCacheData.isEmpty()) {
                if (sAES == null) {
                    sAES = new AES();
                }
                AutoMap<String> aDecodedData = new AutoMap<String>();
                for (String aToDecode : aCacheData) {
                    aDecodedData.put(sAES.decode(aToDecode));
                }
                if (!aDecodedData.isEmpty()) {
                    AutoMap<Pair<String, String>> aCapeType1 = new AutoMap<Pair<String, String>>();
                    AutoMap<Pair<String, String>> aCapeType2 = new AutoMap<Pair<String, String>>();
                    AutoMap<Pair<String, String>> aCapeType3 = new AutoMap<Pair<String, String>>();
                    AutoMap<Pair<String, String>> aCapeType4 = new AutoMap<Pair<String, String>>();
                    AutoMap<Pair<String, String>> aCapeType5 = new AutoMap<Pair<String, String>>();
                    boolean didProcessStringData = false;
                    Logger.INFO("Decoded String Count: " + aDecodedData.size());
                    for (String string : aDecodedData) {
                        Integer aCapeTypeID2;
                        String[] aSplitData = string.split("" + SPLIT_CHARACTER);
                        if (aSplitData == null || aSplitData.length < 2 || aSplitData[0] == null || (aCapeTypeID2 = Integer.valueOf(Integer.parseInt(aSplitData[0]))) == null) continue;
                        int aCapeTypeID = aCapeTypeID2;
                        Pair<String, String> aFinalString = new Pair<String, String>("UUID: " + aSplitData[1], "Username: " + (aSplitData[2] != null && aSplitData[0].length() > 0 ? aSplitData[2] : "Not Specified"));
                        Logger.INFO("Cape Type: " + aCapeTypeID);
                        switch (aCapeTypeID) {
                            case 0: {
                                aCapeType1.add(aFinalString);
                                Logger.INFO("Added user to map " + aCapeTypeID + ", map now holds " + aCapeType1.size() + " users.");
                                break;
                            }
                            case 1: {
                                aCapeType2.add(aFinalString);
                                Logger.INFO("Added user to map " + aCapeTypeID + ", map now holds " + aCapeType2.size() + " users.");
                                break;
                            }
                            case 2: {
                                aCapeType3.add(aFinalString);
                                Logger.INFO("Added user to map " + aCapeTypeID + ", map now holds " + aCapeType3.size() + " users.");
                                break;
                            }
                            case 3: {
                                aCapeType4.add(aFinalString);
                                Logger.INFO("Added user to map " + aCapeTypeID + ", map now holds " + aCapeType4.size() + " users.");
                                break;
                            }
                            case 4: {
                                aCapeType5.add(aFinalString);
                                Logger.INFO("Added user to map " + aCapeTypeID + ", map now holds " + aCapeType5.size() + " users.");
                                break;
                            }
                        }
                    }
                    if (!(aCapeType1.isEmpty() && aCapeType2.isEmpty() && aCapeType3.isEmpty() && aCapeType4.isEmpty() && aCapeType5.isEmpty())) {
                        didProcessStringData = true;
                    }
                    if (didProcessStringData) {
                        if (!aCapeType1.isEmpty()) {
                            for (Pair pair : aCapeType1) {
                                Logger.INFO("Adding Generic cape for " + (String)pair.getKey());
                                mOrangeCapes.add(pair);
                            }
                        }
                        if (!aCapeType2.isEmpty()) {
                            for (Pair pair : aCapeType2) {
                                Logger.INFO("Adding Blue cape for " + (String)pair.getKey());
                                mMiscCapes.add(pair);
                            }
                        }
                        if (!aCapeType3.isEmpty()) {
                            for (Pair pair : aCapeType3) {
                                Logger.INFO("Adding Beta cape for " + (String)pair.getKey());
                                mBetaTestCapes.add(pair);
                            }
                        }
                        if (!aCapeType4.isEmpty()) {
                            for (Pair pair : aCapeType4) {
                                Logger.INFO("Adding Patreon cape for " + (String)pair.getKey());
                                mPatreonCapes.add(pair);
                            }
                        }
                        if (!aCapeType5.isEmpty()) {
                            for (Pair pair : aCapeType5) {
                                Logger.INFO("Adding Dev cape for " + (String)pair.getKey());
                                mDevCapes.add(pair);
                            }
                        }
                    }
                }
            }
        }

        static {
            cacheReady = false;
            mapsPopulated = false;
            mOrangeCapes = new AutoMap();
            mMiscCapes = new AutoMap();
            mBetaTestCapes = new AutoMap();
            mPatreonCapes = new AutoMap();
            mDevCapes = new AutoMap();
        }
    }
}

