/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.helpers.tesseract;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.common.tileentities.automation.GT_MetaTileEntity_TesseractGenerator;
import gtPlusPlus.xmod.gregtech.common.tileentities.automation.GT_MetaTileEntity_TesseractTerminal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class TesseractHelper {
    public static final boolean isGeneratorOwnedByPlayer(EntityPlayer player, GT_MetaTileEntity_TesseractGenerator generator) {
        if (player == null) {
            Logger.WARNING("Failed. [isGeneratorOwnedByPlayer]");
            return false;
        }
        UUID playerIdentifier = player.func_110124_au();
        if (!CORE.sTesseractGeneratorOwnershipMap.isEmpty() && playerIdentifier != null) {
            Map<Integer, GT_MetaTileEntity_TesseractGenerator> generators = TesseractHelper.getGeneratorOwnershipByPlayer(player);
            Set<Map.Entry<Integer, GT_MetaTileEntity_TesseractGenerator>> players = generators.entrySet();
            for (Map.Entry<Integer, GT_MetaTileEntity_TesseractGenerator> current : players) {
                if (!((Object)((Object)current.getValue())).equals((Object)generator)) continue;
                return true;
            }
        }
        Logger.WARNING("Failed. [isGeneratorOwnedByPlayer]");
        return false;
    }

    public static final boolean setGeneratorOwnershipByPlayer(EntityPlayer player, int freq, GT_MetaTileEntity_TesseractGenerator generator) {
        if (player == null) {
            return false;
        }
        UUID playerIdentifier = player.func_110124_au();
        Logger.WARNING("Setting Generator on " + freq + " for " + player.getDisplayName() + ".");
        if (playerIdentifier != null) {
            Map<Integer, GT_MetaTileEntity_TesseractGenerator> playerOwned = CORE.sTesseractGeneratorOwnershipMap.get(playerIdentifier);
            if (playerOwned == null || playerOwned.isEmpty()) {
                HashMap<Integer, GT_MetaTileEntity_TesseractGenerator> newOwnershipMap = new HashMap<Integer, GT_MetaTileEntity_TesseractGenerator>();
                newOwnershipMap.put(freq, generator);
                CORE.sTesseractGeneratorOwnershipMap.put(playerIdentifier, newOwnershipMap);
                Logger.WARNING("Success! [Empty Map]");
                return true;
            }
            if (CORE.sTesseractGeneratorOwnershipMap.containsKey(playerIdentifier)) {
                Map<Integer, GT_MetaTileEntity_TesseractGenerator> ownershipMap = CORE.sTesseractGeneratorOwnershipMap.get(playerIdentifier);
                if (!ownershipMap.containsKey(freq)) {
                    ownershipMap.put(freq, generator);
                }
                ownershipMap.put(freq, generator);
                CORE.sTesseractGeneratorOwnershipMap.put(playerIdentifier, ownershipMap);
                Logger.WARNING("Success!");
                return true;
            }
        }
        Logger.WARNING("Failed. [setGeneratorOwnershipByPlayer]");
        return false;
    }

    public static final GT_MetaTileEntity_TesseractGenerator getGeneratorByFrequency(EntityPlayer player, int freq) {
        if (player == null) {
            return null;
        }
        UUID playerIdentifier = player.func_110124_au();
        Logger.WARNING("Getting Generator on " + freq + " for " + player.getDisplayName() + ".");
        if (!CORE.sTesseractGeneratorOwnershipMap.isEmpty() && playerIdentifier != null) {
            Map<Integer, GT_MetaTileEntity_TesseractGenerator> generators = TesseractHelper.getGeneratorOwnershipByPlayer(player);
            Set<Map.Entry<Integer, GT_MetaTileEntity_TesseractGenerator>> players = generators.entrySet();
            for (Map.Entry<Integer, GT_MetaTileEntity_TesseractGenerator> current : players) {
                if (!current.getKey().equals(freq)) continue;
                Logger.WARNING("Success!");
                return current.getValue();
            }
        }
        Logger.WARNING("Failed. [getGeneratorByFrequency]");
        return null;
    }

    public static final boolean removeGenerator(EntityPlayer player, int frequency) {
        if (player == null) {
            return false;
        }
        UUID playerIdentifier = player.func_110124_au();
        if (!CORE.sTesseractGeneratorOwnershipMap.isEmpty() && playerIdentifier != null) {
            CORE.sTesseractGeneratorOwnershipMap.get(playerIdentifier).remove(frequency);
            return true;
        }
        return false;
    }

    public static final boolean isTerminalOwnedByPlayer(EntityPlayer player, GT_MetaTileEntity_TesseractTerminal generator) {
        if (player == null) {
            return false;
        }
        UUID playerIdentifier = player.func_110124_au();
        if (!CORE.sTesseractTerminalOwnershipMap.isEmpty() && playerIdentifier != null) {
            Map<Integer, GT_MetaTileEntity_TesseractTerminal> generators = TesseractHelper.getTerminalOwnershipByPlayer(player);
            Set<Map.Entry<Integer, GT_MetaTileEntity_TesseractTerminal>> players = generators.entrySet();
            for (Map.Entry<Integer, GT_MetaTileEntity_TesseractTerminal> current : players) {
                if (!((Object)((Object)current.getValue())).equals((Object)generator)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean setTerminalOwnershipByPlayer(EntityPlayer player, int freq, GT_MetaTileEntity_TesseractTerminal generator) {
        if (player == null) {
            return false;
        }
        UUID playerIdentifier = player.func_110124_au();
        if (playerIdentifier != null) {
            Logger.WARNING("Setting Terminal on " + freq + " for " + player.getDisplayName() + ".");
            Map<Integer, GT_MetaTileEntity_TesseractTerminal> playerOwned = CORE.sTesseractTerminalOwnershipMap.get(playerIdentifier);
            if (playerOwned == null || playerOwned.isEmpty()) {
                HashMap<Integer, GT_MetaTileEntity_TesseractTerminal> newOwnershipMap = new HashMap<Integer, GT_MetaTileEntity_TesseractTerminal>();
                newOwnershipMap.put(freq, generator);
                CORE.sTesseractTerminalOwnershipMap.put(playerIdentifier, newOwnershipMap);
                Logger.WARNING("Success! [Empty Map]");
                return true;
            }
            if (CORE.sTesseractTerminalOwnershipMap.containsKey(playerIdentifier)) {
                Map<Integer, GT_MetaTileEntity_TesseractTerminal> ownershipMap = CORE.sTesseractTerminalOwnershipMap.get(playerIdentifier);
                if (!ownershipMap.containsKey(freq)) {
                    ownershipMap.put(freq, generator);
                }
                CORE.sTesseractTerminalOwnershipMap.put(playerIdentifier, ownershipMap);
                Logger.WARNING("Success!");
                return true;
            }
        }
        Logger.WARNING("Failed. [setTerminalOwnershipByPlayer]");
        return false;
    }

    public static final GT_MetaTileEntity_TesseractTerminal getTerminalByFrequency(EntityPlayer player, int freq) {
        if (player == null) {
            return null;
        }
        UUID playerIdentifier = player.func_110124_au();
        Logger.WARNING("Getting Terminal on " + freq + " for " + player.getDisplayName() + ".");
        if (!CORE.sTesseractTerminalOwnershipMap.isEmpty() && playerIdentifier != null) {
            Map<Integer, GT_MetaTileEntity_TesseractTerminal> generators = TesseractHelper.getTerminalOwnershipByPlayer(player);
            Set<Map.Entry<Integer, GT_MetaTileEntity_TesseractTerminal>> players = generators.entrySet();
            for (Map.Entry<Integer, GT_MetaTileEntity_TesseractTerminal> current : players) {
                if (!current.getKey().equals(freq)) continue;
                Logger.WARNING("Success!");
                return current.getValue();
            }
        }
        Logger.WARNING("Failed. [getTerminalByFrequency]");
        return null;
    }

    public static final boolean removeTerminal(EntityPlayer player, int frequency) {
        if (player == null) {
            return false;
        }
        UUID playerIdentifier = player.func_110124_au();
        if (!CORE.sTesseractTerminalOwnershipMap.isEmpty() && playerIdentifier != null) {
            CORE.sTesseractTerminalOwnershipMap.get(playerIdentifier).remove(frequency);
            return true;
        }
        return false;
    }

    private static Map<Integer, GT_MetaTileEntity_TesseractGenerator> getGeneratorOwnershipByPlayer(EntityPlayer player) {
        UUID playerIdentifier = player.func_110124_au();
        if (!CORE.sTesseractGeneratorOwnershipMap.isEmpty() && playerIdentifier != null) {
            Set<Map.Entry<UUID, Map<Integer, GT_MetaTileEntity_TesseractGenerator>>> players = CORE.sTesseractGeneratorOwnershipMap.entrySet();
            for (Map.Entry<UUID, Map<Integer, GT_MetaTileEntity_TesseractGenerator>> current : players) {
                if (current.getKey().compareTo(playerIdentifier) != 0) continue;
                return current.getValue();
            }
        }
        return null;
    }

    private static Map<Integer, GT_MetaTileEntity_TesseractTerminal> getTerminalOwnershipByPlayer(EntityPlayer player) {
        UUID playerIdentifier = player.func_110124_au();
        if (!CORE.sTesseractTerminalOwnershipMap.isEmpty() && playerIdentifier != null) {
            Set<Map.Entry<UUID, Map<Integer, GT_MetaTileEntity_TesseractTerminal>>> players = CORE.sTesseractTerminalOwnershipMap.entrySet();
            for (Map.Entry<UUID, Map<Integer, GT_MetaTileEntity_TesseractTerminal>> current : players) {
                if (current.getKey().compareTo(playerIdentifier) != 0) continue;
                return current.getValue();
            }
        }
        return null;
    }
}

