/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_Hatch_FluidGenerator
extends GT_MetaTileEntity_Hatch_Input {
    protected static XSTR floatGen = new XSTR();
    public int mProgresstime = 0;
    public int mMaxProgresstime = 0;

    public GT_MetaTileEntity_Hatch_FluidGenerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public GT_MetaTileEntity_Hatch_FluidGenerator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public abstract String[] getCustomTooltip();

    public abstract Fluid getFluidToGenerate();

    public abstract int getAmountOfFluidToGenerate();

    public abstract int getMaxTickTime();

    public synchronized String[] getDescription() {
        this.mDescriptionArray[1] = "Capacity: " + GT_Utility.formatNumbers((long)this.getCapacity()) + "L";
        String[] hatchTierString = new String[]{"Hatch Tier: " + GT_Utility.getColoredTierNameFromTier((byte)this.mTier)};
        String[] aCustomTips = this.getCustomTooltip();
        String[] desc = new String[this.mDescriptionArray.length + aCustomTips.length + 2];
        System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
        System.arraycopy(hatchTierString, 0, desc, this.mDescriptionArray.length, 1);
        System.arraycopy(aCustomTips, 0, desc, this.mDescriptionArray.length + 1, aCustomTips.length);
        desc[this.mDescriptionArray.length + aCustomTips.length] = CORE.GT_Tooltip.get();
        return desc;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_MUFFLER)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_MUFFLER)};
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public abstract MetaTileEntity newMetaEntity(IGregTechTileEntity var1);

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (!aBaseMetaTileEntity.isAllowedToWork()) {
            aBaseMetaTileEntity.setActive(false);
            this.mProgresstime = 0;
            this.mMaxProgresstime = 0;
        } else {
            aBaseMetaTileEntity.setActive(true);
            this.mMaxProgresstime = this.getMaxTickTime();
            if (++this.mProgresstime >= this.mMaxProgresstime) {
                if (this.canTankBeFilled()) {
                    this.addFluidToHatch(aTick);
                }
                this.mProgresstime = 0;
            }
        }
    }

    public int getProgresstime() {
        return this.mProgresstime;
    }

    public int maxProgresstime() {
        return this.mMaxProgresstime;
    }

    public int increaseProgress(int aProgress) {
        this.mProgresstime += aProgress;
        return this.mMaxProgresstime - this.mProgresstime;
    }

    public abstract void generateParticles(World var1, String var2);

    public int getTankPressure() {
        return 100;
    }

    public abstract int getCapacity();

    public boolean canTankBeEmptied() {
        return true;
    }

    public abstract boolean doesHatchMeetConditionsToGenerate();

    public boolean addFluidToHatch(long aTick) {
        if (!this.doesHatchMeetConditionsToGenerate()) {
            return false;
        }
        int aFillAmount = this.fill(FluidUtils.getFluidStack(this.getFluidToGenerate(), this.getAmountOfFluidToGenerate()), true);
        if (aFillAmount > 0 && this.getBaseMetaTileEntity().isClientSide()) {
            this.generateParticles(this.getBaseMetaTileEntity().getWorld(), "cloud");
        }
        return aFillAmount > 0;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean doesEmptyContainers() {
        return false;
    }

    public boolean doesFillContainers() {
        return true;
    }

    public int fill(FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0 || aFluid.amount <= 0 || aFluid.getFluid() != this.getFluidToGenerate() || !this.canTankBeFilled()) {
            return 0;
        }
        if (this.getFillableStack() == null || this.getFillableStack().getFluid().getID() <= 0) {
            if (aFluid.amount <= this.getCapacity()) {
                if (doFill) {
                    this.setFillableStack(aFluid.copy());
                    this.getBaseMetaTileEntity().func_70296_d();
                }
                return aFluid.amount;
            }
            if (doFill) {
                this.setFillableStack(aFluid.copy());
                this.getFillableStack().amount = this.getCapacity();
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return this.getCapacity();
        }
        if (!this.getFillableStack().isFluidEqual(aFluid)) {
            return 0;
        }
        int space = this.getCapacity() - this.getFillableStack().amount;
        if (aFluid.amount <= space) {
            if (doFill) {
                this.getFillableStack().amount += aFluid.amount;
                this.getBaseMetaTileEntity().func_70296_d();
            }
            return aFluid.amount;
        }
        if (doFill) {
            this.getFillableStack().amount = this.getCapacity();
        }
        return space;
    }

    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        return false;
    }

    public int fill(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return 0;
    }

    public int fill_default(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        return 0;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mProgresstime", this.mProgresstime);
        aNBT.func_74768_a("mMaxProgresstime", this.mMaxProgresstime);
        super.saveNBTData(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.mProgresstime = aNBT.func_74762_e("mProgresstime");
        this.mMaxProgresstime = aNBT.func_74762_e("mMaxProgresstime");
        super.loadNBTData(aNBT);
    }
}

