/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.tesla;

import com.github.technus.tectech.mechanics.spark.ThaumSpark;
import com.github.technus.tectech.mechanics.tesla.ITeslaConnectableSimple;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Map;

public interface ITeslaConnectable
extends ITeslaConnectableSimple {
    public Multimap<Integer, ITeslaConnectableSimple> getTeslaNodeMap();

    public HashSet<ThaumSpark> getSparkList();

    public byte getTeslaTransmissionCapability();

    public int getTeslaTransmissionRange();

    public boolean isOverdriveEnabled();

    public int getTeslaEnergyLossPerBlock();

    public float getTeslaOverdriveLossCoefficient();

    public long getTeslaOutputVoltage();

    public long getTeslaOutputCurrent();

    public boolean teslaDrainEnergy(long var1);

    public static class TeslaUtil {
        private static final HashSet<ITeslaConnectableSimple> teslaSimpleNodeSet = new HashSet();
        private static final HashSet<ITeslaConnectable> teslaNodeSet = new HashSet();

        public static void teslaSimpleNodeSetAdd(ITeslaConnectableSimple target) {
            if (!teslaSimpleNodeSet.contains(target)) {
                teslaSimpleNodeSet.add(target);
                teslaNodeSet.forEach(origin -> TeslaUtil.addTargetToTeslaOrigin(target, origin));
            }
        }

        public static void teslaSimpleNodeSetRemove(ITeslaConnectableSimple target) {
            teslaSimpleNodeSet.remove(target);
            if (target instanceof ITeslaConnectable) {
                teslaNodeSet.remove(target);
            }
            teslaNodeSet.forEach(origin -> TeslaUtil.removeTargetFromTeslaOrigin(target, origin));
        }

        private static void addTargetToTeslaOrigin(ITeslaConnectableSimple target, ITeslaConnectable origin) {
            if (origin.equals(target) || !origin.getTeslaDimension().equals(target.getTeslaDimension())) {
                return;
            }
            if (origin.getTeslaTransmissionCapability() != 0 && origin.getTeslaReceptionCapability() != 0 && origin.getTeslaTransmissionCapability() != origin.getTeslaReceptionCapability()) {
                return;
            }
            int distance = (int)Math.sqrt(origin.getTeslaPosition().distanceSq(target.getTeslaPosition()));
            if ((float)distance > (float)origin.getTeslaTransmissionRange() * target.getTeslaReceptionCoefficient()) {
                return;
            }
            origin.getTeslaNodeMap().put((Object)distance, (Object)target);
        }

        private static void removeTargetFromTeslaOrigin(ITeslaConnectableSimple target, ITeslaConnectable origin) {
            int distance = (int)Math.sqrt(origin.getTeslaPosition().distanceSq(target.getTeslaPosition()));
            origin.getTeslaNodeMap().remove((Object)distance, (Object)target);
        }

        public static void generateTeslaNodeMap(ITeslaConnectable origin) {
            origin.getTeslaNodeMap().clear();
            for (ITeslaConnectableSimple target : teslaSimpleNodeSet) {
                if (target == null) {
                    teslaSimpleNodeSet.remove(null);
                    continue;
                }
                TeslaUtil.addTargetToTeslaOrigin(target, origin);
            }
            teslaNodeSet.add(origin);
        }

        public static long powerTeslaNodeMap(ITeslaConnectable origin) {
            boolean canSendPower;
            long remainingAmperes = origin.getTeslaOutputCurrent();
            boolean bl = canSendPower = !origin.isTeslaReadyToReceive() && remainingAmperes > 0L;
            if (canSendPower) {
                for (Map.Entry Rx : origin.getTeslaNodeMap().entries()) {
                    long outputVoltageConsumption;
                    long outputVoltageInjectable;
                    if (origin.getTeslaStoredEnergy() < (origin.isOverdriveEnabled() ? origin.getTeslaOutputVoltage() * 2L : origin.getTeslaOutputVoltage())) break;
                    ITeslaConnectableSimple target = (ITeslaConnectableSimple)Rx.getValue();
                    int distance = (Integer)Rx.getKey();
                    if (!target.isTeslaReadyToReceive()) continue;
                    if (origin.isOverdriveEnabled()) {
                        outputVoltageInjectable = origin.getTeslaOutputVoltage();
                        outputVoltageConsumption = origin.getTeslaOutputVoltage() + (long)distance * (long)origin.getTeslaEnergyLossPerBlock() + (long)Math.round((float)origin.getTeslaOutputVoltage() * origin.getTeslaOverdriveLossCoefficient());
                    } else {
                        outputVoltageInjectable = origin.getTeslaOutputVoltage() - (long)distance * (long)origin.getTeslaEnergyLossPerBlock();
                        outputVoltageConsumption = origin.getTeslaOutputVoltage();
                    }
                    if (origin.getTeslaStoredEnergy() < outputVoltageConsumption) break;
                    while (canSendPower && target.teslaInjectEnergy(outputVoltageInjectable)) {
                        origin.teslaDrainEnergy(outputVoltageConsumption);
                        origin.getSparkList().add(new ThaumSpark(origin.getTeslaPosition(), target.getTeslaPosition(), origin.getTeslaDimension()));
                        canSendPower = origin.getTeslaStoredEnergy() < outputVoltageConsumption || --remainingAmperes > 0L;
                    }
                    if (canSendPower) continue;
                    break;
                }
            }
            return origin.getTeslaOutputCurrent() - remainingAmperes;
        }
    }
}

