/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.holders.basetypes;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesChunk;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;

public final class CoordinatesBlock
implements ISerializable {
    public final int dim;
    public final int x;
    public final int y;
    public final int z;
    public final int chunkX;
    public final int chunkZ;
    public static final CoordinatesBlock INVALID = new CoordinatesBlock(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);

    public CoordinatesBlock(Entity entity) {
        this.dim = entity.field_70170_p.field_73011_w.field_76574_g;
        this.x = MathHelper.func_76128_c((double)entity.field_70165_t);
        this.y = MathHelper.func_76128_c((double)entity.field_70163_u);
        this.z = MathHelper.func_76128_c((double)entity.field_70161_v);
        this.chunkX = this.x >> 4;
        this.chunkZ = this.z >> 4;
    }

    public CoordinatesBlock(int dim, int x, int y, int z) {
        this.dim = dim;
        this.x = x;
        this.y = y;
        this.z = z;
        this.chunkX = x >> 4;
        this.chunkZ = z >> 4;
    }

    public CoordinatesBlock(int dim, double x, double y, double z) {
        this.dim = dim;
        this.x = MathHelper.func_76128_c((double)x);
        this.y = MathHelper.func_76128_c((double)y);
        this.z = MathHelper.func_76128_c((double)z);
        this.chunkX = MathHelper.func_76128_c((double)x) >> 4;
        this.chunkZ = MathHelper.func_76128_c((double)z) >> 4;
    }

    public CoordinatesBlock(CoordinatesChunk coord) {
        this.dim = coord.dim;
        this.chunkX = coord.chunkX;
        this.chunkZ = coord.chunkZ;
        this.x = coord.x;
        this.y = coord.y;
        this.z = coord.z;
    }

    public CoordinatesBlock(TileEntity te) {
        this.dim = te.func_145831_w().field_73011_w.field_76574_g;
        this.x = te.field_145851_c;
        this.y = te.field_145848_d;
        this.z = te.field_145849_e;
        this.chunkX = this.x >> 4;
        this.chunkZ = this.z >> 4;
    }

    public CoordinatesChunk asCoordinatesChunk() {
        return new CoordinatesChunk(this);
    }

    public String toString() {
        return String.format("[%6d %6d %6d %6d]", this.dim, this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        CoordinatesBlock c = (CoordinatesBlock)o;
        return this.dim == c.dim && this.x == c.x && this.y == c.y && this.z == c.z;
    }

    public boolean isInvalid() {
        return this.equals(INVALID);
    }

    public int hashCode() {
        return this.dim + 31 * this.x + 877 * this.y + 3187 * this.z;
    }

    @Override
    public void writeToStream(ByteArrayDataOutput stream) {
        stream.writeInt(this.dim);
        stream.writeInt(this.x);
        stream.writeInt(this.y);
        stream.writeInt(this.z);
    }

    public static CoordinatesBlock readFromStream(ByteArrayDataInput stream) {
        return new CoordinatesBlock(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
    }
}

