/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker.foodgroups;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FilenameUtils;
import squeek.spiceoflife.ModSpiceOfLife;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.helpers.FileHelper;
import squeek.spiceoflife.helpers.MiscHelper;

public class FoodGroupConfig {
    private static final Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
    private static File[] configFiles;

    public static void setup(File configDirectory) {
        File modConfigDirectory = new File(configDirectory, "SpiceOfLife");
        if (modConfigDirectory.exists() || modConfigDirectory.mkdirs()) {
            FoodGroupConfig.writeExampleFoodGroup(modConfigDirectory);
            configFiles = modConfigDirectory.listFiles();
        }
    }

    public static void writeExampleFoodGroup(File configDirectory) {
        String exampleFoodGroupFileName = "example-food-group.json";
        String exampleFoodGroupRelativePath = "example/example-food-group.json";
        File exampleFoodGroupDest = new File(configDirectory, "example-food-group.json");
        try {
            boolean shouldOverwrite = FoodGroupConfig.shouldOverwriteExampleFoodGroup(exampleFoodGroupDest);
            if (ModSpiceOfLife.instance.sourceFile != null && ModSpiceOfLife.instance.sourceFile.isDirectory()) {
                File sourceFile = new File(ModSpiceOfLife.instance.sourceFile, "example/example-food-group.json");
                FileHelper.copyFile(sourceFile, exampleFoodGroupDest, shouldOverwrite);
            } else {
                InputStream exampleFoodGroupInputStream = FoodGroupConfig.class.getClassLoader().getResourceAsStream("example/example-food-group.json");
                FileHelper.copyFile(exampleFoodGroupInputStream, exampleFoodGroupDest, shouldOverwrite);
                exampleFoodGroupInputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean shouldOverwriteExampleFoodGroup(File exampleFoodGroup) throws IOException {
        boolean bl;
        FileInputStream exampleFoodGroupStream;
        try {
            exampleFoodGroupStream = new FileInputStream(exampleFoodGroup);
        }
        catch (FileNotFoundException e) {
            return true;
        }
        BufferedReader exampleFoodGroupReader = null;
        try {
            exampleFoodGroupReader = new BufferedReader(new InputStreamReader((InputStream)exampleFoodGroupStream, StandardCharsets.UTF_8));
            String firstLine = exampleFoodGroupReader.readLine();
            bl = firstLine == null || !firstLine.equals("// Mod Version: 2.1.7-carrot");
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                MiscHelper.tryCloseStream(exampleFoodGroupReader);
                throw throwable;
            }
        }
        MiscHelper.tryCloseStream(exampleFoodGroupReader);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        for (File configFile : configFiles) {
            boolean isJson = FilenameUtils.getExtension((String)configFile.getName()).equalsIgnoreCase("json");
            if (!isJson) continue;
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);
                FoodGroup foodGroup = (FoodGroup)gson.fromJson((Reader)reader, FoodGroup.class);
                if (foodGroup != null && foodGroup.enabled) {
                    foodGroup.identifier = FilenameUtils.removeExtension((String)configFile.getName());
                    foodGroup.initFromConfig();
                    FoodGroupRegistry.addFoodGroup(foodGroup);
                }
                MiscHelper.tryCloseStream(reader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                MiscHelper.tryCloseStream(reader);
            }
        }
    }
}

