/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material;

import com.github.bartimaeusnek.bartworks.API.SideReference;
import com.github.bartimaeusnek.bartworks.API.WerkstoffAdderRegistry;
import com.github.bartimaeusnek.bartworks.MainMod;
import com.github.bartimaeusnek.bartworks.client.renderer.BW_Renderer_Block_Ores;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.system.material.BW_GT_MaterialReference;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedBlock_Item;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedBlocks_Casing;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedBlocks_CasingAdvanced_TE;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedBlocks_Casing_TE;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedOreTE;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedSmallOreTE;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_Items;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_Ores;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_SmallOres;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_WerkstoffBlock_TE;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_WerkstoffBlocks;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.BW_CircuitsLoader;
import com.github.bartimaeusnek.bartworks.system.material.GT_Enhancement.GTMetaItemEnhancer;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.processingLoaders.AdditionalRecipes;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.AspectLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.BlockLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.CasingLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.CellLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.CraftingMaterialLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.CrushedLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.DustLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.GemLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.MetalLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.MoltenCellLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.MultipleMetalLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.OreLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.SimpleMetalLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe.ToolLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.registration.AssociationLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.registration.BridgeMaterialsLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.registration.CasingRegistrator;
import com.github.bartimaeusnek.bartworks.system.oredict.OreDictHandler;
import com.github.bartimaeusnek.bartworks.util.BW_ColorUtil;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.EnumUtils;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.bartworks.util.log.DebugLog;
import com.github.bartimaeusnek.crossmod.cls.CLSCompat;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Element;
import gregtech.api.enums.FluidState;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TextureSet;
import gregtech.api.fluid.GT_FluidFactory;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.util.GT_OreDictUnificator;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class WerkstoffLoader {
    public static final SubTag NOBLE_GAS = SubTag.getNewSubTag((String)"NobleGas");
    public static final SubTag ANAEROBE_GAS = SubTag.getNewSubTag((String)"AnaerobeGas");
    public static final SubTag ANAEROBE_SMELTING = SubTag.getNewSubTag((String)"AnaerobeSmelting");
    public static final SubTag NOBLE_GAS_SMELTING = SubTag.getNewSubTag((String)"NobleGasSmelting");
    public static final SubTag NO_BLAST = SubTag.getNewSubTag((String)"NoBlast");
    public static ItemList rotorMold;
    public static ItemList rotorShape;
    public static ItemList smallGearShape;
    public static ItemList ringMold;
    public static ItemList boltMold;
    public static final Werkstoff Bismutite;
    public static final Werkstoff Bismuthinit;
    public static final Werkstoff Zirconium;
    public static final Werkstoff CubicZirconia;
    public static final Werkstoff FluorBuergerit;
    public static final Werkstoff YttriumOxide;
    public static final Werkstoff ChromoAluminoPovondrait;
    public static final Werkstoff VanadioOxyDravit;
    public static final Werkstoff Olenit;
    public static final Werkstoff Arsenopyrite;
    public static final Werkstoff Ferberite;
    public static final Werkstoff Loellingit;
    public static final Werkstoff Roquesit;
    public static final Werkstoff Bornite;
    public static final Werkstoff Wittichenit;
    public static final Werkstoff Djurleit;
    public static final Werkstoff Huebnerit;
    public static final Werkstoff Thorianit;
    public static final Werkstoff RedZircon;
    public static final Werkstoff Salt;
    public static final Werkstoff Spodumen;
    public static final Werkstoff RockSalt;
    public static final Werkstoff Fayalit;
    public static final Werkstoff Forsterit;
    public static final Werkstoff Hedenbergit;
    public static final Werkstoff DescloiziteZNVO4;
    public static final Werkstoff DescloiziteCUVO4;
    public static final Werkstoff FuchsitAL;
    public static final Werkstoff FuchsitCR;
    public static final Werkstoff Thorium232;
    public static final Werkstoff BismuthTellurite;
    public static final Werkstoff Tellurium;
    public static final Werkstoff BismuthHydroBorat;
    public static final Werkstoff ArInGaPhoBiBoTe;
    public static final Werkstoff Prasiolite;
    public static final Werkstoff MagnetoResonaticDust;
    public static final Werkstoff Xenon;
    public static final Werkstoff Oganesson;
    public static final Werkstoff Californium;
    public static final Werkstoff Calcium;
    public static final Werkstoff Neon;
    public static final Werkstoff Krypton;
    public static final Werkstoff BArTiMaEuSNeK;
    public static final Werkstoff PTConcentrate;
    public static final Werkstoff PTSaltCrude;
    public static final Werkstoff PTSaltRefined;
    public static final Werkstoff PTMetallicPowder;
    public static final Werkstoff AquaRegia;
    public static final Werkstoff PTResidue;
    public static final Werkstoff AmmoniumChloride;
    public static final Werkstoff PTRawPowder;
    public static final Werkstoff PDAmmonia;
    public static final Werkstoff PDMetallicPowder;
    public static final Werkstoff PDRawPowder;
    public static final Werkstoff PDSalt;
    public static final Werkstoff Sodiumformate;
    public static final Werkstoff Sodiumsulfate;
    public static final Werkstoff FormicAcid;
    public static final Werkstoff PotassiumDisulfate;
    public static final Werkstoff LeachResidue;
    public static final Werkstoff RHSulfate;
    public static final Werkstoff RHSulfateSolution;
    public static final Werkstoff CalciumChloride;
    public static final Werkstoff Ruthenium;
    public static final Werkstoff SodiumRuthenate;
    public static final Werkstoff RutheniumTetroxide;
    public static final Werkstoff HotRutheniumTetroxideSollution;
    public static final Werkstoff RutheniumTetroxideSollution;
    public static final Werkstoff IrOsLeachResidue;
    public static final Werkstoff IrLeachResidue;
    public static final Werkstoff PGSDResidue;
    public static final Werkstoff AcidicOsmiumSolution;
    public static final Werkstoff IridiumDioxide;
    public static final Werkstoff OsmiumSolution;
    public static final Werkstoff AcidicIridiumSolution;
    public static final Werkstoff IridiumChloride;
    public static final Werkstoff PGSDResidue2;
    public static final Werkstoff Rhodium;
    public static final Werkstoff CrudeRhMetall;
    public static final Werkstoff RHSalt;
    public static final Werkstoff RHSaltSolution;
    public static final Werkstoff SodiumNitrate;
    public static final Werkstoff RHNitrate;
    public static final Werkstoff ZincSulfate;
    public static final Werkstoff RhFilterCake;
    public static final Werkstoff RHFilterCakeSolution;
    public static final Werkstoff ReRh;
    public static final Werkstoff LuVTierMaterial;
    public static final Werkstoff Tiberium;
    public static final Werkstoff Ruridit;
    public static final Werkstoff Fluorspar;
    public static final Werkstoff HDCS;
    public static final Werkstoff Atheneite;
    public static final Werkstoff Temagamite;
    public static final Werkstoff Terlinguaite;
    public static final Werkstoff AdemicSteel;
    public static final Werkstoff RawAdemicSteel;
    public static final Werkstoff HexafluorosilicicAcid;
    public static final Werkstoff Potassiumfluorosilicate;
    public static final Werkstoff Alumina;
    public static final Werkstoff PotassiumCarbonate;
    public static final Werkstoff RawFluorophlogopite;
    public static final Werkstoff HotFluorophlogopite;
    public static final Werkstoff Fluorophlogopite;
    public static HashMap<OrePrefixes, BW_MetaGenerated_Items> items;
    public static HashBiMap<Werkstoff, Fluid> fluids;
    public static HashBiMap<Werkstoff, Fluid> molten;
    public static Block BWOres;
    public static Block BWSmallOres;
    public static Block BWBlocks;
    public static Block BWBlockCasings;
    public static Block BWBlockCasingsAdvanced;
    public static boolean registered;
    public static final HashSet<OrePrefixes> ENABLED_ORE_PREFIXES;
    public static long toGenerateGlobal;

    private WerkstoffLoader() {
    }

    public static void setUp() {
        OrePrefixes.cellMolten.mMaterialGenerationBits = 64;
        OrePrefixes.capsuleMolten.mMaterialGenerationBits = 64;
        try {
            rotorMold = Enum.valueOf(ItemList.class, "Shape_Mold_Rotor");
            rotorShape = Enum.valueOf(ItemList.class, "Shape_Extruder_Rotor");
            smallGearShape = Enum.valueOf(ItemList.class, "Shape_Extruder_Small_Gear");
            ringMold = Enum.valueOf(ItemList.class, "Shape_Mold_Ring");
            boltMold = Enum.valueOf(ItemList.class, "Shape_Mold_Bolt");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        EnumUtils.createNewElement("Tr", 123L, 203L, 0L, -1L, null, "Tiberium", false);
        OrePrefixes.bottle.mDefaultStackSize = 1;
        Werkstoff.GenerationFeatures.initPrefixLogic();
        BW_GT_MaterialReference.init();
    }

    public static Werkstoff getWerkstoff(String Name2) {
        try {
            Field f = WerkstoffLoader.class.getField(Name2);
            return (Werkstoff)f.get(null);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            MainMod.LOGGER.catching((Throwable)e);
            return Werkstoff.default_null_Werkstoff;
        }
    }

    public static ItemStack getCorrespondingItemStack(OrePrefixes orePrefixes, Werkstoff werkstoff) {
        return WerkstoffLoader.getCorrespondingItemStack(orePrefixes, werkstoff, 1);
    }

    public static ItemStack getCorrespondingItemStackUnsafe(OrePrefixes orePrefixes, Werkstoff werkstoff, int amount) {
        if (!werkstoff.getGenerationFeatures().enforceUnification) {
            ItemStack ret = GT_OreDictUnificator.get((OrePrefixes)orePrefixes, (Object)werkstoff.getBridgeMaterial(), (long)amount);
            if (ret != null) {
                return ret;
            }
            ret = OreDictHandler.getItemStack(werkstoff.getVarName(), orePrefixes, amount);
            if (ret != null) {
                return ret;
            }
        }
        if (orePrefixes == OrePrefixes.ore) {
            return new ItemStack(BWOres, amount, (int)werkstoff.getmID());
        }
        if (orePrefixes == OrePrefixes.oreSmall) {
            return new ItemStack(BWSmallOres, amount, (int)werkstoff.getmID());
        }
        if (orePrefixes == OrePrefixes.block) {
            return new ItemStack(BWBlocks, amount, (int)werkstoff.getmID());
        }
        if (orePrefixes == OrePrefixes.blockCasing) {
            return new ItemStack(BWBlockCasings, amount, (int)werkstoff.getmID());
        }
        if (orePrefixes == OrePrefixes.blockCasingAdvanced) {
            return new ItemStack(BWBlockCasingsAdvanced, amount, (int)werkstoff.getmID());
        }
        if (items.get(orePrefixes) == null) {
            return null;
        }
        return new ItemStack((Item)items.get(orePrefixes), amount, (int)werkstoff.getmID()).func_77946_l();
    }

    public static ItemStack getCorrespondingItemStack(OrePrefixes orePrefixes, Werkstoff werkstoff, int amount) {
        ItemStack stack = WerkstoffLoader.getCorrespondingItemStackUnsafe(orePrefixes, werkstoff, amount);
        if (stack != null) {
            return stack;
        }
        MainMod.LOGGER.catching(Level.ERROR, (Throwable)new Exception("NO SUCH ITEM! " + orePrefixes + werkstoff.getVarName() + " If you encounter this as a user, make sure to contact the authors of the pack/the mods you're playing! If you are a Developer, you forgot to enable " + orePrefixes + " OrePrefix for Werkstoff " + werkstoff.getDefaultName()));
        return new ItemStack((Item)items.get(orePrefixes), amount, (int)werkstoff.getmID()).func_77946_l();
    }

    public static void runInit() {
        MainMod.LOGGER.info("Making Meta Items for BW Materials");
        long timepre = System.nanoTime();
        WerkstoffAdderRegistry.run();
        WerkstoffLoader.addSubTags();
        WerkstoffLoader.addItemsForGeneration();
        WerkstoffLoader.addBridgeSubTags();
        WerkstoffLoader.runAdditionalOreDict();
        long timepost = System.nanoTime();
        MainMod.LOGGER.info("Making Meta Items for BW Materials took " + (timepost - timepre) + "ns/" + (timepost - timepre) / 1000000L + "ms/" + (timepost - timepre) / 1000000000L + "s!");
    }

    public static void run() {
        if (!registered) {
            MainMod.LOGGER.info("Loading Processing Recipes for BW Materials");
            long timepre = System.nanoTime();
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Register BW Materials", (int)(Werkstoff.werkstoffHashSet.size() + 1));
            DebugLog.log("Loading Recipes" + (System.nanoTime() - timepre));
            Integer[] clsArr = new Integer[]{};
            int size = 0;
            if (Mods.BetterLoadingScreen.isModLoaded()) {
                clsArr = CLSCompat.initCls();
            }
            IWerkstoffRunnable[] werkstoffRunnables = new IWerkstoffRunnable[]{new ToolLoader(), new DustLoader(), new GemLoader(), new SimpleMetalLoader(), new CasingLoader(), new AspectLoader(), new OreLoader(), new CrushedLoader(), new CraftingMaterialLoader(), new CellLoader(), new MoltenCellLoader(), new MultipleMetalLoader(), new MetalLoader(), new BlockLoader()};
            long timepreone = 0L;
            for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
                timepreone = System.nanoTime();
                DebugLog.log("Werkstoff is null or id < 0 ? " + (werkstoff == null || werkstoff.getmID() < 0) + " " + (System.nanoTime() - timepreone));
                if (werkstoff == null || werkstoff.getmID() < 0) {
                    progressBar.step("");
                    continue;
                }
                if (Mods.BetterLoadingScreen.isModLoaded()) {
                    size = CLSCompat.invokeStepSize(werkstoff, clsArr, size);
                }
                DebugLog.log("Werkstoff: " + werkstoff.getDefaultName() + " " + (System.nanoTime() - timepreone));
                for (IWerkstoffRunnable runnable : werkstoffRunnables) {
                    String loaderName = runnable.getClass().getSimpleName();
                    DebugLog.log(loaderName + " started " + (System.nanoTime() - timepreone));
                    runnable.run(werkstoff);
                    DebugLog.log(loaderName + " done " + (System.nanoTime() - timepreone));
                }
                DebugLog.log("Done " + (System.nanoTime() - timepreone));
                progressBar.step(werkstoff.getDefaultName());
            }
            DebugLog.log("Loading New Circuits " + (System.nanoTime() - timepreone));
            BW_CircuitsLoader.initNewCircuits();
            if (Mods.BetterLoadingScreen.isModLoaded()) {
                CLSCompat.disableCls();
            }
            progressBar.step("Load Additional Recipes");
            AdditionalRecipes.run();
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
            long timepost = System.nanoTime();
            MainMod.LOGGER.info("Loading Processing Recipes for BW Materials took " + (timepost - timepre) + "ns/" + (timepost - timepre) / 1000000L + "ms/" + (timepost - timepre) / 1000000000L + "s!");
            registered = true;
        }
    }

    private static void addSubTags() {
        CubicZirconia.getStats().setDurOverride(Materials.Diamond.mDurability);
        HDCS.getStats().setSpeedOverride(Materials.HSSS.mToolSpeed);
        HDCS.getStats().setDurMod(10.0f);
        Materials.Helium.add(new SubTag[]{NOBLE_GAS});
        Neon.add(NOBLE_GAS);
        Materials.Argon.add(new SubTag[]{NOBLE_GAS});
        Krypton.add(NOBLE_GAS);
        Xenon.add(NOBLE_GAS, ANAEROBE_GAS);
        Materials.Radon.add(new SubTag[]{NOBLE_GAS});
        Oganesson.add(NOBLE_GAS, ANAEROBE_GAS);
        Materials.Nitrogen.add(new SubTag[]{ANAEROBE_GAS});
        Calcium.add(ANAEROBE_SMELTING);
        LuVTierMaterial.add(NOBLE_GAS_SMELTING);
        Ruridit.add(NOBLE_GAS_SMELTING);
        AdemicSteel.add(NOBLE_GAS_SMELTING);
        MagnetoResonaticDust.add(NO_BLAST);
        Materials.Calcium.mBlastFurnaceRequired = true;
        Materials.Salt.mDurability = Salt.getDurability();
        Materials.Spodumene.mDurability = Spodumen.getDurability();
        Materials.RockSalt.mDurability = RockSalt.getDurability();
        Materials.Calcium.mDurability = Calcium.getDurability();
        Materials.Salt.mToolSpeed = Salt.getToolSpeed();
        Materials.Spodumene.mToolSpeed = Spodumen.getToolSpeed();
        Materials.RockSalt.mToolSpeed = RockSalt.getToolSpeed();
        Materials.Calcium.mToolSpeed = Calcium.getToolSpeed();
        Materials.Salt.mToolQuality = Salt.getToolQuality();
        Materials.Spodumene.mToolQuality = Spodumen.getToolQuality();
        Materials.RockSalt.mToolQuality = RockSalt.getToolQuality();
        Materials.Calcium.mToolQuality = Calcium.getToolQuality();
        for (Werkstoff W : Werkstoff.werkstoffHashSet) {
            for (Pair pair : W.getContents().getValue().toArray(new Pair[0])) {
                if (pair.getKey() instanceof Materials && pair.getKey() == Materials.Neodymium) {
                    W.add(SubTag.ELECTROMAGNETIC_SEPERATION_NEODYMIUM);
                    break;
                }
                if (pair.getKey() instanceof Materials && pair.getKey() == Materials.Iron) {
                    W.add(SubTag.ELECTROMAGNETIC_SEPERATION_IRON);
                    break;
                }
                if (!(pair.getKey() instanceof Materials) || pair.getKey() != Materials.Gold) continue;
                W.add(SubTag.ELECTROMAGNETIC_SEPERATION_GOLD);
                break;
            }
            if (!W.hasItemType(OrePrefixes.gem)) continue;
            W.add(SubTag.CRYSTAL);
            W.add(SubTag.CRYSTALLISABLE);
        }
    }

    private static void addBridgeSubTags() {
        SubTag.METAL.addTo(new ISubTagContainer[]{LuVTierMaterial.getBridgeMaterial()});
    }

    private static void addItemsForGeneration() {
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            Fluid fluid;
            if (werkstoff.hasItemType(OrePrefixes.cell)) {
                if (!FluidRegistry.isFluidRegistered((String)werkstoff.getDefaultName())) {
                    DebugLog.log("Adding new Fluid: " + werkstoff.getDefaultName());
                    fluid = GT_FluidFactory.builder((String)werkstoff.getDefaultName()).withLocalizedName(werkstoff.getDefaultName()).withStateAndTemperature(werkstoff.getStats().getFluidState(), 300).withColorRGBA(werkstoff.getRGBA()).withTextureName("autogenerated").buildAndRegister().asFluid();
                    fluids.put((Object)werkstoff, (Object)fluid);
                } else {
                    fluids.put((Object)werkstoff, (Object)FluidRegistry.getFluid((String)werkstoff.getDefaultName()));
                }
            }
            if (werkstoff.hasItemType(OrePrefixes.cellMolten)) {
                if (!FluidRegistry.isFluidRegistered((String)("molten." + werkstoff.getDefaultName()))) {
                    DebugLog.log("Adding new Molten: " + werkstoff.getDefaultName());
                    fluid = GT_FluidFactory.builder((String)("molten." + werkstoff.getDefaultName())).withLocalizedName("Molten " + werkstoff.getDefaultName()).withStateAndTemperature(FluidState.MOLTEN, werkstoff.getStats().getMeltingPoint() > 0 ? werkstoff.getStats().getMeltingPoint() : 300).withColorRGBA(werkstoff.getRGBA()).withTextureName("molten.autogenerated").buildAndRegister().asFluid();
                    molten.put((Object)werkstoff, (Object)fluid);
                } else {
                    molten.put((Object)werkstoff, (Object)FluidRegistry.getFluid((String)werkstoff.getDefaultName()));
                }
            }
            for (OrePrefixes p : OrePrefixes.values()) {
                if (Materials.get((String)werkstoff.getDefaultName()) == null || Materials.get((String)werkstoff.getDefaultName()).mMetaItemSubID == -1 || (werkstoff.getGenerationFeatures().toGenerate & (long)p.mMaterialGenerationBits) == 0L || OreDictHandler.getItemStack(werkstoff.getDefaultName(), p, 1) == null) continue;
                DebugLog.log("Found: " + p + werkstoff.getVarName() + " in GT material system, disable and reroute my Items to that, also add a Tooltip.");
                werkstoff.getGenerationFeatures().setBlacklist(p);
            }
            toGenerateGlobal |= werkstoff.getGenerationFeatures().toGenerate;
        }
        DebugLog.log("GlobalGeneration: " + toGenerateGlobal);
        if ((toGenerateGlobal & 1L) != 0L) {
            items.put(OrePrefixes.dust, new BW_MetaGenerated_Items(OrePrefixes.dust));
            items.put(OrePrefixes.dustTiny, new BW_MetaGenerated_Items(OrePrefixes.dustTiny));
            items.put(OrePrefixes.dustSmall, new BW_MetaGenerated_Items(OrePrefixes.dustSmall));
        }
        if ((toGenerateGlobal & 2L) != 0L) {
            items.put(OrePrefixes.ingot, new BW_MetaGenerated_Items(OrePrefixes.ingot));
            items.put(OrePrefixes.ingotHot, new BW_MetaGenerated_Items(OrePrefixes.ingotHot));
            items.put(OrePrefixes.nugget, new BW_MetaGenerated_Items(OrePrefixes.nugget));
        }
        if ((toGenerateGlobal & 4L) != 0L) {
            items.put(OrePrefixes.gem, new BW_MetaGenerated_Items(OrePrefixes.gem));
            items.put(OrePrefixes.gemChipped, new BW_MetaGenerated_Items(OrePrefixes.gemChipped));
            items.put(OrePrefixes.gemExquisite, new BW_MetaGenerated_Items(OrePrefixes.gemExquisite));
            items.put(OrePrefixes.gemFlawed, new BW_MetaGenerated_Items(OrePrefixes.gemFlawed));
            items.put(OrePrefixes.gemFlawless, new BW_MetaGenerated_Items(OrePrefixes.gemFlawless));
            items.put(OrePrefixes.lens, new BW_MetaGenerated_Items(OrePrefixes.lens));
        }
        if ((toGenerateGlobal & 8L) != 0L) {
            WerkstoffLoader.gameRegistryHandler();
            items.put(OrePrefixes.crushed, new BW_MetaGenerated_Items(OrePrefixes.crushed));
            items.put(OrePrefixes.crushedPurified, new BW_MetaGenerated_Items(OrePrefixes.crushedPurified));
            items.put(OrePrefixes.crushedCentrifuged, new BW_MetaGenerated_Items(OrePrefixes.crushedCentrifuged));
            items.put(OrePrefixes.dustPure, new BW_MetaGenerated_Items(OrePrefixes.dustPure));
            items.put(OrePrefixes.dustImpure, new BW_MetaGenerated_Items(OrePrefixes.dustImpure));
        }
        if ((toGenerateGlobal & 0x10L) != 0L) {
            items.put(OrePrefixes.cell, new BW_MetaGenerated_Items(OrePrefixes.cell));
            if (Mods.Forestry.isModLoaded()) {
                items.put(OrePrefixes.capsule, new BW_MetaGenerated_Items(OrePrefixes.capsule));
            }
        }
        if ((toGenerateGlobal & 0x20L) != 0L) {
            items.put(OrePrefixes.cellPlasma, new BW_MetaGenerated_Items(OrePrefixes.cellPlasma));
        }
        if ((toGenerateGlobal & 0x40L) != 0L) {
            items.put(OrePrefixes.cellMolten, new BW_MetaGenerated_Items(OrePrefixes.cellMolten));
            if (Mods.Forestry.isModLoaded()) {
                items.put(OrePrefixes.capsuleMolten, new BW_MetaGenerated_Items(OrePrefixes.capsuleMolten));
            }
        }
        if ((toGenerateGlobal & 0x80L) != 0L) {
            items.put(OrePrefixes.plate, new BW_MetaGenerated_Items(OrePrefixes.plate));
            items.put(OrePrefixes.foil, new BW_MetaGenerated_Items(OrePrefixes.foil));
            items.put(OrePrefixes.stick, new BW_MetaGenerated_Items(OrePrefixes.stick));
            items.put(OrePrefixes.stickLong, new BW_MetaGenerated_Items(OrePrefixes.stickLong));
            items.put(OrePrefixes.toolHeadWrench, new BW_MetaGenerated_Items(OrePrefixes.toolHeadWrench));
            items.put(OrePrefixes.toolHeadHammer, new BW_MetaGenerated_Items(OrePrefixes.toolHeadHammer));
            items.put(OrePrefixes.toolHeadSaw, new BW_MetaGenerated_Items(OrePrefixes.toolHeadSaw));
            items.put(OrePrefixes.turbineBlade, new BW_MetaGenerated_Items(OrePrefixes.turbineBlade));
        }
        if ((toGenerateGlobal & 0x100L) != 0L) {
            items.put(OrePrefixes.gearGt, new BW_MetaGenerated_Items(OrePrefixes.gearGt));
            items.put(OrePrefixes.gearGtSmall, new BW_MetaGenerated_Items(OrePrefixes.gearGtSmall));
            items.put(OrePrefixes.bolt, new BW_MetaGenerated_Items(OrePrefixes.bolt));
            items.put(OrePrefixes.screw, new BW_MetaGenerated_Items(OrePrefixes.screw));
            items.put(OrePrefixes.ring, new BW_MetaGenerated_Items(OrePrefixes.ring));
            items.put(OrePrefixes.spring, new BW_MetaGenerated_Items(OrePrefixes.spring));
            items.put(OrePrefixes.springSmall, new BW_MetaGenerated_Items(OrePrefixes.springSmall));
            items.put(OrePrefixes.rotor, new BW_MetaGenerated_Items(OrePrefixes.rotor));
            items.put(OrePrefixes.wireFine, new BW_MetaGenerated_Items(OrePrefixes.wireFine));
        }
        if ((toGenerateGlobal & 0x200L) != 0L) {
            items.put(OrePrefixes.plateDouble, new BW_MetaGenerated_Items(OrePrefixes.plateDouble));
            items.put(OrePrefixes.plateTriple, new BW_MetaGenerated_Items(OrePrefixes.plateTriple));
            items.put(OrePrefixes.plateQuadruple, new BW_MetaGenerated_Items(OrePrefixes.plateQuadruple));
            items.put(OrePrefixes.plateQuintuple, new BW_MetaGenerated_Items(OrePrefixes.plateQuintuple));
            items.put(OrePrefixes.plateDense, new BW_MetaGenerated_Items(OrePrefixes.plateDense));
            items.put(OrePrefixes.ingotDouble, new BW_MetaGenerated_Items(OrePrefixes.ingotDouble));
            items.put(OrePrefixes.ingotTriple, new BW_MetaGenerated_Items(OrePrefixes.ingotTriple));
            items.put(OrePrefixes.ingotQuadruple, new BW_MetaGenerated_Items(OrePrefixes.ingotQuadruple));
            items.put(OrePrefixes.ingotQuintuple, new BW_MetaGenerated_Items(OrePrefixes.ingotQuintuple));
        }
        ENABLED_ORE_PREFIXES.addAll(items.keySet());
        ENABLED_ORE_PREFIXES.add(OrePrefixes.ore);
        ENABLED_ORE_PREFIXES.add(OrePrefixes.oreSmall);
        WerkstoffLoader.runGTItemDataRegistrator();
    }

    static void gameRegistryHandler() {
        if (SideReference.Side.Client) {
            BW_Renderer_Block_Ores.register();
        }
        GameRegistry.registerTileEntity(BW_MetaGeneratedOreTE.class, (String)"bw.blockoresTE");
        GameRegistry.registerTileEntity(BW_MetaGeneratedSmallOreTE.class, (String)"bw.blockoresSmallTE");
        GameRegistry.registerTileEntity(BW_MetaGenerated_WerkstoffBlock_TE.class, (String)"bw.werkstoffblockTE");
        GameRegistry.registerTileEntity(BW_MetaGeneratedBlocks_Casing_TE.class, (String)"bw.werkstoffblockcasingTE");
        GameRegistry.registerTileEntity(BW_MetaGeneratedBlocks_CasingAdvanced_TE.class, (String)"bw.werkstoffblockscasingadvancedTE");
        BWOres = new BW_MetaGenerated_Ores(Material.field_151576_e, BW_MetaGeneratedOreTE.class, "bw.blockores");
        BWSmallOres = new BW_MetaGenerated_SmallOres(Material.field_151576_e, BW_MetaGeneratedSmallOreTE.class, "bw.blockoresSmall");
        BWBlocks = new BW_MetaGenerated_WerkstoffBlocks(Material.field_151573_f, BW_MetaGenerated_WerkstoffBlock_TE.class, "bw.werkstoffblocks");
        BWBlockCasings = new BW_MetaGeneratedBlocks_Casing(Material.field_151573_f, BW_MetaGeneratedBlocks_Casing_TE.class, "bw.werkstoffblockscasing", OrePrefixes.blockCasing);
        BWBlockCasingsAdvanced = new BW_MetaGeneratedBlocks_Casing(Material.field_151573_f, BW_MetaGeneratedBlocks_CasingAdvanced_TE.class, "bw.werkstoffblockscasingadvanced", OrePrefixes.blockCasingAdvanced);
        GameRegistry.registerBlock((Block)BWOres, BW_MetaGeneratedBlock_Item.class, (String)"bw.blockores.01");
        GameRegistry.registerBlock((Block)BWSmallOres, BW_MetaGeneratedBlock_Item.class, (String)"bw.blockores.02");
        GameRegistry.registerBlock((Block)BWBlocks, BW_MetaGeneratedBlock_Item.class, (String)"bw.werkstoffblocks.01");
        if (!ConfigHandler.disableBoltedBlocksCasing) {
            GameRegistry.registerBlock((Block)BWBlockCasings, BW_MetaGeneratedBlock_Item.class, (String)"bw.werkstoffblockscasing.01");
        }
        if (!ConfigHandler.disableReboltedBlocksCasing) {
            GameRegistry.registerBlock((Block)BWBlockCasingsAdvanced, BW_MetaGeneratedBlock_Item.class, (String)"bw.werkstoffblockscasingadvanced.01");
        }
        GTMetaItemEnhancer.addAdditionalOreDictToForestry();
        GTMetaItemEnhancer.init();
    }

    private static void runGTItemDataRegistrator() {
        IWerkstoffRunnable[] registrations = new IWerkstoffRunnable[]{new BridgeMaterialsLoader(), new AssociationLoader(), new CasingRegistrator()};
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            for (IWerkstoffRunnable registration : registrations) {
                registration.run(werkstoff);
            }
        }
        WerkstoffLoader.addFakeItemDataToInWorldBlocksAndCleanUpFakeData();
        WerkstoffLoader.addVanillaCasingsToGTOreDictUnificator();
    }

    public static void addVanillaCasingsToGTOreDictUnificator() {
        GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.blockCasing, (Materials)Materials.Aluminium, (ItemStack)ItemList.Casing_FrostProof.get(1L, new Object[0]), (boolean)false);
        GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.blockCasing, (Materials)Materials.Nickel, (ItemStack)ItemList.Casing_HeatProof.get(1L, new Object[0]), (boolean)false);
        GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.blockCasing, (Materials)Materials.Lead, (ItemStack)ItemList.Casing_RadiationProof.get(1L, new Object[0]), (boolean)false);
        GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.blockCasing, (Materials)Materials.Steel, (ItemStack)ItemList.Casing_SolidSteel.get(1L, new Object[0]), (boolean)false);
        GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.blockCasing, (Materials)Materials.TungstenSteel, (ItemStack)ItemList.Casing_RobustTungstenSteel.get(1L, new Object[0]), (boolean)false);
        GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.blockCasing, (Materials)Materials.Polytetrafluoroethylene, (ItemStack)ItemList.Casing_Chemically_Inert.get(1L, new Object[0]), (boolean)false);
    }

    private static void addFakeItemDataToInWorldBlocksAndCleanUpFakeData() {
        Map MATERIALS_MAP = null;
        try {
            Field f = Materials.class.getDeclaredField("MATERIALS_MAP");
            f.setAccessible(true);
            MATERIALS_MAP = (Map)f.get(null);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        if (MATERIALS_MAP == null) {
            throw new NullPointerException("MATERIALS_MAP null!");
        }
        Materials oreMat = new Materials(-1, null, 0.0f, 0, 0, false, "bwores", "bwores", null, true, null);
        Materials smallOreMat = new Materials(-1, null, 0.0f, 0, 0, false, "bwsmallores", "bwsmallores", null, true, null);
        Materials blockMat = new Materials(-1, null, 0.0f, 0, 0, false, "bwblocks", "bwblocks", null, true, null);
        for (int i = 0; i < 16; ++i) {
            GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.ore, (Materials)oreMat, (ItemStack)new ItemStack(BWOres, 1, i), (boolean)true);
            GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.oreSmall, (Materials)smallOreMat, (ItemStack)new ItemStack(BWSmallOres, 1, i), (boolean)true);
            GT_OreDictUnificator.addAssociation((OrePrefixes)OrePrefixes.block, (Materials)blockMat, (ItemStack)new ItemStack(BWBlocks, 1, i), (boolean)true);
        }
        MATERIALS_MAP.remove("bwores");
        MATERIALS_MAP.remove("bwsmallores");
        MATERIALS_MAP.remove("bwblocks");
    }

    public static void removeIC2Recipes() {
        try {
            HashSet remset = new HashSet();
            for (Map.Entry curr : Recipes.macerator.getRecipes().entrySet()) {
                if (!(curr.getKey() instanceof RecipeInputOreDict)) continue;
                if ("oreNULL".equalsIgnoreCase(((RecipeInputOreDict)curr.getKey()).input)) {
                    remset.add(curr);
                }
                for (ItemStack stack : ((RecipeOutput)curr.getValue()).items) {
                    if (!(stack.func_77973_b() instanceof BW_MetaGenerated_Items)) continue;
                    remset.add(curr);
                }
            }
            Recipes.macerator.getRecipes().entrySet().removeAll(remset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void runAdditionalOreDict() {
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            if (werkstoff.hasItemType(OrePrefixes.ore)) {
                GT_OreDictUnificator.registerOre((Object)(OrePrefixes.ore + werkstoff.getVarName()), (ItemStack)werkstoff.get(OrePrefixes.ore));
                GT_OreDictUnificator.registerOre((Object)(OrePrefixes.oreSmall + werkstoff.getVarName()), (ItemStack)werkstoff.get(OrePrefixes.oreSmall));
                werkstoff.getADDITIONAL_OREDICT().forEach(e -> OreDictionary.registerOre((String)(OrePrefixes.ore + e), (ItemStack)werkstoff.get(OrePrefixes.ore)));
                werkstoff.getADDITIONAL_OREDICT().forEach(e -> OreDictionary.registerOre((String)(OrePrefixes.oreSmall + e), (ItemStack)werkstoff.get(OrePrefixes.oreSmall)));
            }
            if (werkstoff.hasItemType(OrePrefixes.gem)) {
                OreDictionary.registerOre((String)("craftingLens" + BW_ColorUtil.getDyeFromColor((short[])werkstoff.getRGBA()).mName.replace(" ", "")), (ItemStack)werkstoff.get(OrePrefixes.lens));
            }
            if (werkstoff.hasItemType(OrePrefixes.gem) || werkstoff.hasItemType(OrePrefixes.ingot)) {
                GT_OreDictUnificator.registerOre((Object)(OrePrefixes.block + werkstoff.getVarName()), (ItemStack)werkstoff.get(OrePrefixes.block));
                werkstoff.getADDITIONAL_OREDICT().forEach(e -> OreDictionary.registerOre((String)(OrePrefixes.block + e), (ItemStack)werkstoff.get(OrePrefixes.block)));
            }
            werkstoff.getADDITIONAL_OREDICT().forEach(s -> ENABLED_ORE_PREFIXES.stream().filter(o -> Objects.nonNull(werkstoff.get((OrePrefixes)o))).forEach(od -> OreDictionary.registerOre((String)(od + s), (ItemStack)werkstoff.get((OrePrefixes)od))));
        }
        GT_OreDictUnificator.registerOre((Object)"craftingIndustrialDiamond", (ItemStack)CubicZirconia.get(OrePrefixes.gemExquisite));
    }

    static {
        Bismutite = new Werkstoff(new short[]{255, 233, 0, 0}, "Bismutite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 1, TextureSet.SET_FLINT, Collections.singletonList(Materials.Bismuth), new Pair<Materials, Integer>(Materials.Bismuth, 2), new Pair<Materials, Integer>(Materials.Oxygen, 2), new Pair<Materials, Integer>(Materials.CarbonDioxide, 2));
        Bismuthinit = new Werkstoff(new short[]{192, 192, 192, 0}, "Bismuthinite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 2, TextureSet.SET_METALLIC, Arrays.asList(Materials.Bismuth, Materials.Sulfur), new Pair<Materials, Integer>(Materials.Bismuth, 2), new Pair<Materials, Integer>(Materials.Sulfur, 3));
        Zirconium = new Werkstoff(new short[]{175, 175, 175, 0}, "Zirconium", "Zr", new Werkstoff.Stats().setProtons(40L).setBlastFurnace(true).setMeltingPoint(2130).setMeltingVoltage(480), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems().enforceUnification(), 3, TextureSet.SET_METALLIC, new Pair[0]);
        CubicZirconia = new Werkstoff(new short[]{255, 255, 255, 0}, "Cubic Zirconia", Werkstoff.Types.COMPOUND, 3273, new Werkstoff.GenerationFeatures().onlyDust().addGems().enforceUnification(), 4, TextureSet.SET_DIAMOND, Collections.singletonList(Zirconium), new Pair<Werkstoff, Integer>(Zirconium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 2));
        FluorBuergerit = new Werkstoff(new short[]{32, 32, 32, 0}, "Fluor-Buergerite", BW_Util.subscriptNumbers("NaFe3Al6(Si6O18)(BO3)3O3F"), new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 5, TextureSet.SET_RUBY, Arrays.asList(Materials.Sodium, Materials.Boron, Materials.SiliconDioxide), new Pair<Materials, Integer>(Materials.Sodium, 1), new Pair<Materials, Integer>(Materials.Iron, 3), new Pair<Materials, Integer>(Materials.Aluminium, 6), new Pair<Materials, Integer>(Materials.Silicon, 6), new Pair<Materials, Integer>(Materials.Boron, 3), new Pair<Materials, Integer>(Materials.Oxygen, 30), new Pair<Materials, Integer>(Materials.Fluorine, 1));
        YttriumOxide = new Werkstoff(new short[]{255, 255, 255, 0}, "Yttrium Oxide", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().onlyDust().enforceUnification(), 6, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Yttrium, 2), new Pair<Materials, Integer>(Materials.Oxygen, 3));
        ChromoAluminoPovondrait = new Werkstoff(new short[]{0, 121, 106, 0}, "Chromo-Alumino-Povondraite", BW_Util.subscriptNumbers("NaCr3(Al4Mg2)(Si6O18)(BO3)3(OH)3O"), Werkstoff.Types.getDefaultStatForType(Werkstoff.Types.COMPOUND).setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 7, TextureSet.SET_RUBY, Arrays.asList(Materials.Sodium, Materials.Boron, Materials.SiliconDioxide), new Pair<Materials, Integer>(Materials.Sodium, 1), new Pair<Materials, Integer>(Materials.Chrome, 3), new Pair<Materials, Integer>(Materials.Magnalium, 6), new Pair<Materials, Integer>(Materials.Silicon, 6), new Pair<Materials, Integer>(Materials.Boron, 3), new Pair<Materials, Integer>(Materials.Oxygen, 31), new Pair<Materials, Integer>(Materials.Hydrogen, 3));
        VanadioOxyDravit = new Werkstoff(new short[]{96, 160, 160, 0}, "Vanadio-Oxy-Dravite", BW_Util.subscriptNumbers("NaV3(Al4Mg2)(Si6O18)(BO3)3(OH)3O"), Werkstoff.Types.getDefaultStatForType(Werkstoff.Types.COMPOUND).setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 8, TextureSet.SET_RUBY, Arrays.asList(Materials.Sodium, Materials.Boron, Materials.SiliconDioxide), new Pair<Materials, Integer>(Materials.Sodium, 1), new Pair<Materials, Integer>(Materials.Vanadium, 3), new Pair<Materials, Integer>(Materials.Magnalium, 6), new Pair<Materials, Integer>(Materials.Silicon, 6), new Pair<Materials, Integer>(Materials.Boron, 3), new Pair<Materials, Integer>(Materials.Oxygen, 31), new Pair<Materials, Integer>(Materials.Hydrogen, 3));
        Olenit = new Werkstoff(new short[]{210, 210, 210, 0}, "Olenite", BW_Util.subscriptNumbers("NaAl3Al6(Si6O18)(BO3)3O3OH"), Werkstoff.Types.getDefaultStatForType(Werkstoff.Types.COMPOUND).setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 9, TextureSet.SET_RUBY, Arrays.asList(Materials.Sodium, Materials.Boron, Materials.SiliconDioxide), new Pair<Materials, Integer>(Materials.Sodium, 1), new Pair<Materials, Integer>(Materials.Aluminium, 9), new Pair<Materials, Integer>(Materials.Silicon, 6), new Pair<Materials, Integer>(Materials.Boron, 3), new Pair<Materials, Integer>(Materials.Oxygen, 31), new Pair<Materials, Integer>(Materials.Hydrogen, 1));
        Arsenopyrite = new Werkstoff(new short[]{176, 176, 176, 0}, "Arsenopyrite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 10, TextureSet.SET_METALLIC, Arrays.asList(Materials.Sulfur, Materials.Arsenic, Materials.Iron), new Pair<Materials, Integer>(Materials.Iron, 1), new Pair<Materials, Integer>(Materials.Arsenic, 1), new Pair<Materials, Integer>(Materials.Sulfur, 1));
        Ferberite = new Werkstoff(new short[]{176, 176, 176, 0}, "Ferberite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 11, TextureSet.SET_METALLIC, Arrays.asList(Materials.Iron, Materials.Tungsten), new Pair<Materials, Integer>(Materials.Iron, 1), new Pair<Materials, Integer>(Materials.Tungsten, 1), new Pair<Materials, Integer>(Materials.Oxygen, 3));
        Loellingit = new Werkstoff(new short[]{208, 208, 208, 0}, "Loellingite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 12, TextureSet.SET_METALLIC, Arrays.asList(Materials.Iron, Materials.Arsenic), new Pair<Materials, Integer>(Materials.Iron, 1), new Pair<Materials, Integer>(Materials.Arsenic, 2));
        Roquesit = new Werkstoff(new short[]{160, 160, 160, 0}, "Roquesite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 13, TextureSet.SET_METALLIC, Arrays.asList(Materials.Copper, Materials.Sulfur), new Pair<Materials, Integer>(Materials.Copper, 1), new Pair<Materials, Integer>(Materials.Indium, 1), new Pair<Materials, Integer>(Materials.Sulfur, 2));
        Bornite = new Werkstoff(new short[]{151, 102, 43, 0}, "Bornite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 14, TextureSet.SET_METALLIC, Arrays.asList(Materials.Copper, Materials.Iron, Materials.Sulfur), new Pair<Materials, Integer>(Materials.Copper, 5), new Pair<Materials, Integer>(Materials.Iron, 1), new Pair<Materials, Integer>(Materials.Sulfur, 4));
        Wittichenit = new Werkstoff(Materials.Copper.mRGBa, "Wittichenite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 15, TextureSet.SET_METALLIC, Arrays.asList(Materials.Copper, Materials.Bismuth, Materials.Sulfur), new Pair<Materials, Integer>(Materials.Copper, 5), new Pair<Materials, Integer>(Materials.Bismuth, 1), new Pair<Materials, Integer>(Materials.Sulfur, 4));
        Djurleit = new Werkstoff(new short[]{96, 96, 96, 0}, "Djurleite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 16, TextureSet.SET_METALLIC, Arrays.asList(Materials.Copper, Materials.Copper, Materials.Sulfur), new Pair<Materials, Integer>(Materials.Copper, 31), new Pair<Materials, Integer>(Materials.Sulfur, 16));
        Huebnerit = new Werkstoff(new short[]{128, 96, 96, 0}, "Huebnerite", Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 17, TextureSet.SET_METALLIC, Arrays.asList(Materials.Manganese, Materials.Tungsten), new Pair<Materials, Integer>(Materials.Manganese, 1), new Pair<Materials, Integer>(Materials.Tungsten, 1), new Pair<Materials, Integer>(Materials.Oxygen, 3));
        Thorianit = new Werkstoff(new short[]{48, 48, 48, 0}, "Thorianite", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 18, TextureSet.SET_METALLIC, Collections.singletonList(Materials.Thorium), new Pair<Materials, Integer>(Materials.Thorium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 2));
        RedZircon = new Werkstoff(new short[]{195, 19, 19, 0}, "Red Zircon", new Werkstoff.Stats().setElektrolysis(false).setMeltingPoint(2130), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 19, TextureSet.SET_GEM_VERTICAL, Arrays.asList(Zirconium, Materials.SiliconDioxide), new Pair<Werkstoff, Integer>(Zirconium, 1), new Pair<Materials, Integer>(Materials.Silicon, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        Salt = new Werkstoff(Materials.Salt.mRGBa, "Salt", new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addGems().addSifterRecipes(), 20, TextureSet.SET_FLINT, Arrays.asList(Materials.RockSalt, Materials.Borax), new Pair<Materials, Integer>(Materials.Salt, 1));
        Spodumen = new Werkstoff(Materials.Spodumene.mRGBa, "Spodumene", new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addGems().addSifterRecipes(), 21, TextureSet.SET_FLINT, Collections.singletonList(Materials.Spodumene), new Pair<Materials, Integer>(Materials.Spodumene, 1));
        RockSalt = new Werkstoff(Materials.RockSalt.mRGBa, "Rock Salt", new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addGems().addSifterRecipes(), 22, TextureSet.SET_FLINT, Arrays.asList(Materials.RockSalt, Materials.Borax), new Pair<Materials, Integer>(Materials.RockSalt, 1));
        Fayalit = new Werkstoff(new short[]{50, 50, 50, 0}, "Fayalite", new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 23, TextureSet.SET_QUARTZ, Arrays.asList(Materials.Iron, Materials.SiliconDioxide), new Pair<Materials, Integer>(Materials.Iron, 2), new Pair<Materials, Integer>(Materials.Silicon, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        Forsterit = new Werkstoff(new short[]{255, 255, 255, 0}, "Forsterite", new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 24, TextureSet.SET_QUARTZ, Arrays.asList(Materials.Magnesium, Materials.SiliconDioxide), new Pair<Materials, Integer>(Materials.Magnesium, 2), new Pair<Materials, Integer>(Materials.Silicon, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        Hedenbergit = new Werkstoff(new short[]{100, 150, 100, 0}, "Hedenbergite", new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 25, TextureSet.SET_QUARTZ, Arrays.asList(Materials.Iron, Materials.Calcium, Materials.SiliconDioxide), new Pair<Materials, Integer>(Materials.Calcium, 1), new Pair<Materials, Integer>(Materials.Iron, 1), new Pair<Materials, Integer>(Materials.Silicon, 2), new Pair<Materials, Integer>(Materials.Oxygen, 6));
        DescloiziteZNVO4 = new Werkstoff(new short[]{191, 24, 15, 0}, "Red Descloizite", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 26, TextureSet.SET_QUARTZ, Arrays.asList(Materials.Lead, Materials.Copper, Materials.Vanadium), new Pair<Materials, Integer>(Materials.Lead, 1), new Pair<Materials, Integer>(Materials.Zinc, 1), new Pair<Materials, Integer>(Materials.Vanadium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        DescloiziteCUVO4 = new Werkstoff(new short[]{249, 109, 24, 0}, "Orange Descloizite", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 27, TextureSet.SET_QUARTZ, Arrays.asList(Materials.Lead, Materials.Zinc, Materials.Vanadium), new Pair<Materials, Integer>(Materials.Lead, 1), new Pair<Materials, Integer>(Materials.Copper, 1), new Pair<Materials, Integer>(Materials.Vanadium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        FuchsitAL = new Werkstoff(new short[]{77, 127, 100, 0}, "Green Fuchsite", BW_Util.subscriptNumbers("KAl3Si3O10(OH)2"), new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 28, TextureSet.SET_METALLIC, Arrays.asList(Materials.Potassium, Materials.Aluminiumoxide, Materials.SiliconDioxide), new Pair<Materials, Integer>(Materials.Potassium, 1), new Pair<Materials, Integer>(Materials.Aluminium, 3), new Pair<Materials, Integer>(Materials.Silicon, 3), new Pair<Materials, Integer>(Materials.Oxygen, 12), new Pair<Materials, Integer>(Materials.Hydrogen, 2));
        FuchsitCR = new Werkstoff(new short[]{128, 0, 0, 0}, "Red Fuchsite", BW_Util.subscriptNumbers("KCr3Si3O10(OH)2"), new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 29, TextureSet.SET_METALLIC, Arrays.asList(Materials.Potassium, Materials.Chrome, Materials.SiliconDioxide), new Pair<Materials, Integer>(Materials.Potassium, 1), new Pair<Materials, Integer>(Materials.Chrome, 3), new Pair<Materials, Integer>(Materials.Silicon, 3), new Pair<Materials, Integer>(Materials.Oxygen, 12), new Pair<Materials, Integer>(Materials.Hydrogen, 2));
        Thorium232 = new Werkstoff(new short[]{0, 64, 0, 0}, "Thorium 232", BW_Util.superscriptNumbers("Th232"), new Werkstoff.Stats().setRadioactive(true).setBlastFurnace(true).setMass(232L).setProtons(Element.Th.mProtons), Werkstoff.Types.ISOTOPE, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems().enforceUnification(), 30, TextureSet.SET_METALLIC, new Pair[0]);
        BismuthTellurite = new Werkstoff(new short[]{32, 72, 32, 0}, "Bismuth Tellurite", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addChemicalRecipes(), 31, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Bismuth, 2), new Pair<Materials, Integer>(Materials.Tellurium, 3));
        Tellurium = new Werkstoff(new short[]{255, 255, 255, 0}, "Tellurium", new Werkstoff.Stats(), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().addMetalItems().removePrefix(OrePrefixes.ore), 32, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Tellurium, 1));
        BismuthHydroBorat = new Werkstoff(new short[]{72, 144, 72, 0}, "Dibismuthhydroborat", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addChemicalRecipes(), 33, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Bismuth, 2), new Pair<Materials, Integer>(Materials.Boron, 1), new Pair<Materials, Integer>(Materials.Hydrogen, 1));
        ArInGaPhoBiBoTe = new Werkstoff(new short[]{36, 36, 36, 0}, "Circuit Compound MK3", new Werkstoff.Stats().setCentrifuge(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMixerRecipes(), 34, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.IndiumGalliumPhosphide, 1), new Pair<Werkstoff, Integer>(BismuthHydroBorat, 3), new Pair<Werkstoff, Integer>(BismuthTellurite, 2));
        Prasiolite = new Werkstoff(new short[]{208, 221, 149, 0}, "Prasiolite", new Werkstoff.Stats().setElektrolysis(false).setMeltingPoint(1923), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 35, TextureSet.SET_QUARTZ, new Pair<Materials, Integer>(Materials.Silicon, 5), new Pair<Materials, Integer>(Materials.Oxygen, 10), new Pair<Materials, Integer>(Materials.Iron, 1));
        MagnetoResonaticDust = new Werkstoff(new short[]{221, 119, 221, 0}, "Magneto Resonatic", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().onlyDust().addMixerRecipes().addGems(), 36, TextureSet.SET_MAGNETIC, new Pair<Werkstoff, Integer>(Prasiolite, 3), new Pair<Werkstoff, Integer>(BismuthTellurite, 4), new Pair<Werkstoff, Integer>(CubicZirconia, 1), new Pair<Materials, Integer>(Materials.SteelMagnetic, 1));
        Xenon = new Werkstoff(new short[]{20, 57, 127, 0}, "Xenon", "Xe", new Werkstoff.Stats().setProtons(54L).setMass(131L).setGas(true).setEbfGasRecipeTimeMultiplier(0.4).setEbfGasRecipeConsumedAmountMultiplier(0.25), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().addCells().enforceUnification(), 37, TextureSet.SET_FLUID, new Pair[0]);
        Oganesson = new Werkstoff(new short[]{20, 57, 127, 0}, "Oganesson", "Og", new Werkstoff.Stats().setProtons(118L).setMass(294L).setGas(true).setEbfGasRecipeTimeMultiplier(0.3).setEbfGasRecipeConsumedAmountMultiplier(0.1), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().addCells(), 38, TextureSet.SET_FLUID, new Pair[0]);
        Californium = new Werkstoff(new short[]{170, 170, 170, 0}, "Californium", "Cf", new Werkstoff.Stats().setProtons(98L).setMass(251L).setBlastFurnace(true).setMeltingPoint(900), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems().addMolten().enforceUnification(), 39, TextureSet.SET_METALLIC, new Pair[0]);
        Calcium = new Werkstoff(Materials.Calcium.mRGBa, "Calcium", "Ca", new Werkstoff.Stats().setProtons(Element.Ca.mProtons).setMass(Element.Ca.getMass()).setBlastFurnace(true).setMeltingPoint(1115).setBoilingPoint(1757), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems().addMolten(), 40, Materials.Calcium.mIconSet, new Pair<Materials, Integer>(Materials.Calcium, 1));
        Neon = new Werkstoff(new short[]{255, 7, 58}, "Neon", "Ne", new Werkstoff.Stats().setProtons(Element.Ne.mProtons).setMass(Element.Ne.getMass()).setGas(true).setEbfGasRecipeTimeMultiplier(0.6).setEbfGasRecipeConsumedAmountMultiplier(0.55), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().addCells().enforceUnification(), 41, TextureSet.SET_FLUID, new Pair[0]);
        Krypton = new Werkstoff(new short[]{177, 255, 50}, "Krypton", "Kr", new Werkstoff.Stats().setProtons(Element.Kr.mProtons).setMass(Element.Kr.getMass()).setGas(true).setEbfGasRecipeTimeMultiplier(0.5).setEbfGasRecipeConsumedAmountMultiplier(0.4), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().addCells().enforceUnification(), 42, TextureSet.SET_FLUID, new Pair[0]);
        BArTiMaEuSNeK = new Werkstoff(new short[]{0, 255, 0}, "BArTiMaEuSNeK", "Are you serious?", new Werkstoff.Stats().setMeltingPoint(9001).setCentrifuge(true).setBlastFurnace(true).setMeltingVoltage(1920), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems().addMetalItems().addMolten(), 43, TextureSet.SET_DIAMOND, Arrays.asList(Materials.Boron, Materials.Titanium, Materials.Europium), new Pair<Materials, Integer>(Materials.Boron, 1), new Pair<Materials, Integer>(Materials.Argon, 1), new Pair<Materials, Integer>(Materials.Titanium, 1), new Pair<Materials, Integer>(Materials.Magic, 1), new Pair<Materials, Integer>(Materials.Europium, 1), new Pair<Materials, Integer>(Materials.Sulfur, 1), new Pair<Werkstoff, Integer>(Neon, 1), new Pair<Materials, Integer>(Materials.Potassium, 1));
        PTConcentrate = new Werkstoff(Materials.Platinum.getRGBA(), "Platinum Concentrate", "", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 44, TextureSet.SET_FLUID, new Pair[0]);
        PTSaltCrude = new Werkstoff(Materials.Platinum.getRGBA(), "Platinum Salt", "", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 45, TextureSet.SET_DULL, new Pair[0]);
        PTSaltRefined = new Werkstoff(Materials.Platinum.getRGBA(), "Refined Platinum Salt", "", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 46, TextureSet.SET_METALLIC, new Pair[0]);
        PTMetallicPowder = new Werkstoff(Materials.Platinum.getRGBA(), "Platinum Metallic Powder", "??PtPdIrOsRhRu??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 47, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Platinum, 1), new Pair<Materials, Integer>(Materials.Stone, 2));
        AquaRegia = new Werkstoff(new short[]{255, 177, 50}, "Aqua Regia", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 48, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.DilutedSulfuricAcid, 1), new Pair<Materials, Integer>(Materials.NitricAcid, 1));
        PTResidue = new Werkstoff(new short[]{100, 99, 46}, "Platinum Residue", "??IrOsRhRu??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 49, TextureSet.SET_ROUGH, new Pair[0]);
        AmmoniumChloride = new Werkstoff(new short[]{255, 255, 255}, "Ammonium Chloride", BW_Util.subscriptNumbers("NH4Cl"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 50, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Ammonium, 1), new Pair<Materials, Integer>(Materials.HydrochloricAcid, 1));
        PTRawPowder = new Werkstoff(Materials.Platinum.getRGBA(), "Reprecipitated Platinum", "PtCl", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 51, TextureSet.SET_METALLIC, new Pair[0]);
        PDAmmonia = new Werkstoff(Materials.Palladium.getRGBA(), "Palladium Enriched Ammonia", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 52, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Ammonium, 1), new Pair<Materials, Integer>(Materials.Palladium, 1));
        PDMetallicPowder = new Werkstoff(Materials.Palladium.getRGBA(), "Palladium Metallic Powder", "??Pd??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 53, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Palladium, 1), new Pair<Materials, Integer>(Materials.Stone, 2));
        PDRawPowder = new Werkstoff(Materials.Palladium.getRGBA(), "Reprecipitated Palladium", BW_Util.subscriptNumbers("Pd2NH4"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 54, TextureSet.SET_METALLIC, new Pair[0]);
        PDSalt = new Werkstoff(Materials.Palladium.getRGBA(), "Palladium Salt", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 55, TextureSet.SET_METALLIC, new Pair[0]);
        Sodiumformate = new Werkstoff(new short[]{255, 170, 170}, "Sodium Formate", "HCOONa", new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 56, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.SodiumHydroxide, 1), new Pair<Materials, Integer>(Materials.CarbonMonoxide, 1));
        Sodiumsulfate = new Werkstoff(new short[]{255, 255, 255}, "Sodium Sulfate", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 57, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Sodium, 2), new Pair<Materials, Integer>(Materials.Sulfur, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        FormicAcid = new Werkstoff(new short[]{255, 170, 119}, "Formic Acid", BW_Util.subscriptNumbers("CH2O2"), new Werkstoff.Stats().setElektrolysis(false), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 58, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Carbon, 1), new Pair<Materials, Integer>(Materials.Hydrogen, 2), new Pair<Materials, Integer>(Materials.Oxygen, 2));
        PotassiumDisulfate = new Werkstoff(new short[]{251, 187, 102}, "Potassium Disulfate", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten().addChemicalRecipes(), 59, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Potassium, 2), new Pair<Materials, Integer>(Materials.Sulfur, 2), new Pair<Materials, Integer>(Materials.Oxygen, 7));
        LeachResidue = new Werkstoff(new short[]{100, 70, 41}, "Leach Residue", "??IrOsRu??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 60, TextureSet.SET_ROUGH, new Pair[0]);
        RHSulfate = new Werkstoff(new short[]{238, 170, 85}, "Rhodium Sulfate", new Werkstoff.Stats().setGas(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 61, TextureSet.SET_FLUID, new Pair[0]);
        RHSulfateSolution = new Werkstoff(new short[]{255, 187, 102}, "Rhodium Sulfate Solution", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 62, TextureSet.SET_FLUID, new Pair[0]);
        CalciumChloride = new Werkstoff(new short[]{255, 255, 255}, "Calcium Chloride", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addCells(), 63, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Calcium, 1), new Pair<Materials, Integer>(Materials.Chlorine, 2));
        Ruthenium = new Werkstoff(new short[]{100, 100, 100}, "Ruthenium", "Ru", new Werkstoff.Stats().setBlastFurnace(true).setMeltingPoint(2607).setMass(Element.Ru.getMass()).setProtons(Element.Ru.mProtons), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().onlyDust().addMolten().addMetalItems().enforceUnification(), 64, TextureSet.SET_METALLIC, new Pair[0]);
        SodiumRuthenate = new Werkstoff(new short[]{58, 64, 203}, "Sodium Ruthenate", new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 65, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.Sodium, 2), new Pair<Werkstoff, Integer>(Ruthenium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 3));
        RutheniumTetroxide = new Werkstoff(new short[]{199, 199, 199}, "Ruthenium Tetroxide", new Werkstoff.Stats().setMeltingPoint(313), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addCells(), 66, TextureSet.SET_DULL, new Pair<Werkstoff, Integer>(Ruthenium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        HotRutheniumTetroxideSollution = new Werkstoff(new short[]{199, 199, 199}, "Hot Ruthenium Tetroxide Solution", "???", new Werkstoff.Stats().setGas(true).setMeltingPoint(700), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 67, TextureSet.SET_FLUID, new Pair<Werkstoff, Integer>(Ruthenium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4), new Pair<Materials, Integer>(Materials.Chlorine, 2), new Pair<Materials, Integer>(Materials.Sodium, 2), new Pair<Materials, Integer>(Materials.Water, 2));
        RutheniumTetroxideSollution = new Werkstoff(new short[]{199, 199, 199}, "Ruthenium Tetroxide Solution", "???", new Werkstoff.Stats().setMeltingPoint(313), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 68, TextureSet.SET_FLUID, new Pair<Werkstoff, Integer>(Ruthenium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4), new Pair<Materials, Integer>(Materials.Chlorine, 2), new Pair<Materials, Integer>(Materials.Sodium, 2), new Pair<Materials, Integer>(Materials.Water, 2));
        IrOsLeachResidue = new Werkstoff(new short[]{100, 70, 41}, "Rarest Metal Residue", "??OsIr??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 69, TextureSet.SET_ROUGH, new Pair<Materials, Integer>(Materials.Osmiridium, 1), new Pair<Materials, Integer>(Materials.Stone, 2));
        IrLeachResidue = new Werkstoff(new short[]{132, 102, 73}, "Iridium Metal Residue", "??Ir??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 70, TextureSet.SET_ROUGH, new Pair<Materials, Integer>(Materials.Iridium, 1), new Pair<Materials, Integer>(Materials.Stone, 2));
        PGSDResidue = new Werkstoff(new short[]{132, 102, 73}, "Sludge Dust Residue", new Werkstoff.Stats().setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 71, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.SiliconDioxide, 3), new Pair<Materials, Integer>(Materials.Gold, 2));
        AcidicOsmiumSolution = new Werkstoff(new short[]{132, 102, 73}, "Acidic Osmium Solution", "???", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 72, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Osmium, 1), new Pair<Materials, Integer>(Materials.HydrochloricAcid, 1));
        IridiumDioxide = new Werkstoff(new short[]{132, 102, 73}, "Iridium Dioxide", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 73, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Iridium, 1), new Pair<Materials, Integer>(Materials.Oxygen, 2));
        OsmiumSolution = new Werkstoff(new short[]{132, 102, 73}, "Osmium Solution", "???", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 74, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Osmium, 1), new Pair<Materials, Integer>(Materials.Hydrogen, 1));
        AcidicIridiumSolution = new Werkstoff(new short[]{132, 102, 73}, "Acidic Iridium Solution", "???", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 75, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Iridium, 1), new Pair<Materials, Integer>(Materials.Hydrogen, 1));
        IridiumChloride = new Werkstoff(new short[]{132, 102, 73}, "Iridium Chloride", BW_Util.subscriptNumbers("IrCl3"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 76, TextureSet.SET_LAPIS, new Pair<Materials, Integer>(Materials.Iridium, 1), new Pair<Materials, Integer>(Materials.Chlorine, 3));
        PGSDResidue2 = new Werkstoff(new short[]{132, 102, 73}, "Metallic Sludge Dust Residue", new Werkstoff.Stats().setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 77, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Nickel, 1), new Pair<Materials, Integer>(Materials.Copper, 1));
        Rhodium = new Werkstoff(new short[]{244, 244, 244}, "Rhodium", "Rh", new Werkstoff.Stats().setProtons(Element.Rh.mProtons).setMass(Element.Rh.getMass()).setBlastFurnace(true).setMeltingPoint(2237), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems().addMolten().enforceUnification(), 78, TextureSet.SET_METALLIC, new Pair[0]);
        CrudeRhMetall = new Werkstoff(new short[]{102, 102, 102}, "Crude Rhodium Metal", "??Rh??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures(), 79, TextureSet.SET_DULL, new Pair<Werkstoff, Integer>(Rhodium, 1), new Pair<Materials, Integer>(Materials.Stone, 1));
        RHSalt = new Werkstoff(new short[]{132, 132, 132}, "Rhodium Salt", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 80, TextureSet.SET_GEM_VERTICAL, new Pair[0]);
        RHSaltSolution = new Werkstoff(new short[]{102, 119, 136}, "Rhodium Salt Solution", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 81, TextureSet.SET_FLUID, new Pair[0]);
        SodiumNitrate = new Werkstoff(new short[]{132, 102, 132}, "Sodium Nitrate", BW_Util.subscriptNumbers("NaNO3"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 82, TextureSet.SET_ROUGH, new Pair<Materials, Integer>(Materials.Sodium, 1), new Pair<Materials, Integer>(Materials.Nitrogen, 1), new Pair<Materials, Integer>(Materials.Oxygen, 3));
        RHNitrate = new Werkstoff(new short[]{119, 102, 73}, "Rhodium Nitrate", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 83, TextureSet.SET_QUARTZ, new Pair[0]);
        ZincSulfate = new Werkstoff(new short[]{132, 102, 73}, "Zinc Sulfate", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 84, TextureSet.SET_QUARTZ, new Pair<Materials, Integer>(Materials.Zinc, 1), new Pair<Materials, Integer>(Materials.Sulfur, 1), new Pair<Materials, Integer>(Materials.Oxygen, 4));
        RhFilterCake = new Werkstoff(new short[]{119, 102, 73}, "Rhodium Filter Cake", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 85, TextureSet.SET_QUARTZ, new Pair[0]);
        RHFilterCakeSolution = new Werkstoff(new short[]{102, 119, 136}, "Rhodium Filter Cake Solution", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 86, TextureSet.SET_FLUID, new Pair[0]);
        ReRh = new Werkstoff(new short[]{119, 102, 73}, "Reprecipitated Rhodium", BW_Util.subscriptNumbers("Rh2NH4"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 87, TextureSet.SET_QUARTZ, new Pair[0]);
        LuVTierMaterial = new Werkstoff(Materials.Chrome.getRGBA(), "Rhodium-Plated Palladium", new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(4500).setMeltingVoltage(480), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten().addMetalItems().addMixerRecipes((short)1).addSimpleMetalWorkingItems().addCraftingMetalWorkingItems().addMultipleIngotMetalWorkingItems(), 88, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Palladium, 3), new Pair<Werkstoff, Integer>(Rhodium, 1));
        Tiberium = new Werkstoff(new short[]{34, 238, 34}, "Tiberium", "Tr", new Werkstoff.Stats().setProtons(123L).setMass(326L).setBlastFurnace(true).setMeltingPoint(1800).setRadioactive(true).setToxic(true), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().addGems().addCraftingMetalWorkingItems().addSimpleMetalWorkingItems(), 89, TextureSet.SET_DIAMOND, new Pair[0]);
        Ruridit = new Werkstoff(new short[]{164, 164, 164}, "Ruridit", new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(4500).setMeltingVoltage(480), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten().addMetalItems().addMixerRecipes((short)1).addSimpleMetalWorkingItems().addCraftingMetalWorkingItems().addMultipleIngotMetalWorkingItems(), 90, TextureSet.SET_METALLIC, new Pair<Werkstoff, Integer>(Ruthenium, 2), new Pair<Materials, Integer>(Materials.Iridium, 1));
        Fluorspar = new Werkstoff(new short[]{185, 69, 251}, "Fluorspar", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().addGems(), 91, TextureSet.SET_GEM_VERTICAL, new Pair<Materials, Integer>(Materials.Calcium, 1), new Pair<Materials, Integer>(Materials.Fluorine, 2));
        HDCS = new Werkstoff(new short[]{51, 68, 51}, "High Durability Compound Steel", new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setMeltingPoint(9000).setMeltingVoltage(7680), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten().addMetalItems().addMixerRecipes().addSimpleMetalWorkingItems().addCraftingMetalWorkingItems().addMultipleIngotMetalWorkingItems(), 92, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.TungstenSteel, 12), new Pair<Materials, Integer>(Materials.HSSE, 9), new Pair<Materials, Integer>(Materials.HSSG, 6), new Pair<Werkstoff, Integer>(Ruridit, 3), new Pair<Werkstoff, Integer>(MagnetoResonaticDust, 2), new Pair<Materials, Integer>(Materials.Plutonium, 1));
        Atheneite = new Werkstoff(new short[]{175, 175, 175}, "Atheneite", BW_Util.subscriptNumbers("(Pd,Hg)3As"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 93, TextureSet.SET_SHINY, new Pair<Werkstoff, Integer>(PDMetallicPowder, 3), new Pair<Materials, Integer>(Materials.Mercury, 3), new Pair<Materials, Integer>(Materials.Arsenic, 1));
        Temagamite = new Werkstoff(new short[]{245, 245, 245}, "Temagamite", BW_Util.subscriptNumbers("Pd3HgTe"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 94, TextureSet.SET_ROUGH, new Pair<Werkstoff, Integer>(PDMetallicPowder, 3), new Pair<Materials, Integer>(Materials.Mercury, 1), new Pair<Materials, Integer>(Materials.Tellurium, 1));
        Terlinguaite = new Werkstoff(new short[]{245, 245, 245}, "Terlinguaite", new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures(), 95, TextureSet.SET_GEM_HORIZONTAL, new Pair<Materials, Integer>(Materials.Mercury, 2), new Pair<Materials, Integer>(Materials.Chlorine, 1), new Pair<Materials, Integer>(Materials.Oxygen, 1));
        AdemicSteel = new Werkstoff(new short[]{204, 204, 204}, "Ademic Steel", "The break in the line", new Werkstoff.Stats().setCentrifuge(true).setBlastFurnace(true).setDurOverride(6144).setMeltingPoint(1800).setSpeedOverride(12.0f).setQualityOverride((byte)4).setMeltingVoltage(1920), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMetalItems().addCraftingMetalWorkingItems().addMolten().addSimpleMetalWorkingItems().addMultipleIngotMetalWorkingItems(), 96, TextureSet.SET_METALLIC, new Pair<Materials, Integer>(Materials.Steel, 2), new Pair<Materials, Integer>(Materials.VanadiumSteel, 1), new Pair<Materials, Integer>(Materials.DamascusSteel, 1), new Pair<Materials, Integer>(Materials.Carbon, 4));
        RawAdemicSteel = new Werkstoff(new short[]{237, 237, 237}, "Raw Ademic Steel", new Werkstoff.Stats().setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().onlyDust().addMixerRecipes(), 97, TextureSet.SET_ROUGH, new Pair<Materials, Integer>(Materials.Steel, 2), new Pair<Materials, Integer>(Materials.VanadiumSteel, 1), new Pair<Materials, Integer>(Materials.DamascusSteel, 1));
        HexafluorosilicicAcid = new Werkstoff(new short[]{44, 112, 181}, "Hexafluorosilicic Acid", BW_Util.subscriptNumbers("H2SiF6"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 98, TextureSet.SET_FLUID, new Pair<Materials, Integer>(Materials.Hydrogen, 2), new Pair<Materials, Integer>(Materials.Silicon, 1), new Pair<Materials, Integer>(Materials.Fluorine, 6));
        Potassiumfluorosilicate = new Werkstoff(new short[]{46, 151, 178}, "Potassiumfluorosilicate", BW_Util.subscriptNumbers("K2SiF6"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 99, TextureSet.SET_SHINY, new Pair<Materials, Integer>(Materials.Potassium, 2), new Pair<Materials, Integer>(Materials.Silicon, 1), new Pair<Materials, Integer>(Materials.Fluorine, 6));
        Alumina = new Werkstoff(new short[]{160, 173, 177}, "Alumina", BW_Util.subscriptNumbers("Al2O3"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 100, TextureSet.SET_DULL, new Pair[0]);
        PotassiumCarbonate = new Werkstoff(new short[]{123, 150, 79}, "Potassium Carbonate", BW_Util.subscriptNumbers("K2CO3"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 101, TextureSet.SET_DULL, new Pair<Materials, Integer>(Materials.Potassium, 2), new Pair<Materials, Integer>(Materials.Carbon, 1), new Pair<Materials, Integer>(Materials.Oxygen, 3));
        RawFluorophlogopite = new Werkstoff(new short[]{54, 81, 11}, "Raw Fluorophlogopite", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 102, TextureSet.SET_DULL, new Pair[0]);
        HotFluorophlogopite = new Werkstoff(new short[]{191, 211, 85}, "Unformed Fluorophlogopite", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 103, TextureSet.SET_FLUID, new Pair[0]);
        Fluorophlogopite = new Werkstoff(new short[]{191, 211, 85}, "Fluorophlogopite", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems(), 104, TextureSet.SET_SHINY, new Pair[0]);
        items = new HashMap();
        fluids = HashBiMap.create();
        molten = HashBiMap.create();
        ENABLED_ORE_PREFIXES = new HashSet();
    }
}

