/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.island;

import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.island.biome.feature.AbstractIslandStructure;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class StructureObsidianRoad
extends AbstractIslandStructure {
    private static final Block roadBlock = Blocks.field_150343_Z;

    @Override
    protected boolean generate(Random rand) {
        int x = this.getRandomXZ(rand, 8);
        int z = this.getRandomXZ(rand, 8);
        int nearbyRoad = 0;
        for (int a = 0; a < 32; ++a) {
            int zz;
            int xx = x + rand.nextInt(5) - rand.nextInt(5);
            if (this.world.getBlock(xx, this.world.getHighestY(xx, zz = z + rand.nextInt(5) - rand.nextInt(5)), zz) != roadBlock) continue;
            ++nearbyRoad;
        }
        if (nearbyRoad > 2 || !this.tryPlaceRoadAt(x, z)) {
            return false;
        }
        this.generateRoad(rand, x, z, rand.nextDouble() * 2.0 * Math.PI, 0);
        return true;
    }

    private void generateRoad(Random rand, double x, double z, double dir, int level) {
        if (level >= 3) {
            return;
        }
        int dirChange = level > 0 ? 0 : rand.nextInt(5) - 2;
        int dirChangeFrequency = 14 + level + rand.nextInt(6);
        int branchAmount = 0;
        int max = 270 - 30 * level + rand.nextInt(50);
        for (int a = 0; a < max; ++a) {
            if (dirChange != 0) {
                dir += MathUtil.toRad(3.0 + 2.0 * rand.nextDouble() * (double)dirChange);
            }
            if (!this.tryPlaceRoadAt((int)(x += Math.cos(dir) * 1.49), (int)(z += Math.sin(dir) * 1.49))) break;
            if (rand.nextInt(dirChange != 0 ? dirChangeFrequency : dirChangeFrequency - 8) == 0) {
                dirChange = rand.nextInt(4) == 0 ? 0 : (dirChange == -2 ? (rand.nextInt(6) == 0 ? 2 : -1) : (dirChange == 2 ? (rand.nextInt(6) == 0 ? -2 : 1) : (dirChange += rand.nextBoolean() ? -1 : 1)));
            }
            if (rand.nextInt(28 + 4 * level) != 0 || ++branchAmount >= 4) continue;
            this.generateRoad(rand, x, z, dir + MathUtil.toRad((rand.nextBoolean() ? 90.0 : -90.0) + (rand.nextDouble() - 0.5) * 32.0), level + 1);
        }
    }

    private boolean tryPlaceRoadAt(int topLeftX, int topLeftZ) {
        boolean shouldContinue = true;
        for (int px = 0; px < 2; ++px) {
            for (int pz = 0; pz < 2; ++pz) {
                int yy = this.world.getHighestY(topLeftX + px, topLeftZ + pz);
                Block block = this.world.getBlock(topLeftX + px, yy, topLeftZ + pz);
                if (block == this.surface()) {
                    this.world.setBlock(topLeftX + px, yy, topLeftZ + pz, roadBlock);
                    continue;
                }
                if (block == roadBlock) continue;
                shouldContinue = false;
            }
        }
        return shouldContinue;
    }
}

