/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe.stackinfo;

import codechicken.nei.api.IStackStringifyHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Method;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GTFluidStackStringifyHandler
implements IStackStringifyHandler {
    protected static Class<?> GTDisplayFluid = null;
    protected static Method getFluidDisplayStack = null;
    protected static Method getFluidFromDisplayStack = null;
    public static boolean replaceAE2FCFluidDrop = false;

    @Override
    public NBTTagCompound convertItemStackToNBT(ItemStack stack, boolean saveStackSize) {
        FluidStack fluidStack;
        if ((replaceAE2FCFluidDrop || stack.func_77973_b() != GameRegistry.findItem((String)"ae2fc", (String)"fluid_drop")) && (fluidStack = this.getFluid(stack)) != null) {
            NBTTagCompound nbTag = new NBTTagCompound();
            nbTag.func_74778_a("gtFluidName", fluidStack.getFluid().getName());
            nbTag.func_74768_a("Count", saveStackSize ? fluidStack.amount : 144);
            return nbTag;
        }
        return null;
    }

    @Override
    public ItemStack convertNBTToItemStack(NBTTagCompound nbtTag) {
        if (getFluidDisplayStack != null && nbtTag.func_74764_b("gtFluidName")) {
            String fluidName = nbtTag.func_74779_i("gtFluidName");
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            int amount = nbtTag.func_74762_e("Count");
            try {
                Object obj = getFluidDisplayStack.invoke(null, new FluidStack(fluid, amount), true);
                if (obj != null) {
                    return (ItemStack)obj;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public FluidStack getFluid(ItemStack stack) {
        Item item = stack.func_77973_b();
        try {
            if (getFluidFromDisplayStack != null && GTDisplayFluid != null && GTDisplayFluid.isInstance(item)) {
                Object obj = getFluidFromDisplayStack.invoke(null, stack);
                if (obj != null) {
                    return (FluidStack)obj;
                }
            } else {
                NBTTagCompound nbtTag;
                Fluid fluid;
                if (item == GameRegistry.findItem((String)"ae2fc", (String)"fluid_packet")) {
                    NBTTagCompound nbtTag2 = stack.func_77978_p();
                    return FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)nbtTag2.func_74781_a("FluidStack")));
                }
                if (item == GameRegistry.findItem((String)"ae2fc", (String)"fluid_drop") && (fluid = FluidRegistry.getFluid((String)(nbtTag = stack.func_77978_p()).func_74779_i("Fluid").toLowerCase())) != null) {
                    FluidStack fluidStack = new FluidStack(fluid, stack.field_77994_a);
                    if (nbtTag.func_74764_b("FluidTag")) {
                        fluidStack.tag = nbtTag.func_74775_l("FluidTag");
                    }
                    return fluidStack;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        try {
            Class<?> gtUtility = Class.forName("gregtech.api.util.GT_Utility");
            GTDisplayFluid = Class.forName("gregtech.common.items.GT_FluidDisplayItem");
            getFluidFromDisplayStack = gtUtility.getMethod("getFluidFromDisplayStack", ItemStack.class);
            getFluidDisplayStack = gtUtility.getMethod("getFluidDisplayStack", FluidStack.class, Boolean.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

