/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.nei.BookmarkContainerInfo;
import codechicken.nei.ItemList;
import codechicken.nei.ItemSorter;
import codechicken.nei.ItemStackSet;
import codechicken.nei.KeyManager;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.OffsetPositioner;
import codechicken.nei.SearchField;
import codechicken.nei.SubsetWidget;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IBookmarkContainerHandler;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.INEIModeHandler;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeFilter;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.api.IStackStringifyHandler;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.api.LayoutStyle;
import codechicken.nei.api.NEIInfo;
import codechicken.nei.config.Option;
import codechicken.nei.config.OptionKeyBind;
import codechicken.nei.recipe.CatalystInfo;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.StackInfo;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class API {
    public static void registerRecipeHandler(ICraftingHandler handler) {
        GuiCraftingRecipe.registerRecipeHandler(handler);
    }

    public static void registerUsageHandler(IUsageHandler handler) {
        GuiUsageRecipe.registerUsageHandler(handler);
    }

    public static void registerGuiOverlay(Class<? extends GuiContainer> classz, String ident) {
        API.registerGuiOverlay(classz, ident, 5, 11);
    }

    public static void registerGuiOverlay(Class<? extends GuiContainer> classz, String ident, int x, int y) {
        API.registerGuiOverlay(classz, ident, new OffsetPositioner(x, y));
    }

    public static void registerGuiOverlay(Class<? extends GuiContainer> classz, String ident, IStackPositioner positioner) {
        RecipeInfo.registerGuiOverlay(classz, ident, positioner);
    }

    public static void registerGuiOverlayHandler(Class<? extends GuiContainer> classz, IOverlayHandler handler, String ident) {
        RecipeInfo.registerOverlayHandler(classz, handler, ident);
    }

    public static boolean hasGuiOverlayHandler(Class<? extends GuiContainer> classz, String ident) {
        return RecipeInfo.hasOverlayHandler(classz, ident);
    }

    public static void setGuiOffset(Class<? extends GuiContainer> classz, int x, int y) {
        RecipeInfo.setGuiOffset(classz, x, y);
    }

    public static void registerNEIGuiHandler(INEIGuiHandler handler) {
        try {
            GuiInfo.writeLock.lock();
            GuiInfo.guiHandlers.add(handler);
        }
        finally {
            GuiInfo.writeLock.unlock();
        }
    }

    public static void hideItem(ItemStack item) {
        if (!ItemInfo.hiddenItems.contains(item)) {
            ItemInfo.hiddenItems.add(item);
            LayoutManager.markItemsDirty();
        }
    }

    public static void setOverrideName(ItemStack item, String name) {
        if (!name.equals(ItemInfo.nameOverrides.get(item))) {
            ItemInfo.nameOverrides.put(item, name);
            LayoutManager.markItemsDirty();
        }
    }

    public static void addItemListEntry(ItemStack item) {
        if (!ItemInfo.itemOverrides.containsEntry((Object)item.func_77973_b(), (Object)item)) {
            ItemInfo.itemOverrides.put((Object)item.func_77973_b(), (Object)item);
            LayoutManager.markItemsDirty();
        }
    }

    public static void setItemListEntries(Item item, Iterable<ItemStack> items) {
        if (items == null) {
            items = Collections.emptyList();
        }
        if (!Sets.newHashSet(items).equals(Sets.newHashSet((Iterable)ItemInfo.itemOverrides.get((Object)item)))) {
            ItemInfo.itemOverrides.replaceValues((Object)item, items);
            LayoutManager.markItemsDirty();
        }
    }

    public static void addKeyBind(String ident, int defaultKey) {
        NEIClientConfig.setDefaultKeyBinding(ident, defaultKey);
        KeyManager.keyStates.put(ident, new KeyManager.KeyState());
        API.addOption(new OptionKeyBind(ident));
    }

    public static void addHashBind(String ident, int defaultKey) {
        NEIClientConfig.setDefaultKeyBinding(ident, defaultKey);
        API.addOption(new OptionKeyBind(ident, true));
    }

    public static void addOption(Option option) {
        NEIClientConfig.getOptionList().addOption(option);
    }

    public static void addLayoutStyle(int styleID, LayoutStyle style) {
        LayoutManager.layoutStyles.put(styleID, style);
    }

    public static void addInfiniteItemHandler(IInfiniteItemHandler handler) {
        ItemInfo.infiniteHandlers.addFirst(handler);
    }

    public static void registerHighlightIdentifier(Block block, IHighlightHandler handler) {
        ItemInfo.highlightIdentifiers.put((Object)block, (Object)handler);
    }

    public static void addFastTransferExemptSlot(Class<? extends Slot> slotClass) {
        ItemInfo.fastTransferExemptions.add(slotClass);
    }

    public static void registerHighlightHandler(IHighlightHandler handler, ItemInfo.Layout ... layout) {
        ItemInfo.registerHighlightHandler(handler, layout);
    }

    public static void registerModeHandler(INEIModeHandler handler) {
        NEIInfo.modeHandlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRecipeFilter(IRecipeFilter.IRecipeFilterProvider filterProvider) {
        List<IRecipeFilter.IRecipeFilterProvider> list = GuiRecipe.recipeFilterers;
        synchronized (list) {
            GuiRecipe.recipeFilterers.add(filterProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addItemFilter(ItemFilter.ItemFilterProvider filterProvider) {
        List<ItemFilter.ItemFilterProvider> list = ItemList.itemFilterers;
        synchronized (list) {
            ItemList.itemFilterers.add(filterProvider);
        }
    }

    public static void addSubset(String name, ItemFilter filter) {
        API.addSubset(new SubsetWidget.SubsetTag(name, filter));
    }

    public static void addSubset(String name, Iterable<ItemStack> items) {
        ItemStackSet filter = new ItemStackSet();
        for (ItemStack item : items) {
            filter.add(item);
        }
        API.addSubset(new SubsetWidget.SubsetTag(name, filter));
    }

    public static void addSubset(SubsetWidget.SubsetTag tag) {
        SubsetWidget.addTag(tag);
    }

    public static void addSearchProvider(SearchField.ISearchProvider provider) {
        SearchField.searchProviders.add(provider);
    }

    public static void addSortOption(String name, Comparator<ItemStack> comparator) {
        ItemSorter.add(name, comparator);
    }

    public static void addItemVariant(Item item, ItemStack variant) {
        if (!ItemInfo.itemVariants.containsEntry((Object)item, (Object)variant)) {
            ItemInfo.itemVariants.put((Object)item, (Object)variant);
            LayoutManager.markItemsDirty();
        }
    }

    public static void registerStackStringifyHandler(IStackStringifyHandler handler) {
        StackInfo.stackStringifyHandlers.add(handler);
    }

    public static void addRecipeCatalyst(ItemStack stack, IRecipeHandler handler, int priority) {
        String handlerID = RecipeCatalysts.getRecipeID(handler);
        API.addRecipeCatalyst(stack, handlerID, priority);
    }

    public static void addRecipeCatalyst(ItemStack stack, IRecipeHandler handler) {
        API.addRecipeCatalyst(stack, handler, 0);
    }

    public static void addRecipeCatalyst(ItemStack stack, String handlerID, int priority) {
        RecipeCatalysts.addRecipeCatalyst(handlerID, new CatalystInfo(stack, priority));
    }

    public static void addRecipeCatalyst(ItemStack stack, String handlerID) {
        API.addRecipeCatalyst(stack, handlerID, 0);
    }

    public static void removeRecipeCatalyst(ItemStack stack, IRecipeHandler handler) {
        String handlerID = RecipeCatalysts.getRecipeID(handler);
        API.removeRecipeCatalyst(stack, handlerID);
    }

    public static void removeRecipeCatalyst(ItemStack stack, String handlerID) {
        RecipeCatalysts.removeRecipeCatalyst(handlerID, stack);
    }

    public static void registerBookmarkContainerHandler(Class<? extends GuiContainer> gui, IBookmarkContainerHandler handler) {
        BookmarkContainerInfo.registerBookmarkContainerHandler(gui, handler);
    }

    @Deprecated
    public static void addRecipeCatalyst(List<ItemStack> stacks, IRecipeHandler handler) {
        for (ItemStack stack : stacks) {
            API.addRecipeCatalyst(stack, handler);
        }
    }

    @Deprecated
    public static void addRecipeCatalyst(List<ItemStack> stacks, String handlerID) {
        for (ItemStack stack : stacks) {
            API.addRecipeCatalyst(stack, handlerID);
        }
    }

    @Deprecated
    public static void addRecipeCatalyst(ItemStack stack, Class<? extends IRecipeHandler> handler) {
    }

    @Deprecated
    public static void addRecipeCatalyst(List<ItemStack> stacks, Class<? extends IRecipeHandler> handler) {
    }
}

