/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.ItemHistoryPanel;
import codechicken.nei.ItemList;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.ItemsGrid;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PanelWidget;
import codechicken.nei.PresetsWidget;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class ItemPanel
extends PanelWidget {
    @Deprecated
    private int itemsPerPage = 0;
    @Deprecated
    public static ArrayList<ItemStack> items = new ArrayList();
    @Deprecated
    public ArrayList<ItemStack> realItems = new ArrayList();
    public Button more;
    public Button less;
    public ItemQuantityField quantity;
    public ItemHistoryPanel historyPanel;

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        return super.getStackMouseOver(mousex, mousey);
    }

    public ItemPanel() {
        this.grid = new ItemPanelGrid();
    }

    public static void updateItemList(ArrayList<ItemStack> newItems) {
        ((ItemPanelGrid)ItemPanels.itemPanel.getGrid()).setItems(newItems);
        ItemPanels.itemPanel.realItems = newItems;
    }

    @Override
    public void init() {
        super.init();
        this.more = new Button("+"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                int modifier = NEIClientUtils.controlKey() ? 64 : (NEIClientUtils.shiftKey() ? 10 : 1);
                int quantity = NEIClientConfig.getItemQuantity() + modifier;
                if (quantity < 0) {
                    quantity = 0;
                }
                ItemPanels.itemPanel.quantity.setText(Integer.toString(quantity));
                return true;
            }
        };
        this.less = new Button("-"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                int modifier = NEIClientUtils.controlKey() ? -64 : (NEIClientUtils.shiftKey() ? -10 : -1);
                int quantity = NEIClientConfig.getItemQuantity() + modifier;
                if (quantity < 0) {
                    quantity = 0;
                }
                ItemPanels.itemPanel.quantity.setText(Integer.toString(quantity));
                return true;
            }
        };
        this.quantity = new ItemQuantityField("quantity");
        this.historyPanel = new ItemHistoryPanel();
    }

    @Deprecated
    public void scroll(int i) {
        this.grid.shiftPage(i);
    }

    @Override
    public String getLabelText() {
        return String.format("%d/%d", this.getPage(), Math.max(1, this.getNumPages()));
    }

    @Override
    protected String getPositioningSettingName() {
        return "world.panels.items";
    }

    @Override
    public int getMarginLeft(GuiContainer gui) {
        return (gui.field_146294_l + gui.field_146999_f) / 2 + 2;
    }

    @Override
    public int getMarginTop(GuiContainer gui) {
        return 2;
    }

    @Override
    public int getWidth(GuiContainer gui) {
        return gui.field_146294_l - (gui.field_146999_f + gui.field_146294_l) / 2 - 4;
    }

    @Override
    public int getHeight(GuiContainer gui) {
        return gui.field_146295_m - this.getMarginTop(gui) - 2;
    }

    @Override
    protected int resizeFooter(GuiContainer gui) {
        if (!NEIClientConfig.showItemQuantityWidget() && NEIClientConfig.isSearchWidgetCentered() && !NEIClientConfig.showHistoryPanelWidget()) {
            return 0;
        }
        int BUTTON_SIZE = 20;
        this.less.w = 20;
        this.more.w = 20;
        this.quantity.h = 20;
        if (NEIClientConfig.isSearchWidgetCentered()) {
            this.less.h = 20;
            this.more.h = 20;
            this.more.x = this.x + this.w - 20;
            this.less.y = this.quantity.y = this.y + this.h - 20;
            this.more.y = this.quantity.y;
            this.less.x = this.x;
            this.quantity.x = this.x + 20 + 2;
            this.quantity.w = this.more.x - this.quantity.x - 2;
        } else {
            this.quantity.x = (int)((double)this.x + (double)this.w * 0.7) + 3;
            this.quantity.y = this.y + this.h - 20;
            this.quantity.w = (int)((double)this.w * 0.3 - 20.0 - 1.0);
            this.less.h = 10;
            this.more.h = 10;
            this.more.y = this.y + this.h - this.more.h * 2;
            this.less.x = this.more.x = this.quantity.x + this.quantity.w;
            this.less.y = this.more.y + this.more.h;
        }
        if (NEIClientConfig.showHistoryPanelWidget()) {
            this.historyPanel.x = this.x;
            this.historyPanel.w = this.w;
            this.historyPanel.h = 18 * NEIClientConfig.getIntSetting("inventory.history.useRows");
            if (NEIClientConfig.showItemQuantityWidget() || !NEIClientConfig.isSearchWidgetCentered()) {
                this.historyPanel.y = this.quantity.y - this.historyPanel.h - 2;
                return this.quantity.h + this.historyPanel.h + 4;
            }
            this.historyPanel.y = this.y + this.h - this.historyPanel.h;
            return this.historyPanel.h + 2;
        }
        return this.quantity.h + 2;
    }

    @Override
    public void setVisible() {
        super.setVisible();
        if (this.grid.getPerPage() > 0) {
            if (NEIClientConfig.showItemQuantityWidget()) {
                LayoutManager.addWidget(this.more);
                LayoutManager.addWidget(this.less);
                LayoutManager.addWidget(this.quantity);
            }
            if (NEIClientConfig.showHistoryPanelWidget()) {
                LayoutManager.addWidget(this.historyPanel);
            }
        }
    }

    @Override
    public void resize(GuiContainer gui) {
        super.resize(gui);
        this.historyPanel.resize(gui);
    }

    @Override
    protected ItemStack getDraggedStackWithQuantity(int mouseDownSlot) {
        ItemStack stack = this.grid.getItem(mouseDownSlot);
        if (stack != null) {
            int amount;
            int n = amount = NEIClientConfig.showItemQuantityWidget() ? NEIClientConfig.getItemQuantity() : 0;
            if (amount == 0) {
                amount = stack.func_77976_d();
            }
            return NEIServerUtils.copyStack(stack, amount);
        }
        return null;
    }

    protected static class ItemPanelGrid
    extends ItemsGrid {
        public ArrayList<ItemStack> newItems;

        protected ItemPanelGrid() {
        }

        public void setItems(ArrayList<ItemStack> items) {
            this.newItems = items;
        }

        @Override
        public void refresh(GuiContainer gui) {
            if (this.newItems != null) {
                this.realItems = this.newItems;
                this.newItems = null;
                this.onItemsChanged();
            }
            super.refresh(gui);
        }

        @Override
        protected void beforeDrawSlot(@Nullable ItemPanelSlot focused, int slotIdx, Rectangle4i rect) {
            if (PresetsWidget.inEditMode()) {
                if (!PresetsWidget.isHidden(this.getItem(slotIdx))) {
                    GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
                }
            } else {
                super.beforeDrawSlot(focused, slotIdx, rect);
            }
        }

        @Override
        public String getMessageOnEmpty() {
            return ItemList.loadFinished ? null : NEIClientUtils.translate("itempanel.loading", new Object[0]);
        }
    }

    public static class ItemPanelSlot {
        public ItemStack item;
        public int slotIndex;

        public ItemPanelSlot(int idx, ItemStack stack) {
            this.slotIndex = idx;
            this.item = stack;
        }

        @Deprecated
        public ItemPanelSlot(int idx) {
            this(idx, ItemPanels.itemPanel.getGrid().getItem(idx));
        }
    }
}

