/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.utils;

import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.function.UnaryOperator;
import speiger.src.collections.objects.utils.ObjectCollections;
import speiger.src.collections.objects.utils.ObjectIterators;
import speiger.src.collections.utils.ISizeProvider;

public class ObjectIterables {
    public static <T, E> ObjectIterable<E> map(Iterable<? extends T> iterable, UnaryOperator<T, E> mapper) {
        return new MappedIterable<T, E>(ObjectIterables.wrap(iterable), mapper);
    }

    public static <T, E> ObjectIterable<E> map(ObjectIterable<T> iterable, UnaryOperator<T, E> mapper) {
        return new MappedIterable<T, E>(iterable, mapper);
    }

    public static <T, E, V extends Iterable<E>> ObjectIterable<E> flatMap(Iterable<? extends T> iterable, UnaryOperator<T, V> mapper) {
        return new FlatMappedIterable(ObjectIterables.wrap(iterable), mapper);
    }

    public static <T, E, V extends Iterable<E>> ObjectIterable<E> flatMap(ObjectIterable<T> iterable, UnaryOperator<T, V> mapper) {
        return new FlatMappedIterable(iterable, mapper);
    }

    public static <T, E> ObjectIterable<E> arrayFlatMap(Iterable<? extends T> iterable, UnaryOperator<T, E[]> mapper) {
        return new FlatMappedArrayIterable(ObjectIterables.wrap(iterable), mapper);
    }

    public static <T, E> ObjectIterable<E> arrayFlatMap(ObjectIterable<T> iterable, UnaryOperator<T, E[]> mapper) {
        return new FlatMappedArrayIterable(iterable, mapper);
    }

    public static <T> ObjectIterable<T> filter(Iterable<? extends T> iterable, Predicate<T> filter) {
        return new FilteredIterable<T>(ObjectIterables.wrap(iterable), filter);
    }

    public static <T> ObjectIterable<T> filter(ObjectIterable<T> iterable, Predicate<T> filter) {
        return new FilteredIterable<T>(iterable, filter);
    }

    public static <T> ObjectIterable<T> distinct(ObjectIterable<T> iterable) {
        return new DistinctIterable<T>(iterable);
    }

    public static <T> ObjectIterable<T> distinct(Iterable<? extends T> iterable) {
        return new DistinctIterable<T>(ObjectIterables.wrap(iterable));
    }

    public static <T> ObjectIterable<T> repeat(ObjectIterable<T> iterable, int repeats) {
        return new RepeatingIterable<T>(iterable, repeats);
    }

    public static <T> ObjectIterable<T> repeat(Iterable<? extends T> iterable, int repeats) {
        return new RepeatingIterable<T>(ObjectIterables.wrap(iterable), repeats);
    }

    public static <T> ObjectIterable<T> limit(ObjectIterable<T> iterable, long limit) {
        return new LimitedIterable<T>(iterable, limit);
    }

    public static <T> ObjectIterable<T> limit(Iterable<? extends T> iterable, long limit) {
        return new LimitedIterable<T>(ObjectIterables.wrap(iterable), limit);
    }

    public static <T> ObjectIterable<T> sorted(ObjectIterable<T> iterable, Comparator<T> sorter) {
        return new SortedIterable<T>(iterable, sorter);
    }

    public static <T> ObjectIterable<T> sorted(Iterable<? extends T> iterable, Comparator<T> sorter) {
        return new SortedIterable<T>(ObjectIterables.wrap(iterable), sorter);
    }

    public static <T> ObjectIterable<T> peek(ObjectIterable<T> iterable, Consumer<T> action) {
        return new PeekIterable<T>(iterable, action);
    }

    public static <T> ObjectIterable<T> peek(Iterable<? extends T> iterable, Consumer<T> action) {
        return new PeekIterable<T>(ObjectIterables.wrap(iterable), action);
    }

    public static <T> ObjectIterable<T> wrap(Iterable<? extends T> iterable) {
        return new WrappedIterable<T>(iterable);
    }

    private static class PeekIterable<T>
    implements ObjectIterable<T>,
    ISizeProvider {
        ObjectIterable<T> iterable;
        Consumer<T> action;

        public PeekIterable(ObjectIterable<T> iterable, Consumer<T> action) {
            this.iterable = iterable;
            this.action = action;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return ObjectIterators.peek(this.iterable.iterator(), this.action);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach(this.action.andThen(action));
        }
    }

    private static class DistinctIterable<T>
    implements ObjectIterable<T> {
        ObjectIterable<T> iterable;

        public DistinctIterable(ObjectIterable<T> iterable) {
            this.iterable = iterable;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return ObjectIterators.distinct(this.iterable.iterator());
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            ObjectCollections.DistinctCollectionWrapper filtered = ObjectCollections.distinctWrapper();
            this.iterable.forEach(T -> {
                if (filtered.add(T)) {
                    action.accept(T);
                }
            });
        }
    }

    private static class SortedIterable<T>
    implements ObjectIterable<T>,
    ISizeProvider {
        ObjectIterable<T> iterable;
        Comparator<T> sorter;

        public SortedIterable(ObjectIterable<T> iterable, Comparator<T> sorter) {
            this.iterable = iterable;
            this.sorter = sorter;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return ObjectIterators.sorted(this.iterable.iterator(), this.sorter);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            ObjectCollections.CollectionWrapper<Object> wrapper = ObjectCollections.wrapper();
            this.iterable.forEach(wrapper::add);
            wrapper.unstableSort(this.sorter);
            wrapper.forEach(action);
        }
    }

    private static class LimitedIterable<T>
    implements ObjectIterable<T>,
    ISizeProvider {
        ObjectIterable<T> iterable;
        long limit;

        public LimitedIterable(ObjectIterable<T> iterable, long limit) {
            this.iterable = iterable;
            this.limit = limit;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return ObjectIterators.limit(this.iterable.iterator(), this.limit);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : (int)Math.min((long)prov.size(), this.limit);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            AtomicLong counter = new AtomicLong();
            this.iterable.forEach(T -> {
                if (counter.get() >= this.limit) {
                    return;
                }
                counter.incrementAndGet();
                action.accept(T);
            });
        }
    }

    private static class FilteredIterable<T>
    implements ObjectIterable<T> {
        ObjectIterable<T> iterable;
        Predicate<T> filter;

        public FilteredIterable(ObjectIterable<T> iterable, Predicate<T> filter) {
            this.iterable = iterable;
            this.filter = filter;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return ObjectIterators.filter(this.iterable.iterator(), this.filter);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach(T -> {
                if (!this.filter.test(T)) {
                    action.accept(T);
                }
            });
        }
    }

    private static class RepeatingIterable<T>
    implements ObjectIterable<T>,
    ISizeProvider {
        ObjectIterable<T> iterable;
        int repeats;

        public RepeatingIterable(ObjectIterable<T> iterable, int repeats) {
            this.iterable = iterable;
            this.repeats = repeats;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return ObjectIterators.repeat(this.iterable.iterator(), this.repeats);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size() * (this.repeats + 1);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            ObjectCollections.CollectionWrapper repeater = ObjectCollections.wrapper();
            this.iterable.forEach(T -> {
                action.accept(T);
                repeater.add(T);
            });
            for (int i = 0; i < this.repeats; ++i) {
                repeater.forEach(action);
            }
        }
    }

    private static class FlatMappedArrayIterable<E, T>
    implements ObjectIterable<T> {
        ObjectIterable<E> iterable;
        UnaryOperator<E, T[]> mapper;

        FlatMappedArrayIterable(ObjectIterable<E> iterable, UnaryOperator<E, T[]> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return ObjectIterators.arrayFlatMap(this.iterable.iterator(), this.mapper);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach(E -> {
                T[] array = this.mapper.apply(E);
                int i = 0;
                int m = array.length;
                while (i < m) {
                    action.accept((T)array[i++]);
                }
            });
        }
    }

    private static class FlatMappedIterable<E, T, V extends Iterable<T>>
    implements ObjectIterable<T> {
        ObjectIterable<E> iterable;
        UnaryOperator<E, V> mapper;

        FlatMappedIterable(ObjectIterable<E> iterable, UnaryOperator<E, V> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return ObjectIterators.flatMap(this.iterable.iterator(), this.mapper);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach(E -> ((Iterable)this.mapper.apply(E)).forEach(action));
        }
    }

    private static class MappedIterable<E, T>
    implements ObjectIterable<T>,
    ISizeProvider {
        ObjectIterable<E> iterable;
        UnaryOperator<E, T> mapper;

        MappedIterable(ObjectIterable<E> iterable, UnaryOperator<E, T> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return ObjectIterators.map(this.iterable.iterator(), this.mapper);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach(E -> action.accept((T)this.mapper.apply(E)));
        }
    }

    private static class WrappedIterable<T>
    implements ObjectIterable<T>,
    ISizeProvider {
        Iterable<? extends T> iterable;

        public WrappedIterable(Iterable<? extends T> iterable) {
            this.iterable = iterable;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return ObjectIterators.wrap(this.iterable.iterator());
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach(action);
        }
    }
}

