/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.maps.interfaces;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.ObjectSupplier;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.functions.function.UnaryOperator;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectOpenHashMap;
import speiger.src.collections.objects.sets.ObjectSet;

public interface Object2ObjectMap<T, V>
extends Map<T, V>,
UnaryOperator<T, V> {
    public static MapBuilder builder() {
        return MapBuilder.INSTANCE;
    }

    public V getDefaultReturnValue();

    public Object2ObjectMap<T, V> setDefaultReturnValue(V var1);

    public Object2ObjectMap<T, V> copy();

    @Override
    public V put(T var1, V var2);

    default public V put(Entry<T, V> entry) {
        return this.put((T)entry.getKey(), (V)entry.getValue());
    }

    default public void putAll(T[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalStateException("Array sizes do not match");
        }
        this.putAll(keys, values, 0, keys.length);
    }

    public void putAll(T[] var1, V[] var2, int var3, int var4);

    @Override
    public V putIfAbsent(T var1, V var2);

    public void putAllIfAbsent(Object2ObjectMap<T, V> var1);

    @Override
    public void putAll(Object2ObjectMap<T, V> var1);

    public V rem(T var1);

    @Override
    default public V remove(Object key) {
        return this.rem(key);
    }

    public V remOrDefault(T var1, V var2);

    @Override
    public boolean replace(T var1, V var2, V var3);

    @Override
    public V replace(T var1, V var2);

    public void replaceObjects(Object2ObjectMap<T, V> var1);

    public void replaceObjects(ObjectObjectUnaryOperator<T, V> var1);

    public V compute(T var1, ObjectObjectUnaryOperator<T, V> var2);

    @Override
    public V computeIfAbsent(T var1, UnaryOperator<T, V> var2);

    public V supplyIfAbsent(T var1, ObjectSupplier<V> var2);

    public V computeIfPresent(T var1, ObjectObjectUnaryOperator<T, V> var2);

    public V merge(T var1, V var2, ObjectObjectUnaryOperator<V, V> var3);

    public void mergeAll(Object2ObjectMap<T, V> var1, ObjectObjectUnaryOperator<V, V> var2);

    @Override
    default public V apply(T key) {
        return this.getObject(key);
    }

    public V getObject(T var1);

    @Override
    default public void replaceAll(BiFunction<? super T, ? super V, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        this.replaceObjects(mappingFunction instanceof ObjectObjectUnaryOperator ? (ObjectObjectUnaryOperator)mappingFunction : (K, V) -> mappingFunction.apply((Object)K, (Object)V));
    }

    @Override
    default public V compute(T key, BiFunction<? super T, ? super V, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return this.compute(key, mappingFunction instanceof ObjectObjectUnaryOperator ? (ObjectObjectUnaryOperator)mappingFunction : (K, V) -> mappingFunction.apply((Object)K, (Object)V));
    }

    @Override
    default public V computeIfAbsent(T key, Function<? super T, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return (V)this.computeIfAbsent(key, mappingFunction instanceof UnaryOperator ? (UnaryOperator<Object, Object>)mappingFunction : K -> mappingFunction.apply(K));
    }

    @Override
    default public V computeIfPresent(T key, BiFunction<? super T, ? super V, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return this.computeIfPresent(key, mappingFunction instanceof ObjectObjectUnaryOperator ? (ObjectObjectUnaryOperator)mappingFunction : (K, V) -> mappingFunction.apply((Object)K, (Object)V));
    }

    @Override
    default public V merge(T key, V value, BiFunction<? super V, ? super V, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Objects.requireNonNull(value);
        return this.merge(key, value, mappingFunction instanceof ObjectObjectUnaryOperator ? (ObjectObjectUnaryOperator)mappingFunction : (K, V) -> mappingFunction.apply((Object)K, (Object)V));
    }

    @Override
    public void forEach(ObjectObjectConsumer<T, V> var1);

    @Override
    default public void forEach(BiConsumer<? super T, ? super V> action) {
        Objects.requireNonNull(action);
        this.forEach(action instanceof ObjectObjectConsumer ? (ObjectObjectConsumer<Object, Object>)action : (K, V) -> action.accept((Object)K, (Object)V));
    }

    @Override
    public ObjectSet<T> keySet();

    @Override
    public ObjectCollection<V> values();

    @Override
    public ObjectSet<Map.Entry<T, V>> entrySet();

    public ObjectSet<Entry<T, V>> object2ObjectEntrySet();

    public static class BuilderCache<T, V> {
        T[] keys;
        V[] values;
        int size;

        public BuilderCache() {
            this(16);
        }

        public BuilderCache(int initialSize) {
            if (initialSize < 0) {
                throw new IllegalStateException("Minimum Capacity is negative. This is not allowed");
            }
            this.keys = new Object[initialSize];
            this.values = new Object[initialSize];
        }

        private void ensureSize(int newSize) {
            if (this.keys.length >= newSize) {
                return;
            }
            newSize = (int)Math.max(Math.min((long)this.keys.length + (long)(this.keys.length >> 1), 0x7FFFFFF7L), (long)newSize);
            this.keys = Arrays.copyOf(this.keys, newSize);
            this.values = Arrays.copyOf(this.values, newSize);
        }

        public BuilderCache<T, V> put(T key, V value) {
            this.ensureSize(this.size + 1);
            this.keys[this.size] = key;
            this.values[this.size] = value;
            ++this.size;
            return this;
        }

        public BuilderCache<T, V> put(Entry<T, V> entry) {
            return this.put(entry.getKey(), entry.getValue());
        }

        public BuilderCache<T, V> putAll(Object2ObjectMap<T, V> map) {
            return this.putAll(map.object2ObjectEntrySet());
        }

        public BuilderCache<T, V> putAll(Map<? extends T, ? extends V> map) {
            for (Map.Entry<T, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public BuilderCache<T, V> putAll(ObjectIterable<Entry<T, V>> c) {
            if (c instanceof Collection) {
                this.ensureSize(this.size + ((Collection)((Object)c)).size());
            }
            for (Entry entry : c) {
                this.put(entry);
            }
            return this;
        }

        private <E extends Object2ObjectMap<T, V>> E putElements(E e) {
            e.putAll(this.keys, this.values, 0, this.size);
            return e;
        }

        public Object2ObjectOpenHashMap<T, V> map() {
            return this.putElements(new Object2ObjectOpenHashMap(this.size));
        }
    }

    public static final class MapBuilder {
        static final MapBuilder INSTANCE = new MapBuilder();

        public <T, V> BuilderCache<T, V> start() {
            return new BuilderCache();
        }

        public <T, V> BuilderCache<T, V> start(int size) {
            return new BuilderCache(size);
        }

        public <T, V> BuilderCache<T, V> put(T key, V value) {
            return new BuilderCache<T, V>().put(key, value);
        }

        public <T, V> Object2ObjectOpenHashMap<T, V> map() {
            return new Object2ObjectOpenHashMap();
        }

        public <T, V> Object2ObjectOpenHashMap<T, V> map(int size) {
            return new Object2ObjectOpenHashMap(size);
        }

        public <T, V> Object2ObjectOpenHashMap<T, V> map(T[] keys, V[] values) {
            return new Object2ObjectOpenHashMap<T, V>(keys, values);
        }

        public <T, V> Object2ObjectOpenHashMap<T, V> map(Object2ObjectMap<T, V> map) {
            return new Object2ObjectOpenHashMap<T, V>(map);
        }

        public <T, V> Object2ObjectOpenHashMap<T, V> map(Map<? extends T, ? extends V> map) {
            return new Object2ObjectOpenHashMap<T, V>(map);
        }
    }

    public static interface Entry<T, V>
    extends Map.Entry<T, V> {
    }

    public static interface FastEntrySet<T, V>
    extends ObjectSet<Entry<T, V>> {
        public ObjectIterator<Entry<T, V>> fastIterator();

        default public void fastForEach(Consumer<? super Entry<T, V>> action) {
            this.forEach(action);
        }
    }
}

