/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.longs.collections;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.LongPredicate;
import speiger.src.collections.ints.functions.consumer.IntLongConsumer;
import speiger.src.collections.longs.collections.LongCollection;
import speiger.src.collections.longs.collections.LongIterator;
import speiger.src.collections.longs.collections.LongSplititerator;
import speiger.src.collections.longs.functions.LongComparator;
import speiger.src.collections.longs.functions.LongConsumer;
import speiger.src.collections.longs.functions.function.LongFunction;
import speiger.src.collections.longs.functions.function.LongLongUnaryOperator;
import speiger.src.collections.longs.utils.LongArrays;
import speiger.src.collections.longs.utils.LongIterables;
import speiger.src.collections.longs.utils.LongIterators;
import speiger.src.collections.longs.utils.LongSplititerators;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.functions.consumer.ObjectLongConsumer;
import speiger.src.collections.utils.ISizeProvider;

public interface LongIterable
extends Iterable<Long> {
    public LongIterator iterator();

    default public void forEach(LongConsumer action) {
        Objects.requireNonNull(action);
        this.iterator().forEachRemaining(action);
    }

    @Override
    @Deprecated
    default public void forEach(Consumer<? super Long> action) {
        Objects.requireNonNull(action);
        this.iterator().forEachRemaining(action);
    }

    default public void forEachIndexed(IntLongConsumer action) {
        Objects.requireNonNull(action);
        int index = 0;
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            action.accept(index++, iter.nextLong());
        }
    }

    default public <E> void forEach(E input, ObjectLongConsumer<E> action) {
        Objects.requireNonNull(action);
        this.iterator().forEachRemaining(input, action);
    }

    default public LongSplititerator spliterator() {
        return LongSplititerators.createUnknownSplititerator(this.iterator(), 0);
    }

    default public <E> ObjectIterable<E> map(LongFunction<E> mapper) {
        return LongIterables.map(this, mapper);
    }

    default public <E, V extends Iterable<E>> ObjectIterable<E> flatMap(LongFunction<V> mapper) {
        return LongIterables.flatMap(this, mapper);
    }

    default public <E> ObjectIterable<E> arrayflatMap(LongFunction<E[]> mapper) {
        return LongIterables.arrayFlatMap(this, mapper);
    }

    default public LongIterable filter(LongPredicate filter) {
        return LongIterables.filter(this, filter);
    }

    default public LongIterable distinct() {
        return LongIterables.distinct(this);
    }

    default public LongIterable repeat(int repeats) {
        return LongIterables.repeat(this, repeats);
    }

    default public LongIterable limit(long limit) {
        return LongIterables.limit(this, limit);
    }

    default public LongIterable sorted(LongComparator sorter) {
        return LongIterables.sorted(this, sorter);
    }

    default public LongIterable peek(LongConsumer action) {
        return LongIterables.peek(this, action);
    }

    default public <E extends LongCollection> E pour(E collection) {
        LongIterators.pour(this.iterator(), collection);
        return collection;
    }

    default public long[] toLongArray() {
        int size;
        ISizeProvider prov = ISizeProvider.of(this);
        if (prov != null && (size = prov.size()) >= 0) {
            long[] array = new long[size];
            LongIterators.unwrap(array, this.iterator());
            return array;
        }
        return LongArrays.pour(this.iterator());
    }

    default public boolean matchesAny(LongPredicate filter) {
        Objects.requireNonNull(filter);
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!filter.test(iter.nextLong())) continue;
            return true;
        }
        return false;
    }

    default public boolean matchesNone(LongPredicate filter) {
        Objects.requireNonNull(filter);
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!filter.test(iter.nextLong())) continue;
            return false;
        }
        return true;
    }

    default public boolean matchesAll(LongPredicate filter) {
        Objects.requireNonNull(filter);
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (filter.test(iter.nextLong())) continue;
            return false;
        }
        return true;
    }

    default public long findFirst(LongPredicate filter) {
        Objects.requireNonNull(filter);
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            long entry = iter.nextLong();
            if (!filter.test(entry)) continue;
            return entry;
        }
        return 0L;
    }

    default public long reduce(long identity, LongLongUnaryOperator operator) {
        Objects.requireNonNull(operator);
        long state = identity;
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            state = operator.applyAsLong(state, iter.nextLong());
        }
        return state;
    }

    default public long reduce(LongLongUnaryOperator operator) {
        Objects.requireNonNull(operator);
        long state = 0L;
        boolean empty = true;
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (empty) {
                empty = false;
                state = iter.nextLong();
                continue;
            }
            state = operator.applyAsLong(state, iter.nextLong());
        }
        return state;
    }

    default public int count(LongPredicate filter) {
        Objects.requireNonNull(filter);
        int result = 0;
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!filter.test(iter.nextLong())) continue;
            ++result;
        }
        return result;
    }
}

