/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.ints.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Objects;
import speiger.src.collections.ints.collections.IntCollection;
import speiger.src.collections.ints.collections.IntIterator;
import speiger.src.collections.ints.functions.IntConsumer;
import speiger.src.collections.ints.utils.IntArrays;
import speiger.src.collections.ints.utils.IntIterators;

public abstract class AbstractIntCollection
extends AbstractCollection<Integer>
implements IntCollection {
    @Override
    public abstract IntIterator iterator();

    @Override
    @Deprecated
    public boolean add(Integer e) {
        return IntCollection.super.add(e);
    }

    @Override
    public boolean addAll(IntCollection c) {
        boolean modified = false;
        IntIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= ((AbstractCollection)this).add(iter.nextInt());
        }
        return modified;
    }

    @Override
    public IntCollection copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean contains(Object e) {
        return IntCollection.super.contains(e);
    }

    @Override
    public boolean contains(int e) {
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.nextInt() != e) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends Integer> c) {
        return c instanceof IntCollection ? this.addAll((IntCollection)c) : super.addAll(c);
    }

    @Override
    public boolean containsAll(IntCollection c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return true;
        }
        IntIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.nextInt())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return c instanceof IntCollection ? this.containsAll((IntCollection)c) : super.containsAll(c);
    }

    @Override
    @Deprecated
    public boolean containsAny(Collection<?> c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        for (Object e : c) {
            if (!this.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAny(IntCollection c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        IntIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.contains(iter.nextInt())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean remove(Object e) {
        return IntCollection.super.remove(e);
    }

    @Override
    public boolean remInt(int e) {
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.nextInt() != e) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(IntCollection c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!c.contains(iter.nextInt())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(IntCollection c, IntConsumer r) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        Objects.requireNonNull(r);
        boolean modified = false;
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            int e = iter.nextInt();
            if (!c.contains(e)) continue;
            r.accept(e);
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(IntCollection c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            boolean modified = !this.isEmpty();
            this.clear();
            return modified;
        }
        boolean modified = false;
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.nextInt())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(IntCollection c, IntConsumer r) {
        Objects.requireNonNull(c);
        Objects.requireNonNull(r);
        if (c.isEmpty()) {
            boolean modified = !this.isEmpty();
            this.forEach(r);
            this.clear();
            return modified;
        }
        boolean modified = false;
        IntIterator iter = this.iterator();
        while (iter.hasNext()) {
            int e = iter.nextInt();
            if (c.contains(e)) continue;
            r.accept(e);
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public int[] toIntArray() {
        if (this.isEmpty()) {
            return IntArrays.EMPTY_ARRAY;
        }
        return this.toIntArray(new int[this.size()]);
    }

    @Override
    public int[] toIntArray(int[] a) {
        if (a == null || a.length < this.size()) {
            a = new int[this.size()];
        }
        IntIterators.unwrap(a, this.iterator());
        if (a.length > this.size()) {
            a[this.size()] = 0;
        }
        return a;
    }
}

