/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.booleans.functions.function;

import java.util.Objects;

@FunctionalInterface
public interface BooleanPredicate {
    public boolean test(boolean var1);

    public static BooleanPredicate identity() {
        return T -> T;
    }

    default public BooleanPredicate compose(BooleanPredicate before) {
        Objects.requireNonNull(before);
        return T -> this.test(before.test(T));
    }

    default public BooleanPredicate andThen(BooleanPredicate after) {
        Objects.requireNonNull(after);
        return T -> after.test(this.test(T));
    }

    public static BooleanPredicate alwaysTrue() {
        return T -> true;
    }

    public static BooleanPredicate alwaysFalse() {
        return T -> false;
    }

    default public BooleanPredicate andType(BooleanPredicate other) {
        Objects.requireNonNull(other);
        return T -> this.test(T) && other.test(T);
    }

    default public BooleanPredicate negate() {
        return T -> !this.test(T);
    }

    default public BooleanPredicate orType(BooleanPredicate other) {
        Objects.requireNonNull(other);
        return T -> this.test(T) || other.test(T);
    }
}

