/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api.heraldry;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mods.battlegear2.api.heraldry.Crest;

public class HeraldryData {
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int BLUE = 3;
    public static final int MAX_CRESTS = 6;
    private int storageIndex;
    private byte pattern;
    private int[] patternColours;
    private byte[] extraData;
    private static final int extraDataSize = 6;
    public static final HeraldryData defaultData = new HeraldryData(0, 0, Color.YELLOW.getRGB(), Color.BLUE.getRGB(), Color.BLACK.getRGB(), new ArrayList<Crest>(), new byte[6]);
    private byte[] byteArray = null;
    private List<Crest> crests;

    public HeraldryData(int patternStoreIndex, byte pattern, int pattern_col_1, int pattern_col_2, int pattern_col_3, List<Crest> crests, byte[] extraData) {
        this.storageIndex = patternStoreIndex;
        this.pattern = pattern;
        this.patternColours = new int[]{pattern_col_1, pattern_col_2, pattern_col_3};
        this.crests = crests;
        this.extraData = extraData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeraldryData(byte[] crestData) {
        FilterInputStream input = null;
        try {
            int i;
            input = new DataInputStream(new ByteArrayInputStream(crestData));
            this.storageIndex = ((DataInputStream)input).readInt();
            this.pattern = ((DataInputStream)input).readByte();
            this.patternColours = new int[]{((DataInputStream)input).readInt(), ((DataInputStream)input).readInt(), ((DataInputStream)input).readInt()};
            int crestCount = ((DataInputStream)input).readByte();
            this.crests = new ArrayList<Crest>(crestCount);
            for (i = 0; i < crestCount; ++i) {
                byte[] bytes = new byte[Crest.dataSize];
                ((DataInputStream)input).read(bytes);
                this.crests.add(new Crest(bytes));
            }
            this.extraData = new byte[6];
            for (i = 0; i < 6; ++i) {
                this.extraData[i] = ((DataInputStream)input).readByte();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static HeraldryData getDefault() {
        return defaultData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray() {
        if (this.byteArray != null) {
            return this.byteArray;
        }
        FilterOutputStream output = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            output = new DataOutputStream(bos);
            ((DataOutputStream)output).writeInt(this.storageIndex);
            ((DataOutputStream)output).writeByte(this.pattern);
            ((DataOutputStream)output).writeInt(this.patternColours[0]);
            ((DataOutputStream)output).writeInt(this.patternColours[1]);
            ((DataOutputStream)output).writeInt(this.patternColours[2]);
            ((DataOutputStream)output).writeByte(this.crests.size());
            for (Crest c : this.crests) {
                output.write(c.getByteArray());
            }
            output.write(this.extraData);
            this.byteArray = bos.toByteArray();
            Object object = this.byteArray;
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public List<Crest> getCrests() {
        return this.crests;
    }

    public byte[] getExtraData() {
        return this.extraData;
    }

    public int getPatternIndex() {
        return this.storageIndex;
    }

    public byte getPattern() {
        return this.pattern;
    }

    public int getColour(int index) {
        return this.patternColours[index];
    }

    public static String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder();
        for (byte b : a) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public void setColour(int i, int rgb) {
        this.patternColours[i] = rgb;
        this.byteArray = null;
    }

    public void setPatternIndex(int index) {
        this.storageIndex = index;
        this.byteArray = null;
    }

    public void setPattern(int pattern) {
        this.pattern = (byte)pattern;
        this.byteArray = null;
    }

    public HeraldryData clone() {
        return new HeraldryData(this.storageIndex, this.pattern, this.patternColours[0], this.patternColours[1], this.patternColours[2], this.crests, this.extraData);
    }
}

