/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import mods.battlegear2.CommandWeaponWield;
import mods.battlegear2.CommonProxy;
import mods.battlegear2.api.quiver.IArrowFireHandler;
import mods.battlegear2.api.quiver.IQuiverSelection;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.api.weapons.WeaponRegistry;
import mods.battlegear2.gui.BattlegearGUIHandeler;
import mods.battlegear2.packet.BattlegearPacketHandeler;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.command.ICommand;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import org.apache.logging.log4j.Logger;

@Mod(acceptedMinecraftVersions="[1.7.10]", modid="battlegear2", name="Mine & Blade Battlegear 2", version="1.3.6", guiFactory="mods.battlegear2.gui.BattlegearGuiFactory")
public class Battlegear {
    public static final String MODID = "battlegear2";
    public static final String imageFolder = "battlegear2:textures/";
    public static final String CUSTOM_DAMAGE_SOURCE = "battlegearExtra";
    @Mod.Instance(value="battlegear2")
    public static Battlegear INSTANCE;
    @SidedProxy(modId="battlegear2", clientSide="mods.battlegear2.client.ClientProxy", serverSide="mods.battlegear2.CommonProxy")
    public static CommonProxy proxy;
    public static ItemArmor.ArmorMaterial knightArmourMaterial;
    public static boolean battlegearEnabled;
    public static boolean debug;
    public static Logger logger;
    public static BattlegearPacketHandeler packetHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        knightArmourMaterial = EnumHelper.addArmorMaterial((String)"knights.armour", (int)25, (int[])new int[]{3, 7, 5, 3}, (int)15);
        BattlegearConfig.getConfig(new Configuration(event.getSuggestedConfigurationFile()));
        logger = event.getModLog();
        proxy.registerKeyHandelers();
        proxy.registerTickHandelers();
        proxy.registerItemRenderers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        BattlegearConfig.registerRecipes();
        QuiverArrowRegistry.addArrowToRegistry(Items.field_151032_g, EntityArrow.class);
        packetHandler = new BattlegearPacketHandeler();
        packetHandler.register();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new BattlegearGUIHandeler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"TConstruct")) {
            proxy.tryUseTConstruct();
        }
        if (Loader.isModLoaded((String)"DynamicLights_thePlayer")) {
            proxy.tryUseDynamicLight(null, null);
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)CommandWeaponWield.INSTANCE);
    }

    @Mod.EventHandler
    public void onMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            boolean success;
            block21: {
                if (message == null) continue;
                success = false;
                if (message.isItemStackMessage()) {
                    ItemStack stack = message.getItemStackValue();
                    if (stack != null) {
                        if (WeaponRegistry.setWeapon(message.key, stack)) {
                            success = true;
                        } else if (message.key.startsWith("Arrow")) {
                            Class<?> clazz = null;
                            try {
                                if (message.key.indexOf(":") > 0) {
                                    clazz = Class.forName(message.key.split(":")[1]);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (clazz != null && EntityArrow.class.isAssignableFrom(clazz)) {
                                QuiverArrowRegistry.addArrowToRegistry(stack, clazz);
                                success = true;
                            } else {
                                QuiverArrowRegistry.addArrowToRegistry(stack);
                                success = true;
                            }
                        }
                    }
                } else if (message.isStringMessage()) {
                    try {
                        Class<?> clazz = Class.forName(message.getStringValue());
                        if (clazz == null) break block21;
                        if (message.key.equals("QuiverSelection") && IQuiverSelection.class.isAssignableFrom(clazz)) {
                            QuiverArrowRegistry.addQuiverSelection((IQuiverSelection)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                            success = true;
                        } else if (message.key.equals("FireHandler") && IArrowFireHandler.class.isAssignableFrom(clazz)) {
                            QuiverArrowRegistry.addArrowFireHandler((IArrowFireHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                            success = true;
                        }
                    }
                    catch (Exception exception) {}
                } else if (message.isNBTMessage() && Loader.instance().hasReachedState(LoaderState.PREINITIALIZATION) && !Loader.instance().hasReachedState(LoaderState.INITIALIZATION) && BattlegearConfig.initItemFromNBT(message.getNBTValue())) {
                    success = true;
                }
            }
            if (success) {
                logger.trace("Mine&Blade:Battlegear2 successfully managed message from " + message.getSender());
                continue;
            }
            logger.warn(message.getSender() + " tried to communicate with Mine&Blade:Battlegear2, but message was not supported!");
        }
    }

    @Mod.EventHandler
    public void onRemapId(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (!BattlegearConfig.remap(mapping)) continue;
            logger.warn("ReMapped: " + mapping.name);
        }
    }

    @NetworkCheckHandler
    public boolean checkRemote(Map<String, String> mods, Side remoteParty) {
        String remoteVersion;
        if (mods.containsKey(MODID) && (remoteVersion = mods.get(MODID)) != null) {
            String internalVersion = FMLCommonHandler.instance().findContainerFor((Object)this).getVersion();
            if (remoteVersion.equals(internalVersion)) {
                return true;
            }
            internalVersion = internalVersion.substring(0, internalVersion.lastIndexOf("."));
            remoteVersion = remoteVersion.substring(0, internalVersion.lastIndexOf("."));
            return remoteVersion.equals(internalVersion);
        }
        return false;
    }

    static {
        battlegearEnabled = true;
        debug = false;
    }
}

