/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import serverutils.handlers.ServerUtilitiesClientEventHandler;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageSendBadge
extends MessageToClient {
    private UUID playerId;
    private String badgeURL;

    public MessageSendBadge() {
    }

    public MessageSendBadge(UUID player, String url) {
        this.playerId = player;
        this.badgeURL = url;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.GENERAL;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeUUID(this.playerId);
        data.writeString(this.badgeURL);
    }

    @Override
    public void readData(DataIn data) {
        this.playerId = data.readUUID();
        this.badgeURL = data.readString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        ServerUtilitiesClientEventHandler.setBadge(this.playerId, this.badgeURL);
    }
}

