/*
 * Decompiled with CFR 0.152.
 */
package serverutils.integration.vp.journeymap;

import com.sinthoras.visualprospecting.integration.journeymap.drawsteps.ClickableDrawStep;
import com.sinthoras.visualprospecting.integration.model.locations.IWaypointAndLocationProvider;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.render.map.GridRenderer;
import net.minecraft.client.gui.FontRenderer;
import serverutils.integration.vp.VPClaimsLocation;
import serverutils.lib.icon.Color4I;

public class VPDrawStep
implements ClickableDrawStep {
    private final VPClaimsLocation location;
    private double topX = 0.0;
    private double topY = 0.0;
    private double chunkSize = 0.0;

    public VPDrawStep(VPClaimsLocation location) {
        this.location = location;
    }

    public void draw(double draggedPixelX, double draggedPixelY, GridRenderer gridRenderer, float drawScale, double fontScale, double rotation) {
        int zoom = gridRenderer.getZoom();
        double blockSize = Math.pow(2.0, zoom);
        Point2D.Double blockAsPixel = gridRenderer.getBlockPixelInGrid(this.location.getBlockX(), this.location.getBlockZ());
        Point2D.Double pixel = new Point2D.Double(blockAsPixel.getX() + draggedPixelX, blockAsPixel.getY() + draggedPixelY);
        this.chunkSize = blockSize * 16.0;
        this.topX = pixel.getX();
        this.topY = pixel.getY();
        Color4I teamColor = this.location.getTeamColor().getColor().withAlpha(135);
        if (!this.location.isLoaded()) {
            teamColor.addBrightness(-0.3f).draw((int)pixel.getX(), (int)pixel.getY(), (int)this.chunkSize, (int)this.chunkSize);
        } else {
            teamColor.draw((int)pixel.getX(), (int)pixel.getY(), (int)this.chunkSize, (int)this.chunkSize);
        }
    }

    public List<String> getTooltip() {
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(this.location.getTeamName());
        if (!this.location.teamHint().isEmpty()) {
            tooltip.add(this.location.teamHint());
        }
        if (!this.location.loadedHint().isEmpty()) {
            tooltip.add(this.location.loadedHint());
        }
        if (this.location.getOwnTeam()) {
            tooltip.add(this.location.claimHint());
            tooltip.add(this.location.toggleLoadHint());
            tooltip.add(this.location.unclaimHint());
        }
        return tooltip;
    }

    public void drawTooltip(FontRenderer fontRenderer, int mouseX, int mouseY, int displayWidth, int displayHeight) {
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return (double)mouseX >= this.topX && (double)mouseX <= this.topX + this.chunkSize && (double)mouseY >= this.topY && (double)mouseY <= this.topY + this.chunkSize;
    }

    public void onActionKeyPressed() {
        this.location.removeClaim();
    }

    public IWaypointAndLocationProvider getLocationProvider() {
        return this.location;
    }
}

