/*
 * Decompiled with CFR 0.152.
 */
package kubatech.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public static File configFile;
    public static File configDirectory;

    public static void init(File configFile) {
        configDirectory = new File(configFile, "kubatech");
        Config.configFile = new File(configDirectory, "kubatech.cfg");
    }

    public static File getConfigFile(String file) {
        return new File(configDirectory, file);
    }

    public static void synchronizeConfiguration() {
        Configuration configuration = new Configuration(configFile);
        configuration.load();
        MobHandler.load(configuration);
        Debug.load(configuration);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static class Debug {
        public static boolean showRenderErrors = false;

        private static void load(Configuration configuration) {
            Category category = Category.DEBUG;
            showRenderErrors = configuration.get(category.get(), "ShowRenderErrors", false).getBoolean();
        }
    }

    public static class MobHandler {
        public static double playerOnlyDropsModifier = 0.1;

        private static void load(Configuration configuration) {
            Category category = Category.MOB_HANDLER;
            playerOnlyDropsModifier = configuration.get(category.get(), "PlayerOnlyDropsModifier", 0.1, "Hard player only loot (such as core mod drops) will be multiplied by this number").getDouble();
        }
    }

    private static enum Category {
        MOB_HANDLER("MobHandler"),
        DEBUG("Debug");

        final String categoryName;

        private Category(String s) {
            this.categoryName = s;
        }

        public String get() {
            return this.categoryName;
        }

        public String toString() {
            return this.get();
        }
    }
}

