/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import goodgenerator.blocks.tileEntity.GTMetaTileEntity.NeutronAccelerator;
import goodgenerator.blocks.tileEntity.GTMetaTileEntity.NeutronSensor;
import goodgenerator.blocks.tileEntity.base.GT_MetaTileEntity_TooltipMultiBlockBase_EM;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import goodgenerator.util.ItemRefer;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.IGT_HatchAdder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class NeutronActivator
extends GT_MetaTileEntity_TooltipMultiBlockBase_EM
implements IConstructable,
ISurvivalConstructable {
    protected static IStructureDefinition<NeutronActivator> multiDefinition = null;
    protected final ArrayList<NeutronAccelerator> mNeutronAccelerator = new ArrayList();
    protected final ArrayList<NeutronSensor> mNeutronSensor = new ArrayList();
    protected int casingAmount = 0;
    protected int height = 0;
    protected int eV = 0;
    protected int mCeil = 0;
    protected int mFloor = 0;
    private GT_Recipe lastRecipe;
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();
    final XSTR R = new XSTR();
    private static final IIconContainer textureFontOn = new Textures.BlockIcons.CustomIcon("icons/NeutronActivator_On");
    private static final IIconContainer textureFontOn_Glow = new Textures.BlockIcons.CustomIcon("icons/NeutronActivator_On_GLOW");
    private static final IIconContainer textureFontOff = new Textures.BlockIcons.CustomIcon("icons/NeutronActivator_Off");
    private static final IIconContainer textureFontOff_Glow = new Textures.BlockIcons.CustomIcon("icons/NeutronActivator_Off_GLOW");
    protected final String NA_BOTTOM = this.mName + "buttom";
    protected final String NA_MID = this.mName + "mid";
    protected final String NA_TOP = this.mName + "top";

    public NeutronActivator(String name) {
        super(name);
    }

    public NeutronActivator(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @NotNull
            protected GT_OverclockCalculator createOverclockCalculator(@NotNull GT_Recipe recipe) {
                return GT_OverclockCalculator.ofNoOverclock((GT_Recipe)recipe).setDuration((int)Math.ceil((double)recipe.mDuration * Math.pow(0.9f, NeutronActivator.this.height - 4))).setDurationUnderOneTickSupplier(() -> (double)recipe.mDuration * Math.pow(0.9f, NeutronActivator.this.height - 4));
            }

            @NotNull
            public CheckRecipeResult process() {
                CheckRecipeResult result = super.process();
                if (!result.wasSuccessful()) {
                    return result;
                }
                NeutronActivator.this.mFloor = this.lastRecipe.mSpecialValue % 10000 * 1000000;
                NeutronActivator.this.mCeil = this.lastRecipe.mSpecialValue / 10000 * 1000000;
                if (NeutronActivator.this.eV > NeutronActivator.this.mCeil || NeutronActivator.this.eV < NeutronActivator.this.mFloor) {
                    this.setOutputItems(new ItemStack[]{ItemRefer.Radioactive_Waste.get(4)});
                }
                this.calculatedEut = 0L;
                return result;
            }
        };
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(1L);
    }

    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        boolean bl = this.batchMode = !this.batchMode;
        if (this.batchMode) {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
        } else {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
        }
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.eV = aNBT.func_74762_e("mKeV");
        this.mCeil = aNBT.func_74762_e("mCeil");
        this.mFloor = aNBT.func_74762_e("mFloor");
        this.height = aNBT.func_74762_e("height");
        super.loadNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mKeV", this.eV);
        aNBT.func_74768_a("mCeil", this.mCeil);
        aNBT.func_74768_a("mFloor", this.mFloor);
        aNBT.func_74768_a("height", this.height);
        super.saveNBTData(aNBT);
    }

    public RecipeMap<?> getRecipeMap() {
        return GoodGeneratorRecipeMaps.neutronActivatorRecipes;
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Neutron Activator").addInfo("Controller block for the Neutron Activator").addInfo("Superluminal-velocity Motion.").addInfo("The minimum height of the Speeding Pipe Casing is 4.").addInfo("Per extra Speeding Pipe Casing will give time discount.").addInfo("But it will reduce the Neutron Accelerator efficiency.").addInfo("You need to input energy to the Neutron Accelerator to get it running.").addInfo("It will output correct products with Specific Neutron Kinetic Energy.").addInfo("Otherwise it will output trash.").addInfo("The Neutron Kinetic Energy will decrease 72KeV/s when no Neutron Accelerator is running.").addInfo("It will explode when the Neutron Kinetic Energy is over" + EnumChatFormatting.RED + " 1200MeV" + EnumChatFormatting.GRAY + ".").addInfo("Inputting Graphite/Beryllium dust can reduce 10MeV per dust immediately.").addInfo("The structure is too complex!").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().addController("Front bottom").addInputHatch("Hint block with dot 1").addInputBus("Hint block with dot 1").addOutputHatch("Hint block with dot 2").addOutputBus("Hint block with dot 2").addMaintenanceHatch("Hint block with dot 2").addOtherStructurePart("Neutron Accelerator", "Hint block with dot 2").addOtherStructurePart("Neutron Sensor", "Hint block with dot 2").addCasingInfoRange("Clean Stainless Steel Machine Casing", 7, 31, false).addCasingInfoExactly("Processor Machine Casing", 18, false).addCasingInfoMin("Steel Frame Box", 16, false).addCasingInfoMin("Speeding Pipe Casing", 4, false).addCasingInfoMin("EV+ Glass", 32, false).toolTipFinisher("Good Generator");
        return tt;
    }

    public IStructureDefinition<NeutronActivator> getStructure_EM() {
        if (multiDefinition == null) {
            multiDefinition = StructureDefinition.builder().addShape(this.NA_TOP, StructureUtility.transpose((String[][])new String[][]{{"CCCCC", "CDDDC", "CDDDC", "CDDDC", "CCCCC"}})).addShape(this.NA_MID, StructureUtility.transpose((String[][])new String[][]{{"F   F", " GGG ", " GPG ", " GGG ", "F   F"}})).addShape(this.NA_BOTTOM, StructureUtility.transpose((String[][])new String[][]{{"XX~XX", "XDDDX", "XDDDX", "XDDDX", "XXXXX"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(NeutronActivator.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.InputBus, GT_HatchElement.Maintenance}).casingIndex(49).dot(1).build(), StructureUtility.onElementPass(NeutronActivator::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))})).addElement('D', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)6)).addElement('F', GT_StructureUtility.ofFrame((Materials)Materials.Steel)).addElement('G', (IStructureElement)Glasses.chainAllGlasses()).addElement('P', StructureUtility.ofBlock((Block)Loaders.speedingPipe, (int)0)).addElement('X', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(NeutronActivator.class).atLeast(new IHatchElement[]{GT_HatchElement.OutputHatch, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, NeutronHatchElement.NeutronAccelerator, NeutronHatchElement.NeutronSensor}).casingIndex(49).dot(2).build(), StructureUtility.onElementPass(NeutronActivator::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))})).build();
        }
        return multiDefinition;
    }

    protected void clearHatches_EM() {
        super.clearHatches_EM();
        this.mNeutronAccelerator.clear();
        this.mNeutronSensor.clear();
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.casingAmount = 0;
        if (!this.structureCheck_EM(this.NA_BOTTOM, 2, 0, 0)) {
            return false;
        }
        this.height = 0;
        while (this.structureCheck_EM(this.NA_MID, 2, this.height + 1, 0)) {
            ++this.height;
        }
        if (this.height < 4) {
            return false;
        }
        return this.structureCheck_EM(this.NA_TOP, 2, this.height + 1, 0) && this.casingAmount >= 7;
    }

    public final boolean addAcceleratorAndSensor(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof NeutronAccelerator) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mNeutronAccelerator.add((NeutronAccelerator)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof NeutronSensor) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mNeutronSensor.add((NeutronSensor)aMetaTileEntity);
        }
        return false;
    }

    public int maxNeutronKineticEnergy() {
        return 1200000000;
    }

    public int getCurrentNeutronKineticEnergy() {
        return this.eV;
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public boolean supportsVoidProtection() {
        return true;
    }

    public boolean protectsExcessItem() {
        return !this.eSafeVoid;
    }

    public boolean protectsExcessFluid() {
        return !this.eSafeVoid;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new NeutronActivator(this.mName);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        boolean anyWorking = false;
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.eV > 0 && (aTick % 20L == 0L || this.eV > this.mCeil)) {
                this.tryUseModerator();
            }
            for (NeutronAccelerator neutronAccelerator : this.mNeutronAccelerator) {
                if (!neutronAccelerator.getBaseMetaTileEntity().isActive() || this.getRepairStatus() != this.getIdealStatus()) continue;
                anyWorking = true;
                this.eV = (int)((double)this.eV + Math.max((double)((this.R.nextInt(neutronAccelerator.getMaxEUConsume() + 1) + neutronAccelerator.getMaxEUConsume()) * 10) * Math.pow(0.95, this.height - 4), 10.0));
            }
            if (!anyWorking) {
                if (this.eV >= 72000 && aTick % 20L == 0L) {
                    this.eV -= 72000;
                } else if (this.eV > 0 && aTick % 20L == 0L) {
                    this.eV = 0;
                }
            }
            if (this.eV < 0) {
                this.eV = 0;
            }
            if (this.eV > this.maxNeutronKineticEnergy()) {
                this.doExplosion(128L);
            }
            for (NeutronSensor neutronSensor : this.mNeutronSensor) {
                neutronSensor.updateRedstoneOutput(this.eV);
            }
            if (this.mProgresstime < this.mMaxProgresstime && (this.eV > this.mCeil || this.eV < this.mFloor)) {
                this.mOutputFluids = null;
                this.mOutputItems = new ItemStack[]{ItemRefer.Radioactive_Waste.get(4)};
            }
        }
    }

    private void tryUseModerator() {
        this.startRecipeProcessing();
        for (ItemStack input : this.getStoredInputs()) {
            if (!input.func_77969_a(Materials.Graphite.getDust(1)) && !input.func_77969_a(Materials.Beryllium.getDust(1))) continue;
            int consume = Math.min(this.eV / 10000000, input.field_77994_a);
            this.depleteInput(GT_Utility.copyAmount((int)consume, (ItemStack)input));
            this.eV -= 10000000 * consume;
        }
        this.endRecipeProcessing();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int heights;
        this.structureBuild_EM(this.NA_BOTTOM, 2, 0, 0, stackSize, hintsOnly);
        this.structureBuild_EM(this.NA_TOP, 2, heights + 1, 0, stackSize, hintsOnly);
        for (heights = stackSize.field_77994_a + 3; heights > 0; --heights) {
            this.structureBuild_EM(this.NA_MID, 2, heights, 0, stackSize, hintsOnly);
        }
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return DescTextLocalization.addText("NeutronActivator.hint", 7);
    }

    public String[] getInfoData() {
        int currentNKEInput = 0;
        boolean anyWorking = false;
        for (NeutronAccelerator tHatch : this.mNeutronAccelerator) {
            if (!tHatch.getBaseMetaTileEntity().isActive()) continue;
            currentNKEInput = (int)((double)currentNKEInput + (double)((this.R.nextInt(tHatch.getMaxEUConsume() + 1) + tHatch.getMaxEUConsume()) * 10) * Math.pow(0.95, this.height - 4));
            anyWorking = true;
        }
        if (!anyWorking) {
            currentNKEInput = -72000;
        }
        return new String[]{"Progress:", EnumChatFormatting.GREEN + Integer.toString(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + this.mMaxProgresstime / 20 + EnumChatFormatting.RESET + " s", "Current Neutron Kinetic Energy Input: " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)currentNKEInput) + EnumChatFormatting.RESET + "eV", StatCollector.func_74838_a((String)"scanner.info.NA") + " " + EnumChatFormatting.LIGHT_PURPLE + GT_Utility.formatNumbers((long)this.getCurrentNeutronKineticEnergy()) + EnumChatFormatting.RESET + "eV"};
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.of((IIconContainer)textureFontOn), TextureFactory.builder().addIcon(new IIconContainer[]{textureFontOn_Glow}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49), TextureFactory.of((IIconContainer)textureFontOff), TextureFactory.builder().addIcon(new IIconContainer[]{textureFontOff_Glow}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)49)};
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = this.survivialBuildPiece(this.NA_BOTTOM, stackSize, 2, 0, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        int heights = stackSize.field_77994_a + 3;
        for (int i = 1; i <= heights; ++i) {
            built = this.survivialBuildPiece(this.NA_MID, stackSize, 2, i, 0, elementBudget, env, false, true);
            if (built < 0) continue;
            return built;
        }
        return this.survivialBuildPiece(this.NA_TOP, stackSize, 2, heights + 1, 0, elementBudget, env, false, true);
    }

    protected void onCasingFound() {
        ++this.casingAmount;
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)screenElements.widget((Widget)new TextWidget(StatCollector.func_74838_a((String)"gui.NeutronActivator.0")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget(new TextWidget().setStringSupplier(() -> numberFormat.formatWithSuffix((long)this.eV) + "eV").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.eV, val -> {
            this.eV = val;
        }));
    }

    private static enum NeutronHatchElement implements IHatchElement<NeutronActivator>
    {
        NeutronSensor(NeutronActivator::addAcceleratorAndSensor, new Class[]{NeutronSensor.class}){

            public long count(NeutronActivator t) {
                return t.mNeutronSensor.size();
            }
        }
        ,
        NeutronAccelerator(NeutronActivator::addAcceleratorAndSensor, new Class[]{NeutronAccelerator.class}){

            public long count(NeutronActivator t) {
                return t.mNeutronAccelerator.size();
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGT_HatchAdder<NeutronActivator> adder;

        @SafeVarargs
        private NeutronHatchElement(IGT_HatchAdder<NeutronActivator> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
            this.adder = adder;
        }

        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        public IGT_HatchAdder<? super NeutronActivator> adder() {
            return this.adder;
        }
    }
}

