/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.relauncherstub;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import me.eigenraven.lwjgl3ify.relauncherstub.GraphicalConsole;

public class RelauncherStubMain {
    public void run(String[] args) throws Throwable {
        if (args.length < 4) {
            System.err.println("Missing arguments");
            return;
        }
        long parentPid = Long.parseLong(args[0]);
        boolean showConsole = Boolean.parseBoolean(args[1]);
        String[] javaCmdline = Arrays.copyOfRange(args, 2, args.length);
        ProcessHandle myProcess = ProcessHandle.current();
        ProcessHandle parentProcess = ProcessHandle.of(parentPid).orElse(myProcess.parent().orElse(null));
        System.out.println("quit");
        if (parentProcess != null) {
            parentProcess.onExit().get();
        } else {
            Thread.sleep(1000L);
        }
        ProcessBuilder childBuilder = new ProcessBuilder(javaCmdline);
        if (showConsole) {
            childBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE);
            childBuilder.redirectError(ProcessBuilder.Redirect.PIPE);
            Process child = childBuilder.start();
            new GraphicalConsole(child.getInputStream(), child.getErrorStream(), child);
        } else {
            childBuilder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
            childBuilder.redirectError(ProcessBuilder.Redirect.DISCARD);
            childBuilder.start();
        }
    }

    public static void main(String[] args) throws Throwable {
        try {
            new RelauncherStubMain().run(args);
        }
        catch (Throwable e) {
            StringWriter traceWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(traceWriter));
            SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(null, e.toString() + "\n" + traceWriter.toString(), "Relauncher crash", 0));
        }
    }
}

