/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.research;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import minetweaker.IUndoableAction;
import modtweaker2.helpers.LogHelper;
import org.apache.commons.lang3.ArrayUtils;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;

public class OrphanResearch
implements IUndoableAction {
    String key;
    private final Set<String> children = new HashSet<String>();
    private final Set<String> secretChildren = new HashSet<String>();
    private final Set<String> siblings = new HashSet<String>();

    public OrphanResearch(String victim) {
        this.key = victim;
    }

    private void remove(String cur, String[] refs, Set<String> set, Consumer<String[]> consumer) {
        if (refs == null) {
            return;
        }
        for (int i = 0; i < refs.length; ++i) {
            if (refs[i] == null || !refs[i].equals(this.key)) continue;
            set.add(cur);
            consumer.accept((String[])ArrayUtils.remove((Object[])refs, (int)i));
            return;
        }
    }

    private void add(Set<String> set, Function<ResearchItem, String[]> function, BiConsumer<ResearchItem, String[]> consumer) {
        for (String research : set) {
            ResearchItem researchItem = ResearchCategories.getResearch((String)research);
            if (researchItem == null) {
                LogHelper.logWarning("Missing research: " + research);
                continue;
            }
            consumer.accept(researchItem, (String[])ArrayUtils.add((Object[])function.apply(researchItem), (Object)this.key));
        }
    }

    public void apply() {
        for (ResearchCategoryList category : ResearchCategories.researchCategories.values()) {
            for (Map.Entry entry : category.research.entrySet()) {
                String research = (String)entry.getKey();
                ResearchItem researchItem = (ResearchItem)entry.getValue();
                this.remove(research, researchItem.parents, this.children, arg_0 -> ((ResearchItem)researchItem).setParents(arg_0));
                this.remove(research, researchItem.parentsHidden, this.secretChildren, arg_0 -> ((ResearchItem)researchItem).setParentsHidden(arg_0));
                this.remove(research, researchItem.siblings, this.siblings, arg_0 -> ((ResearchItem)researchItem).setSiblings(arg_0));
            }
        }
    }

    public String describe() {
        return "Orphaning Research: " + this.key;
    }

    public boolean canUndo() {
        return this.children.size() > 0 || this.secretChildren.size() > 0 || this.siblings.size() > 0;
    }

    public void undo() {
        this.add(this.children, r -> r.parents, ResearchItem::setParents);
        this.add(this.secretChildren, r -> r.parentsHidden, ResearchItem::setParentsHidden);
        this.add(this.siblings, r -> r.siblings, ResearchItem::setSiblings);
    }

    public String describeUndo() {
        return "Reattaching Research: " + this.key;
    }

    public String getOverrideKey() {
        return null;
    }
}

