/*
 * Decompiled with CFR 0.152.
 */
package com.matthewprenger.helpfixer;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandHelp;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

@Mod(modid="HelpFixer", name="HelpFixer", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.7.10]", version="1.2.0")
public class HelpFixer {
    public static final String MOD_ID = "HelpFixer";
    private static final ICommand testCmd1 = new CommandBase(){

        public String func_71517_b() {
            return "a";
        }

        public String func_71518_a(ICommandSender sender) {
            return null;
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
        }
    };
    private static final ICommand testCmd2 = new CommandBase(){

        public String func_71517_b() {
            return "z";
        }

        public String func_71518_a(ICommandSender sender) {
            return null;
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
        }
    };

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHelp(){

            protected List<ICommand> func_71534_d(ICommandSender sender) {
                List list = MinecraftServer.func_71276_C().func_71187_D().func_71557_a(sender);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ICommand command = (ICommand)iterator.next();
                    if (command.func_71517_b() == null) {
                        FMLLog.warning((String)String.format("[HelpFixer] Identified command with null name, Ignoring: %s", command.getClass().getName()), (Object[])new Object[0]);
                        iterator.remove();
                        continue;
                    }
                    if (command.func_71518_a(sender) != null) continue;
                    FMLLog.warning((String)String.format("[HelpFixer] Identified command with null usage, Ignoring: %s", command.getClass().getName()), (Object[])new Object[0]);
                    iterator.remove();
                }
                Collections.sort(list, new Comparator<ICommand>(){

                    @Override
                    public int compare(ICommand o1, ICommand o2) {
                        return o1.func_71517_b().compareTo(o2.func_71517_b());
                    }
                });
                return list;
            }
        });
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        Collection commands = MinecraftServer.func_71276_C().func_71187_D().func_71555_a().values();
        for (ICommand command : commands) {
            if (HelpFixer.validCompareTo(command)) continue;
            FMLLog.warning((String)String.format("[HelpFixer] Command %s incorrectly overrides compareTo: %s", command.func_71517_b(), command.getClass().getName()), (Object[])new Object[0]);
        }
    }

    public static boolean validCompareTo(@Nonnull ICommand command) {
        return command.compareTo((Object)testCmd1) != command.compareTo((Object)testCmd2);
    }
}

