/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.client;

import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.SearchField;
import codechicken.nei.api.ItemFilter;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.holoInventory.Config;
import net.dries007.holoInventory.HoloInventory;
import net.dries007.holoInventory.api.IHoloGlasses;
import net.dries007.holoInventory.client.GroupRenderer;
import net.dries007.holoInventory.items.HoloGlasses;
import net.dries007.holoInventory.network.EntityRequestMessage;
import net.dries007.holoInventory.util.Coord;
import net.dries007.holoInventory.util.Helper;
import net.dries007.holoInventory.util.NamedData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.lwjgl.opengl.GL11;

public class Renderer {
    public static final HashMap<Integer, NamedData<ItemStack[]>> tileInventoryMap = new HashMap();
    public static final HashMap<Integer, List<FluidTankInfo>> tileFluidHandlerMap = new HashMap();
    public static final HashMap<Integer, NamedData<ItemStack[]>> entityMap = new HashMap();
    public static final HashMap<Integer, NamedData<MerchantRecipeList>> merchantMap = new HashMap();
    public static final HashMap<Integer, Long> requestMap = new HashMap();
    private Coord coord;
    public boolean enabled = true;
    private static double renderPosX;
    private static double renderPosY;
    private static double renderPosZ;
    public static final Renderer INSTANCE;
    private final GroupRenderer itemGroupRenderer = new GroupRenderer();
    private final GroupRenderer fluidGroupRenderer = new GroupRenderer();
    ItemFilter cachedFilter = null;
    String cachedSearch = "";
    private boolean fancyGraphics;

    @SubscribeEvent
    public void optifineIsAnnoying(RenderWorldLastEvent event) {
        this.fancyGraphics = Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    @SubscribeEvent
    public void renderEvent(RenderGameOverlayEvent event) {
        if (!this.enabled || event.type != RenderGameOverlayEvent.ElementType.HELMET) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        ItemStack glasses = HoloGlasses.getHoloGlasses((World)world, (EntityPlayer)player);
        try {
            if (!Config.requireGlasses || glasses != null && ((IHoloGlasses)glasses.func_77973_b()).shouldRender(glasses)) {
                this.doEvent(event.partialTicks);
            }
        }
        catch (Exception e) {
            HoloInventory.getLogger().warn("Some error while rendering the hologram :(");
            HoloInventory.getLogger().warn("Please make an issue on github if this happens");
            e.printStackTrace();
        }
    }

    private void doEvent(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71446_o == null || RenderManager.field_78727_a == null || RenderManager.field_78727_a.func_78716_a() == null || mc.field_71474_y.field_74320_O != 0 || mc.field_71476_x == null) {
            return;
        }
        if (FMLClientHandler.instance().hasOptifine()) {
            Minecraft.func_71410_x().field_71474_y.field_74347_j = this.fancyGraphics;
        }
        this.coord = new Coord(mc.field_71441_e.field_73011_w.field_76574_g, mc.field_71476_x);
        this.itemGroupRenderer.reset();
        this.fluidGroupRenderer.reset();
        GroupRenderer.updateTime();
        switch (mc.field_71476_x.field_72313_a) {
            case BLOCK: {
                TileEntity te = mc.field_71441_e.func_147438_o((int)this.coord.x, (int)this.coord.y, (int)this.coord.z);
                if (Helper.weWant(te) || te instanceof IFluidHandler) {
                    List<FluidTankInfo> fluidTankInfos;
                    String clazz = te.getClass().getCanonicalName();
                    if (Config.bannedTiles.contains(clazz)) {
                        return;
                    }
                    NamedData<ItemStack[]> invData = tileInventoryMap.get(this.coord.hashCode());
                    if (invData != null && invData.clazz != null && !invData.clazz.equals(clazz)) {
                        invData = null;
                        tileInventoryMap.remove(this.coord.hashCode());
                    }
                    if ((fluidTankInfos = tileFluidHandlerMap.get(this.coord.hashCode())) != null && !(te instanceof IFluidHandler)) {
                        fluidTankInfos = null;
                        tileFluidHandlerMap.remove(this.coord.hashCode());
                    }
                    this.coord.x += 0.5;
                    this.coord.y += 0.5;
                    this.coord.z += 0.5;
                    Renderer.setRenderPos(partialTicks);
                    this.renderHologram(invData, fluidTankInfos);
                    break;
                }
                tileInventoryMap.remove(this.coord.hashCode());
                break;
            }
            case ENTITY: {
                Entity entity;
                if (!Config.enableEntities || !Helper.weWant(entity = mc.field_71476_x.field_72308_g)) break;
                if (Config.bannedEntities.contains(entity.getClass().getCanonicalName())) {
                    return;
                }
                int id = entity.func_145782_y();
                if (!requestMap.containsKey(id)) {
                    HoloInventory.getSnw().sendToServer((IMessage)new EntityRequestMessage(mc.field_71441_e.field_73011_w.field_76574_g, id));
                    requestMap.put(id, mc.field_71441_e.func_82737_E());
                } else if (mc.field_71441_e.func_82737_E() > requestMap.get(id) + 20L * (long)Config.syncFreq) {
                    requestMap.remove(id);
                }
                Renderer.setRenderPos(partialTicks);
                if (entity instanceof IInventory && entityMap.containsKey(id)) {
                    this.renderHologram(entityMap.get(id));
                }
                if (!(entity instanceof IMerchant) || !merchantMap.containsKey(id)) break;
                this.renderMerchant(merchantMap.get(id));
                break;
            }
        }
        if (FMLClientHandler.instance().hasOptifine()) {
            Minecraft.func_71410_x().field_71474_y.field_74347_j = false;
        }
    }

    private void renderMerchant(NamedData<MerchantRecipeList> namedData) {
        this.coord.y += 2.0;
        if (((MerchantRecipeList)namedData.data).size() == 0) {
            return;
        }
        double distance = this.distance();
        if (distance < 1.0) {
            return;
        }
        GL11.glPushMatrix();
        this.moveAndRotate(-0.25);
        double uiScaleFactor = Config.renderScaling;
        if (uiScaleFactor < 0.1) {
            uiScaleFactor = 0.1;
        }
        GL11.glScaled((double)uiScaleFactor, (double)uiScaleFactor, (double)uiScaleFactor);
        this.itemGroupRenderer.calculateColumns(3);
        this.itemGroupRenderer.setRows(((MerchantRecipeList)namedData.data).size() - 1);
        this.itemGroupRenderer.setScale((float)((double)0.1f * distance));
        this.itemGroupRenderer.setSpacing(0.6f);
        this.itemGroupRenderer.setRenderText(true);
        if (Config.colorEnable) {
            GroupRenderer.renderBG(this.itemGroupRenderer);
        }
        if (Config.renderName) {
            GroupRenderer.renderName(namedData.name, this.itemGroupRenderer);
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int row = 0; row < ((MerchantRecipeList)namedData.data).size(); ++row) {
            MerchantRecipe recipe = (MerchantRecipe)((MerchantRecipeList)namedData.data).get(row);
            stacks.add(recipe.func_77394_a());
            if (recipe.func_77398_c()) {
                stacks.add(recipe.func_77396_b());
            } else {
                stacks.add(null);
            }
            stacks.add(recipe.func_77397_d());
        }
        this.itemGroupRenderer.renderItems(stacks);
        GL11.glPopMatrix();
    }

    private ItemFilter getFilter(String s_filter) {
        this.cachedSearch = s_filter;
        LinkedList<ItemFilter> primary = new LinkedList<ItemFilter>();
        LinkedList secondary = new LinkedList();
        for (SearchField.ISearchProvider p : SearchField.searchProviders) {
            ItemFilter filter = p.getFilter(s_filter);
            if (filter == null) continue;
            (p.isPrimary() ? primary : secondary).add(filter);
        }
        if (!primary.isEmpty()) {
            return new ItemList.AnyMultiItemFilter(primary);
        }
        if (!secondary.isEmpty()) {
            return new ItemList.AnyMultiItemFilter(secondary);
        }
        return new ItemList.EverythingItemFilter();
    }

    private List<ItemStack> filterByNEI(NamedData<ItemStack[]> namedData) {
        if (namedData == null || namedData.isInvalid()) {
            return Collections.emptyList();
        }
        ItemStack[] items = (ItemStack[])namedData.data;
        try {
            if (Config.hideItemsNotSelected && Loader.isModLoaded((String)"NotEnoughItems") && SearchField.searchInventories()) {
                String searchString = NEIClientConfig.getSearchExpression().toLowerCase();
                if (!this.cachedSearch.equals(searchString) || this.cachedFilter == null) {
                    this.cachedFilter = this.getFilter(searchString);
                }
                return Arrays.stream(items).filter(s -> this.cachedFilter.matches(s)).collect(Collectors.toList());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return Arrays.asList(items);
    }

    private void renderHologram(NamedData<ItemStack[]> namedData) {
        this.renderHologram(namedData, null);
    }

    private void renderHologram(@Nullable NamedData<ItemStack[]> namedData, @Nullable List<FluidTankInfo> fluidTankInfos) {
        double distance = this.distance();
        if (distance < 1.5) {
            return;
        }
        List<ItemStack> list = this.filterByNEI(namedData);
        int wantedSize = list.size();
        switch (Config.mode) {
            case 2: {
                wantedSize = 1;
                break;
            }
            case 3: {
                wantedSize = 3;
                break;
            }
            case 4: {
                wantedSize = 5;
                break;
            }
            case 5: {
                wantedSize = 7;
                break;
            }
            case 6: {
                wantedSize = 9;
            }
        }
        if (Config.mode != 0) {
            list.sort(Comparator.comparingInt(s -> s.field_77994_a).reversed());
            if (list.size() > wantedSize) {
                list = list.subList(0, wantedSize);
            }
        }
        if (Config.cycle != 0) {
            int i = (int)(Minecraft.func_71410_x().field_71441_e.func_82737_E() / (long)Config.cycle % (long)list.size());
            list = Collections.singletonList(list.get(i));
        }
        this.doRenderHologram(namedData != null ? namedData.name : null, list, fluidTankInfos != null ? fluidTankInfos : Collections.emptyList(), distance);
    }

    private void doRenderHologram(@Nullable String name, @Nonnull List<ItemStack> itemStacks, @Nonnull List<FluidTankInfo> fluidTankInfos, double distance) {
        if (itemStacks.isEmpty() && fluidTankInfos.isEmpty()) {
            return;
        }
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadMatrix((FloatBuffer)ActiveRenderInfo.field_74595_k);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadMatrix((FloatBuffer)ActiveRenderInfo.field_74594_j);
        this.moveAndRotate(-1.0);
        double uiScaleFactor = Config.renderScaling;
        if (uiScaleFactor < 0.1) {
            uiScaleFactor = 0.1;
        }
        GL11.glScaled((double)uiScaleFactor, (double)uiScaleFactor, (double)uiScaleFactor);
        this.preRenderHologramItems(itemStacks, distance);
        this.preRenderHologramFluids(fluidTankInfos, distance);
        this.itemGroupRenderer.setOffset(this.fluidGroupRenderer.calculateOffset());
        if (Config.colorEnable) {
            ArrayList<GroupRenderer> list = new ArrayList<GroupRenderer>();
            if (!itemStacks.isEmpty()) {
                list.add(this.itemGroupRenderer);
            }
            if (!fluidTankInfos.isEmpty()) {
                list.add(this.fluidGroupRenderer);
            }
            GroupRenderer.renderBG(list.toArray(new GroupRenderer[0]));
        }
        if (Config.renderName && name != null) {
            GroupRenderer.renderName(name, this.itemGroupRenderer, this.fluidGroupRenderer);
        }
        this.renderHologramItems(itemStacks);
        this.renderHologramFluids(fluidTankInfos);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glEnable((int)3042);
    }

    private void preRenderHologramItems(List<ItemStack> itemStacks, double distance) {
        if (itemStacks.isEmpty()) {
            return;
        }
        float stackSpacing = 0.6f;
        if (Config.renderText) {
            for (ItemStack stack : itemStacks) {
                if (stack.field_77994_a < 1000 && GroupRenderer.stackSizeDebugOverride < 1000) continue;
                stackSpacing = 0.8f;
                break;
            }
        }
        this.itemGroupRenderer.calculateColumns(itemStacks.size());
        this.itemGroupRenderer.calculateRows(itemStacks.size());
        this.itemGroupRenderer.setScale((float)((double)0.05f * distance));
        this.itemGroupRenderer.setSpacing(stackSpacing);
        this.itemGroupRenderer.setRenderText(Config.renderText);
    }

    private void renderHologramItems(List<ItemStack> itemStacks) {
        if (itemStacks.isEmpty()) {
            return;
        }
        this.itemGroupRenderer.renderItems(itemStacks);
    }

    private void preRenderHologramFluids(List<FluidTankInfo> fluidTankInfos, double distance) {
        if (fluidTankInfos.isEmpty()) {
            return;
        }
        float spacing = 0.6f;
        if (Config.renderText) {
            for (FluidTankInfo fluidTankInfo : fluidTankInfos) {
                if (fluidTankInfo.fluid.amount < 1000) continue;
                spacing = 0.8f;
                break;
            }
        }
        this.fluidGroupRenderer.calculateColumns(fluidTankInfos.size());
        this.fluidGroupRenderer.calculateRows(fluidTankInfos.size());
        this.fluidGroupRenderer.setScale((float)((double)0.05f * distance));
        this.fluidGroupRenderer.setSpacing(spacing);
        this.fluidGroupRenderer.setRenderText(Config.renderText);
    }

    private void renderHologramFluids(List<FluidTankInfo> fluidTankInfos) {
        if (fluidTankInfos.isEmpty()) {
            return;
        }
        this.fluidGroupRenderer.renderFluids(fluidTankInfos);
    }

    private void moveAndRotate(double depth) {
        GL11.glTranslated((double)(this.coord.x - renderPosX), (double)(this.coord.y - renderPosY), (double)(this.coord.z - renderPosZ));
        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)0.5f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)depth);
    }

    private static void setRenderPos(float partialTicks) {
        EntityClientPlayerMP thePlayer = Minecraft.func_71410_x().field_71439_g;
        double lastTickPosX = thePlayer.field_70142_S;
        double posX = thePlayer.field_70165_t;
        renderPosX = lastTickPosX + (posX - lastTickPosX) * (double)partialTicks;
        renderPosY = thePlayer.field_70137_T + (thePlayer.field_70163_u - thePlayer.field_70137_T) * (double)partialTicks;
        renderPosZ = thePlayer.field_70136_U + (thePlayer.field_70161_v - thePlayer.field_70136_U) * (double)partialTicks;
    }

    private double distance() {
        double dx = this.coord.x - renderPosX;
        double dy = this.coord.y - renderPosY;
        double dz = this.coord.z - renderPosZ;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    static {
        INSTANCE = new Renderer();
    }
}

