/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.rfb.transformers;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import java.util.ArrayList;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ForgePatchTransformer
implements RfbClassTransformer {
    final Logger logger = LogManager.getLogger((String)"Lwjgl3ifyForgePatches");
    public static final String TRACING_PRINT_STREAM = "cpw.mods.fml.common.TracingPrintStream";
    public static final String FML_SECURITY_MANAGER = "cpw.mods.fml.relauncher.FMLSecurityManager";
    public static final String ENUM_HELPER = "net.minecraftforge.common.util.EnumHelper";
    public static final String[] PATCHED_CLASSES = new String[]{"cpw.mods.fml.common.TracingPrintStream", "cpw.mods.fml.relauncher.FMLSecurityManager", "net.minecraftforge.common.util.EnumHelper"};

    @NotNull
    public String id() {
        return "forge-patch";
    }

    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        for (String toPatch : PATCHED_CLASSES) {
            if (!toPatch.equals(className)) continue;
            return true;
        }
        return false;
    }

    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        if (!classNode.isPresent()) {
            return;
        }
        switch (className) {
            case "cpw.mods.fml.common.TracingPrintStream": {
                this.tfTracingPrintStream(classNode);
                break;
            }
            case "cpw.mods.fml.relauncher.FMLSecurityManager": {
                this.tfFmlSecurityManager(classNode);
                break;
            }
            case "net.minecraftforge.common.util.EnumHelper": {
                this.tfEnumHelper(classNode);
            }
        }
    }

    private void tfTracingPrintStream(@NotNull ClassNodeHandle handle) {
        ClassNode node = handle.getNode();
        if (node == null || node.methods == null) {
            this.logger.error("Tracing print stream missing class data");
            return;
        }
        if (node.methods.stream().anyMatch(m -> "close".equals(m.name) && "()V".equals(m.desc))) {
            this.logger.warn("{} already has a close method", new Object[]{TRACING_PRINT_STREAM});
            return;
        }
        MethodVisitor mv = node.visitMethod(1, "close", "()V", null, null);
        mv.visitInsn(177);
        mv.visitMaxs(0, 1);
        mv.visitEnd();
    }

    private static Integer tryIconst(AbstractInsnNode i) {
        Integer n;
        switch (i.getOpcode()) {
            case 3: {
                n = 0;
                break;
            }
            case 4: {
                n = 1;
                break;
            }
            case 5: {
                n = 2;
                break;
            }
            case 6: {
                n = 3;
                break;
            }
            case 7: {
                n = 4;
                break;
            }
            case 8: {
                n = 5;
                break;
            }
            case 2: {
                n = -1;
                break;
            }
            case 18: {
                Object cst = ((LdcInsnNode)i).cst;
                if (cst instanceof Integer) {
                    n = (Integer)cst;
                    break;
                }
                n = null;
                break;
            }
            default: {
                n = null;
            }
        }
        return n;
    }

    private static AbstractInsnNode makeIconst(int i) {
        AbstractInsnNode abstractInsnNode;
        switch (i) {
            case 0: {
                abstractInsnNode = new InsnNode(3);
                break;
            }
            case 1: {
                abstractInsnNode = new InsnNode(4);
                break;
            }
            case 2: {
                abstractInsnNode = new InsnNode(5);
                break;
            }
            case 3: {
                abstractInsnNode = new InsnNode(6);
                break;
            }
            case 4: {
                abstractInsnNode = new InsnNode(7);
                break;
            }
            case 5: {
                abstractInsnNode = new InsnNode(8);
                break;
            }
            case -1: {
                abstractInsnNode = new InsnNode(2);
                break;
            }
            default: {
                abstractInsnNode = new LdcInsnNode((Object)i);
            }
        }
        return abstractInsnNode;
    }

    private void tfFmlSecurityManager(@NotNull ClassNodeHandle handle) {
        ClassNode node = handle.getNode();
        if (node == null || node.methods == null) {
            this.logger.error("FML security manager missing class data");
            return;
        }
        MethodNode checkPermission = node.methods.stream().filter(m -> "checkPermission".equals(m.name) && "(Ljava/security/Permission;)V".equals(m.desc)).findFirst().orElse(null);
        if (checkPermission == null || checkPermission.instructions == null || checkPermission.instructions.size() < 5) {
            this.logger.error("FML security manager missing the checkPermission method");
            return;
        }
        InsnList chkInsns = checkPermission.instructions;
        int insns = chkInsns.size();
        int matches = 0;
        for (int i = 0; i < insns - 4; ++i) {
            AbstractInsnNode i_iconstA = chkInsns.get(i);
            AbstractInsnNode i_icmple = chkInsns.get(i + 1);
            AbstractInsnNode i_iconstAp1 = chkInsns.get(i + 3);
            if (i_icmple.getOpcode() != 164) continue;
            Integer A = ForgePatchTransformer.tryIconst(i_iconstA);
            Integer Ap1 = ForgePatchTransformer.tryIconst(i_iconstAp1);
            if (A == null || Ap1 == null || Ap1 != A + 1) continue;
            ++matches;
            chkInsns.set(i_iconstA, ForgePatchTransformer.makeIconst(A + 1));
        }
        if (matches < 2) {
            this.logger.warn("Only found {}<2 instances of AIOOB fixes in FMLSecurityManager", new Object[]{matches});
        }
    }

    private void tfEnumHelper(@NotNull ClassNodeHandle handle) {
        ClassNode node = handle.getNode();
        if (node == null || node.methods == null) {
            this.logger.error("Enum Helper missing class data");
            return;
        }
        String INTERNAL_TARGET = "me/eigenraven/lwjgl3ify/EnumHelper";
        ArrayList<MethodNode> newMethods = new ArrayList<MethodNode>();
        for (MethodNode oldMethod : node.methods) {
            boolean isStatic;
            if (oldMethod.instructions == null || "<clinit>".equals(oldMethod.name)) {
                newMethods.add(oldMethod);
                continue;
            }
            Type desc = Type.getMethodType(oldMethod.desc);
            boolean bl = isStatic = (oldMethod.access & 8) != 0;
            if (!isStatic) {
                newMethods.add(oldMethod);
                continue;
            }
            MethodNode newMethod = new MethodNode(oldMethod.access, oldMethod.name, oldMethod.desc, oldMethod.signature, null);
            InsnList insns = newMethod.instructions;
            insns.clear();
            InstructionAdapter ihelp = new InstructionAdapter(newMethod);
            Type[] args = desc.getArgumentTypes();
            for (int i = 0; i < args.length; ++i) {
                ihelp.load(i, args[i]);
            }
            ihelp.invokestatic("me/eigenraven/lwjgl3ify/EnumHelper", newMethod.name, newMethod.desc, false);
            ihelp.areturn(desc.getReturnType());
            ihelp.visitMaxs(args.length, args.length);
            ihelp.visitEnd();
            newMethods.add(newMethod);
        }
        node.methods = newMethods;
    }
}

