/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import me.eigenraven.lwjgl3ify.CommonProxy;
import me.eigenraven.lwjgl3ify.api.InputEvents;
import me.eigenraven.lwjgl3ify.client.GLDebugLog;
import me.eigenraven.lwjgl3ify.core.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.Version;
import org.lwjglx.input.Keyboard;

public class ClientProxy
extends CommonProxy {
    static final String javaVersion;
    static final String lwjglVersion;

    @Override
    public void runCompatHooks() {
        super.runCompatHooks();
        if (Config.DEBUG_REGISTER_OPENGL_LOGGER) {
            GLDebugLog.setupDebugMessageCallback();
        }
        Keyboard.populateKeyLookupTables();
        this.registerKeybindHandler();
    }

    private void registerKeybindHandler() {
        InputEvents.addKeyboardListener(new McKeybindHandler());
    }

    @Override
    public void registerF3Handler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderGameOverlayTextEvent(RenderGameOverlayEvent.Text event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P && event.type == RenderGameOverlayEvent.ElementType.TEXT) {
            if (Config.SHOW_LWJGL_VERSION) {
                event.right.add(Math.min(3, event.right.size()), lwjglVersion);
            }
            if (Config.SHOW_JAVA_VERSION) {
                event.right.add(Math.min(3, event.right.size()), javaVersion);
            }
        }
    }

    static {
        lwjglVersion = "LWJGL: " + Version.getVersion();
        String javaVersionRaw = "Java: " + System.getProperty("java.version");
        if (javaVersionRaw.length() > 32) {
            javaVersionRaw = javaVersionRaw.substring(0, 29) + "...";
        }
        javaVersion = javaVersionRaw;
    }

    private static final class McKeybindHandler
    implements InputEvents.KeyboardListener {
        private McKeybindHandler() {
        }

        @Override
        public void onKeyEvent(InputEvents.KeyEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null) {
                return;
            }
            if (mc.field_71462_r != null) {
                return;
            }
            if (event.lwjgl2KeyCode > 0) {
                KeyBinding.func_74510_a((int)event.lwjgl2KeyCode, (event.action != InputEvents.KeyAction.RELEASED ? 1 : 0) != 0);
            }
        }
    }
}

