/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabframe;

import com.github.weisj.darklaf.components.border.MutableLineBorder;
import com.github.weisj.darklaf.components.tabframe.JTabFrame;
import com.github.weisj.darklaf.components.tabframe.PanelPopup;
import com.github.weisj.darklaf.components.tabframe.PopupContainer;
import com.github.weisj.darklaf.components.tabframe.TabFramePopupUI;
import com.github.weisj.darklaf.components.uiresource.JLabelUIResource;
import com.github.weisj.darklaf.components.uiresource.JPanelUIResource;
import com.github.weisj.darklaf.focus.FocusParentHelper;
import com.github.weisj.darklaf.ui.panel.DarkPanelUI;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.Actions;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class DarkPanelPopupUI
extends DarkPanelUI
implements PropertyChangeListener,
TabFramePopupUI {
    protected HeaderButton closeButton;
    private final Action closeAction = Actions.create(e -> this.closeButton.doClick());
    protected JPanel content;
    protected JLabel label;
    protected JComponent customButtonArea;
    protected Color headerFocusBackground;
    protected Color headerButtonFocusHoverBackground;
    protected Color headerButtonFocusClickBackground;
    protected Color headerBackground;
    protected Color headerButtonHoverBackground;
    protected Color headerButtonClickBackground;
    protected KeyStroke closeAccelerator;
    private PanelPopup popupComponent;
    private JPanel header;
    private MutableLineBorder headerBorder;
    private MutableLineBorder contentBorder;
    private boolean oldFocus;

    public static ComponentUI createUI(JComponent c) {
        return new DarkPanelPopupUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.popupComponent = (PanelPopup)c;
        super.installUI(c);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.updateBorder(false);
    }

    protected void installDefaults() {
        this.headerBackground = UIManager.getColor("TabFramePopup.headerBackground");
        this.headerButtonHoverBackground = UIManager.getColor("TabFramePopup.headerButtonHoverBackground");
        this.headerButtonClickBackground = UIManager.getColor("TabFramePopup.headerButtonClickBackground");
        this.headerFocusBackground = UIManager.getColor("TabFramePopup.headerFocusBackground");
        this.headerButtonFocusHoverBackground = UIManager.getColor("TabFramePopup.headerButtonFocusHoverBackground");
        this.headerButtonFocusClickBackground = UIManager.getColor("TabFramePopup.headerButtonFocusClickBackground");
        this.closeAccelerator = KeyStroke.getKeyStroke(UIManager.getString("TabFramePopup.closeAccelerator"));
        this.popupComponent.getInputMap(1).put(this.closeAccelerator, "close");
        this.popupComponent.getActionMap().put("close", this.closeAction);
        this.popupComponent.setLayout(new BorderLayout());
    }

    protected void installComponents() {
        this.closeButton = this.createCloseButton();
        this.label = this.createLabel();
        this.customButtonArea = this.createCustomButtonArea();
        this.header = this.createHeader();
        JPanel headerContainer = new JPanel(new BorderLayout());
        this.setHeaderBackground(false);
        headerContainer.add((Component)this.header, "Center");
        headerContainer.setMinimumSize(UIManager.getDimension("TabFramePopup.minimumHeaderSize"));
        this.content = new JPanel(new BorderLayout());
        this.content.add(this.popupComponent.getContentPane(), "Center");
        this.popupComponent.setLayout(new BorderLayout());
        this.popupComponent.add((Component)headerContainer, "North");
        this.popupComponent.add((Component)this.content, "Center");
        this.headerBorder = this.createBorder();
        this.contentBorder = this.createBorder();
        headerContainer.setBorder(this.headerBorder);
        this.content.setBorder(this.contentBorder);
    }

    protected JComponent createCustomButtonArea() {
        JPanelUIResource buttonHolder = new JPanelUIResource();
        buttonHolder.setLayout(new BoxLayout(buttonHolder, 0));
        buttonHolder.setOpaque(false);
        buttonHolder.setBorder(BorderFactory.createEmptyBorder());
        return buttonHolder;
    }

    protected void installListeners() {
        this.popupComponent.addPropertyChangeListener(this);
        this.installFocusListener();
        JTabFrame frame = this.popupComponent.getTabFrame();
        if (frame != null) {
            frame.addPropertyChangeListener(this);
        }
    }

    protected void installFocusListener() {
        JTabFrame tabFrame = this.popupComponent.getTabFrame();
        Alignment a = this.popupComponent.getAlignment();
        if (tabFrame == null || a == null) {
            return;
        }
        PopupContainer container = tabFrame.getContentPane().getContainer(a);
        FocusParentHelper.setFocusParent(this.popupComponent, container, c -> {
            if (!this.popupComponent.isOpen()) {
                return;
            }
            this.setHeaderBackground(DarkUIUtil.hasFocus(this.popupComponent));
        });
    }

    @Override
    public AbstractButton addButton(Icon icon, String tooltipText) {
        HeaderButton button = new HeaderButton(icon, this);
        button.setToolTipText(tooltipText);
        this.customButtonArea.add(button);
        return button;
    }

    @Override
    public void removeButton(AbstractButton button) {
        this.customButtonArea.remove(button);
    }

    protected HeaderButton createCloseButton() {
        HeaderButton closeButton = new HeaderButton(UIManager.getIcon("TabFramePopup.close.icon"), this);
        closeButton.addActionListener(e -> this.popupComponent.close());
        String tooltip = UIManager.getString((Object)"Actions.close", this.popupComponent.getLocale());
        tooltip = tooltip + " (" + UIManager.getString("TabFramePopup.closeTooltipTextHint") + ")";
        closeButton.setToolTipText(tooltip);
        return closeButton;
    }

    protected JLabel createLabel() {
        JLabelUIResource label = new JLabelUIResource(this.popupComponent.getTitle(), this.popupComponent.getIcon(), 2);
        label.setOpaque(false);
        return label;
    }

    protected JPanel createHeader() {
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 0));
        header.add(Box.createHorizontalStrut(5));
        header.add(this.label);
        header.add(Box.createGlue());
        header.add(this.customButtonArea);
        header.add(this.closeButton);
        header.add(Box.createHorizontalStrut(1));
        header.setBorder(UIManager.getBorder("TabFramePopup.headerBorder"));
        return header;
    }

    protected void setHeaderBackground(boolean focus) {
        this.closeButton.setFocus(focus);
        if (this.header != null) {
            this.header.setBackground(focus ? this.headerFocusBackground : this.headerBackground);
        }
        for (Component customButton : this.customButtonArea.getComponents()) {
            if (!(customButton instanceof HeaderButton)) continue;
            ((HeaderButton)customButton).setFocus(focus);
        }
        if (this.oldFocus != focus) {
            if (this.header != null) {
                this.header.repaint();
            }
            this.closeButton.repaint();
            this.oldFocus = focus;
        }
    }

    protected MutableLineBorder createBorder() {
        Color color = UIManager.getColor("TabFramePopup.borderColor");
        return new MutableLineBorder(0, 0, 0, 0, color);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallComponents();
        this.uninstallListeners();
        this.popupComponent.removeAll();
        this.popupComponent.getInputMap(1).remove(this.closeAccelerator);
        this.popupComponent.getActionMap().remove("close");
        this.popupComponent = null;
    }

    protected void uninstallComponents() {
        this.popupComponent.removeAll();
    }

    protected void uninstallListeners() {
        this.popupComponent.removePropertyChangeListener(this);
        JTabFrame frame = this.popupComponent.getTabFrame();
        if (frame != null) {
            frame.removePropertyChangeListener(this);
        }
    }

    @Override
    public final Dimension getPreferredSize(JComponent c) {
        if (!c.isEnabled()) {
            return new Dimension(0, 0);
        }
        return super.getPreferredSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!c.isEnabled()) {
            return new Dimension(0, 0);
        }
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        if (!c.isEnabled()) {
            return new Dimension(0, 0);
        }
        return super.getMaximumSize(c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("open".equals(key)) {
            this.setHeaderBackground(Boolean.TRUE.equals(evt.getNewValue()));
        } else if ("content".equals(key)) {
            if (this.content == null) {
                return;
            }
            this.content.add((Component)evt.getNewValue(), "Center");
            this.content.invalidate();
        } else if ("title".equals(key)) {
            if (this.label == null) {
                return;
            }
            this.label.setText(evt.getNewValue().toString());
            this.label.repaint();
        } else if ("icon".equals(key)) {
            if (this.label == null) {
                return;
            }
            this.label.setIcon((Icon)evt.getNewValue());
            this.label.repaint();
        } else if ("visibleTab".equals(key)) {
            if (evt.getNewValue() instanceof JTabFrame.TabFramePosition && ((JTabFrame.TabFramePosition)evt.getNewValue()).getAlignment() == this.popupComponent.getAlignment()) {
                this.updateBorder(true);
            }
        } else if ("tabFrame".equals(key)) {
            Object oldVal = evt.getOldValue();
            Object newVal = evt.getNewValue();
            if (oldVal instanceof JTabFrame) {
                ((JTabFrame)oldVal).removePropertyChangeListener(this);
            }
            if (newVal instanceof JTabFrame) {
                ((JTabFrame)newVal).addPropertyChangeListener(this);
            }
            this.installFocusListener();
        } else if ("peerInsets".equals(key)) {
            this.updateBorder(false);
        } else if ("alignment".equals(key)) {
            this.installFocusListener();
        }
    }

    protected void updateBorder(boolean notifyPeer) {
        if (this.popupComponent.getTabFrame() != null) {
            Container headerParent;
            JTabFrame tabFrame = this.popupComponent.getTabFrame();
            boolean[] status = tabFrame.getContentPane().getStatus();
            Alignment alignment = this.popupComponent.getAlignment();
            Insets insets = this.getBorderSize(tabFrame, alignment, status);
            this.applyBorderInsets(insets);
            Component component = this.popupComponent.getComponent();
            this.popupComponent.doLayout();
            this.popupComponent.repaint();
            if (component != null && component != this.popupComponent) {
                component.doLayout();
                component.repaint();
            }
            if (this.header != null && (headerParent = this.header.getParent()) != null) {
                ((Component)headerParent).doLayout();
                headerParent.repaint();
            }
            if (notifyPeer) {
                try {
                    Component peer = tabFrame.getPopupComponentAt(tabFrame.getPeer(this.popupComponent.getAlignment()));
                    peer.firePropertyChange("peerInsets", 0L, 1L);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    protected Insets getBorderSize(JTabFrame tabFrame, Alignment a, boolean[] info) {
        Insets insets = new Insets(0, 0, 0, 0);
        switch (a) {
            case NORTH: 
            case NORTH_EAST: {
                if (info[a.getIndex()] || info[tabFrame.getPeer(a).getIndex()]) {
                    insets.bottom = 1;
                }
                if (info[Alignment.NORTH.getIndex()] && a == Alignment.NORTH_EAST) {
                    insets.left = 1;
                }
                return insets;
            }
            case SOUTH: 
            case SOUTH_WEST: {
                if (info[a.getIndex()] || info[tabFrame.getPeer(a).getIndex()]) {
                    insets.top = 1;
                }
                if (info[Alignment.SOUTH_WEST.getIndex()] && a == Alignment.SOUTH) {
                    insets.left = 1;
                }
                return insets;
            }
            case EAST: 
            case SOUTH_EAST: {
                if (info[a.getIndex()] || info[tabFrame.getPeer(a).getIndex()]) {
                    insets.left = 1;
                }
                if (info[Alignment.EAST.getIndex()] && a == Alignment.SOUTH_EAST) {
                    insets.top = 1;
                }
                return insets;
            }
            case WEST: 
            case NORTH_WEST: {
                if (info[a.getIndex()] || info[tabFrame.getPeer(a).getIndex()]) {
                    insets.right = 1;
                }
                if (info[Alignment.NORTH_WEST.getIndex()] && a == Alignment.WEST) {
                    insets.top = 1;
                }
                return insets;
            }
        }
        return insets;
    }

    protected void applyBorderInsets(Insets insets) {
        this.headerBorder.setInsets(insets.top, insets.left, 1, insets.right);
        this.contentBorder.setInsets(0, insets.left, insets.bottom, insets.right);
    }

    protected boolean hasFocus() {
        return this.oldFocus;
    }

    protected static final class HeaderButton
    extends JButton
    implements UIResource {
        private final DarkPanelPopupUI popupUI;

        public HeaderButton(Icon icon, DarkPanelPopupUI popupUI) {
            super(icon);
            this.popupUI = popupUI;
            this.setName("headerButton");
            this.putClientProperty("JButton.square", true);
            this.putClientProperty("JButton.thin", true);
            this.putClientProperty("JButton.variant", "borderless");
            this.putClientProperty("JToolTip.style", "balloon");
            this.setRolloverEnabled(true);
            Insets ins = UIManager.getInsets("TabFramePopup.headerButton.insets");
            this.setMargin(new Insets(ins.top, ins.left, ins.bottom, ins.right));
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.setFocus(false);
            this.setFocusable(false);
            this.setOpaque(false);
        }

        public void setFocus(boolean focus) {
            this.putClientProperty("JButton.borderless.hover", focus ? this.popupUI.headerButtonFocusHoverBackground : this.popupUI.headerButtonHoverBackground);
            this.putClientProperty("JButton.borderless.click", focus ? this.popupUI.headerButtonFocusClickBackground : this.popupUI.headerButtonClickBackground);
        }
    }
}

