/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.splitpane;

public enum DividerStyle {
    GRIP("grip", false, true),
    GRIP_BORDERLESS("gripBorderless", false, false),
    LINE("line", true, true),
    INVISIBLE("invisible", true, false);

    private final String name;
    private final boolean isThin;
    private final boolean paintBorder;

    private DividerStyle(String name, boolean isThin, boolean paintBorder) {
        this.name = name;
        this.isThin = isThin;
        this.paintBorder = paintBorder;
    }

    public static DividerStyle get(Object style) {
        return DividerStyle.get(style, GRIP);
    }

    public static DividerStyle get(Object style, DividerStyle fallback) {
        DividerStyle s = DividerStyle.getNullableStyle(style);
        if (s == null) {
            return fallback;
        }
        return s;
    }

    public boolean isPaintBorder() {
        return this.paintBorder;
    }

    public boolean isThin() {
        return this.isThin;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    static DividerStyle getNullableStyle(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof DividerStyle) {
            return (DividerStyle)((Object)obj);
        }
        try {
            return DividerStyle.valueOf(obj.toString());
        }
        catch (IllegalArgumentException ignored) {
            for (DividerStyle s : DividerStyle.values()) {
                if (!s.name.equalsIgnoreCase(obj.toString())) continue;
                return s;
            }
            return null;
        }
    }
}

