/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.icons;

import com.github.weisj.darklaf.properties.icons.AwareIconStyle;
import com.github.weisj.darklaf.properties.icons.CustomThemedIcon;
import com.github.weisj.darklaf.properties.icons.DarkSVGIcon;
import com.github.weisj.darklaf.properties.icons.DarkUIAwareIcon;
import com.github.weisj.darklaf.properties.icons.DerivableIcon;
import com.github.weisj.darklaf.properties.icons.DerivableImageIcon;
import com.github.weisj.darklaf.properties.icons.IconResolver;
import com.github.weisj.darklaf.properties.icons.IconSupplier;
import com.github.weisj.darklaf.properties.icons.IconUtil;
import com.github.weisj.darklaf.properties.icons.LazyImageIconSupplier;
import com.github.weisj.darklaf.properties.icons.LazyUIAwareIcon;
import com.github.weisj.darklaf.properties.icons.SimpleUIAwareIcon;
import com.github.weisj.darklaf.properties.icons.ThemedSVGIcon;
import com.github.weisj.darklaf.properties.icons.UIAwareIcon;
import com.github.weisj.darklaf.util.LazyValue;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.cache.SoftCache;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.awt.Image;
import java.awt.Window;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconLoader
implements IconResolver {
    private static final Logger LOGGER = LogUtil.getLogger(IconLoader.class);
    private static final Map<Class<?>, IconLoader> iconLoaderMap = new HashMap();
    private static final LazyValue<IconLoader> instance = new LazyValue<IconLoader>(() -> IconLoader.get(null));
    private static final AtomicReference<Object> currentThemeKey = new AtomicReference<Object>(null);
    private static final AtomicReference<AwareIconStyle> currentAwareStyle = new AtomicReference<Object>(null);
    private static final SVGLoader loader;
    private static final int DEFAULT_WIDTH_SVG = -1;
    private static final int DEFAULT_HEIGHT_SVG = -1;
    @Nullable
    private final Class<?> parentClass;
    private boolean cacheEnabled = true;
    private final SoftCache<IconKey, DarkUIAwareIcon> awareIconCache = new SoftCache();
    private final SoftCache<IconKey, CacheableIcon> iconCache = new SoftCache();

    @NotNull
    static SVGLoader svgLoader() {
        if (SwingUtilities.isEventDispatchThread()) {
            return loader;
        }
        return new SVGLoader();
    }

    public int cacheSize() {
        return this.awareIconCache.size() + this.iconCache.size();
    }

    public boolean isCacheEmpty() {
        return this.awareIconCache.isEmpty() && this.iconCache.isEmpty();
    }

    private IconLoader(@Nullable Class<?> parentClass) {
        this.parentClass = parentClass;
        iconLoaderMap.put(parentClass, this);
    }

    @NotNull
    public static IconLoader get() {
        return instance.get();
    }

    @NotNull
    public static IconLoader get(@Nullable Class<?> parentClass) {
        if (iconLoaderMap.containsKey(parentClass)) {
            return iconLoaderMap.get(parentClass);
        }
        IconLoader loader = new IconLoader(parentClass);
        iconLoaderMap.put(parentClass, loader);
        return loader;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        if (!cacheEnabled) {
            this.clearCache();
        }
    }

    public void clearCache() {
        this.awareIconCache.clear();
        this.iconCache.clear();
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public static void updateAwareStyle(AwareIconStyle style) {
        currentAwareStyle.set(style);
    }

    public static void updateThemeStatus(Object theme) {
        currentThemeKey.set(theme);
    }

    public static void reloadFrameIcons() {
        IconUtil.reloadDynamicFrameIcons();
    }

    public static AwareIconStyle getAwareStyle() {
        return currentAwareStyle.get();
    }

    public static Object getThemeStatus() {
        return currentThemeKey.get();
    }

    @Override
    @NotNull
    public DarkUIAwareIcon getUIAwareIcon(@NotNull String path) {
        return this.getUIAwareIcon(path, this.getDefaultWidth(path), this.getDefaultHeight(path));
    }

    @Override
    @NotNull
    public DarkUIAwareIcon getUIAwareIcon(@NotNull String path, int w, int h) {
        DarkUIAwareIcon icon;
        IconKey key = new IconKey(path, w, h);
        if (!this.isCacheEnabled() || (icon = this.awareIconCache.get(key)) == null) {
            icon = this.createUIAwareIcon(path, w, h);
            this.cache(this.awareIconCache, key, icon);
        }
        return icon;
    }

    @NotNull
    public UIAwareIcon createUIAwareIcon(IconSupplier<Icon> lightIconSupplier, IconSupplier<Icon> darkIconSupplier) {
        return new LazyUIAwareIcon(lightIconSupplier, darkIconSupplier);
    }

    @NotNull
    public UIAwareIcon createUIAwareIcon(Icon light, Icon dark) {
        return new SimpleUIAwareIcon(light, dark);
    }

    @NotNull
    private DarkUIAwareIcon createUIAwareIcon(@NotNull String name, int w, int h) {
        return new DarkUIAwareIcon("dark/" + name, "light/" + name, w, h, this.parentClass);
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull String path) {
        return this.getIcon(path, this.getDefaultWidth(path), this.getDefaultHeight(path));
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull String path, boolean themed) {
        return this.getIcon(path, this.getDefaultWidth(path), this.getDefaultHeight(path), themed);
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull String path, int w, int h) {
        return this.getIcon(path, w, h, false);
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull String path, int w, int h, boolean themed) {
        return this.getIconImpl(path, w, h, themed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Icon getIconImpl(@NotNull String path, int w, int h, boolean themed) {
        IconLoader iconLoader = this;
        synchronized (iconLoader) {
            CacheableIcon icon;
            IconKey key = new IconKey(path, w, h);
            if (this.isCacheEnabled()) {
                icon = this.iconCache.get(key);
                if (icon != null) {
                    return icon;
                }
                icon = this.awareIconCache.get(key);
                if (icon != null) {
                    return icon;
                }
                icon = this.getWildcardIcon(this.iconCache, key, w, h);
                if (icon != null) {
                    return icon;
                }
            }
            icon = this.isSVGIcon(path) ? this.loadSVGIconInternal(path, w, h, themed, null) : new DerivableImageIcon(new LazyImageIconSupplier(path, key, this.parentClass), w, h);
            this.cache(this.iconCache, key, icon);
            return icon;
        }
    }

    @Nullable
    private CacheableIcon getWildcardIcon(SoftCache<IconKey, CacheableIcon> iconMap, IconKey iconKey, int w, int h) {
        iconKey.isWildcardEnabled = true;
        CacheableIcon icon = iconMap.get(iconKey);
        if (icon instanceof DerivableIcon) {
            CacheableIcon derived = (CacheableIcon)((DerivableIcon)((Object)icon)).derive(w, h);
            iconKey.isWildcardEnabled = false;
            this.cache(iconMap, iconKey, derived);
            return derived;
        }
        iconKey.isWildcardEnabled = false;
        return null;
    }

    private <T extends CacheableIcon> void cache(SoftCache<IconKey, T> iconMap, IconKey key, T icon) {
        if (this.cacheEnabled) {
            iconMap.put(key, icon);
        }
    }

    @NotNull
    public Icon loadSVGIcon(@NotNull String path, boolean themed) {
        return this.loadSVGIcon(path, -1, -1, themed);
    }

    @NotNull
    public Icon loadSVGIcon(@NotNull String path, int w, int h, boolean themed) {
        return this.loadSVGIcon(path, w, h, themed, null);
    }

    @NotNull
    public Icon loadSVGIcon(@NotNull String path, int w, int h, boolean themed, Map<Object, Object> propertyMap) {
        return this.loadSVGIconInternal(path, w, h, themed, propertyMap);
    }

    private CacheableIcon loadSVGIconInternal(String path, int w, int h, boolean themed, Map<Object, Object> propertyMap) {
        URI uri = this.createURI(path);
        DarkSVGIcon svgIcon = themed ? (propertyMap != null ? new CustomThemedIcon(uri, w, h, propertyMap) : new ThemedSVGIcon(uri, w, h)) : new DarkSVGIcon(uri, w, h);
        return svgIcon;
    }

    @NotNull
    private URI createURI(String path) {
        try {
            return Objects.requireNonNull(this.getResource(path), path).toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    ImageIcon createImageIcon(@NotNull String path, String description) {
        URL imgURL = this.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        LOGGER.severe("Could not find icon file: '" + path + "'");
        return null;
    }

    @Contract(value="null,_ -> null")
    public static Image createFrameIcon(@Nullable Icon icon, Window window) {
        return IconUtil.createFrameIcon(icon, window);
    }

    @NotNull
    public static Icon createDerivedIcon(@NotNull Icon icon, int w, int h) {
        return IconUtil.createDerivedIcon(icon, w, h);
    }

    private URL getResource(String name) {
        if (this.parentClass != null) {
            return this.parentClass.getResource(name);
        }
        return this.getClass().getClassLoader().getResource(name);
    }

    private int getDefaultWidth(String path) {
        if (!this.isSVGIcon(path)) {
            return -1;
        }
        return -1;
    }

    private int getDefaultHeight(String path) {
        if (!this.isSVGIcon(path)) {
            return -1;
        }
        return -1;
    }

    private boolean isSVGIcon(String path) {
        return path != null && path.endsWith(".svg");
    }

    static {
        UIManager.addPropertyChangeListener(e -> {
            if (UIManager.getLookAndFeel().getID().equalsIgnoreCase("darklaf")) {
                return;
            }
            String key = e.getPropertyName();
            if ("lookAndFeel".equals(key)) {
                IconLoader.updateThemeStatus(new Object());
            }
        });
        loader = new SVGLoader();
    }

    static final class IconKey {
        final String path;
        int w;
        int h;
        boolean isWildcardEnabled;

        private IconKey(String path, int w, int h) {
            this.path = path;
            this.w = w;
            this.h = h;
        }

        public int hashCode() {
            return Objects.hashCode(this.path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IconKey iconKey = (IconKey)o;
            if (iconKey.isWildcardEnabled || this.isWildcardEnabled) {
                return Objects.equals(this.path, iconKey.path);
            }
            if (this.w != iconKey.w) {
                return false;
            }
            if (this.h != iconKey.h) {
                return false;
            }
            return Objects.equals(this.path, iconKey.path);
        }

        public String toString() {
            return "[path=" + this.path + ", w=" + this.w + ", h=" + this.h + "]";
        }
    }

    public static interface CacheableIcon
    extends Icon,
    SoftCache.Cacheable<IconKey> {
    }
}

