/*
 * Decompiled with CFR 0.152.
 */
package bloodasp.galacticgreg.bartworks;

import bloodasp.galacticgreg.GT_TileEntity_Ores_Space;
import bloodasp.galacticgreg.GalacticGreg;
import bloodasp.galacticgreg.api.Enums;
import bloodasp.galacticgreg.api.ModDBMDef;
import bloodasp.galacticgreg.api.ModDimensionDef;
import bloodasp.galacticgreg.dynconfig.DynamicOreMixWorldConfig;
import bloodasp.galacticgreg.registry.GalacticGregRegistry;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedOreTE;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_Ores;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_SmallOres;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.oregen.BW_OreLayer;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.world.GT_Worldgen;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class BW_Worldgen_Ore_SmallOre_Space
extends BW_OreLayer {
    private ModDimensionDef pDimensionDef;
    private DynamicOreMixWorldConfig _mDynWorldConfig;
    private String name;

    public BW_Worldgen_Ore_SmallOre_Space(String aName, boolean pDefault, int pMinY, int pMaxY, int pDensity, int pPrimary, ISubTagContainer primaryBW) {
        super(aName, pDefault, 0, 0, 0, 0, 0, primaryBW, (ISubTagContainer)Materials._NULL, (ISubTagContainer)Materials._NULL, (ISubTagContainer)Materials._NULL);
        this.mMinY = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen.GaGregBartworks." + this.mWorldGenName), "MinHeight", pMinY);
        this.mMaxY = (short)Math.max(this.mMinY + 1, GregTech_API.sWorldgenFile.get((Object)("worldgen.GaGregBartworks." + this.mWorldGenName), "MaxHeight", pMaxY));
        this.mDensity = (short)Math.max(1, GregTech_API.sWorldgenFile.get((Object)("worldgen.GaGregBartworks." + this.mWorldGenName), "Amount", pDensity));
        this.mPrimaryMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen.GaGregBartworks." + this.mWorldGenName), "Meta", pPrimary);
        this.bwOres = (byte)GregTech_API.sWorldgenFile.get((Object)("worldgen.GaGregBartworks." + this.mWorldGenName), "BWGTlogic", (int)this.bwOres);
        this._mDynWorldConfig = new DynamicOreMixWorldConfig(this.mWorldGenName, true);
        this._mDynWorldConfig.InitDynamicConfig();
        StringBuilder ret = new StringBuilder();
        for (Map.Entry key : this._mDynWorldConfig.get_mDynWorldConfigMap().entrySet().stream().filter(Map.Entry::getValue).collect(Collectors.toSet())) {
            ret.append(((String)key.getKey()).split("_")[1]).append("; ");
        }
        String string = this.name = ret.length() == 0 ? "" : ret.substring(0, ret.length() - 1);
        if (this.mEnabled) {
            GalacticGreg.smallOreWorldgenList.add((GT_Worldgen)this);
        }
    }

    public BW_Worldgen_Ore_SmallOre_Space(String aName, boolean enabled) {
        this(aName, enabled, 0, 0, 0, 0, (ISubTagContainer)(enabled ? Werkstoff.default_null_Werkstoff : Materials._NULL));
    }

    public boolean isEnabledForDim(ModDimensionDef pDimensionDef) {
        return this._mDynWorldConfig.isEnabledInDim(pDimensionDef);
    }

    public boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        ModDimensionDef tMDD = GalacticGregRegistry.getDimensionTypeByChunkGenerator(aChunkGenerator);
        if (tMDD == null) {
            return false;
        }
        this.pDimensionDef = tMDD;
        if (this.mPrimaryMeta > 0) {
            int j = Math.max(1, this.mDensity / 2 + aRandom.nextInt(this.mDensity) / 2);
            for (int i = 0; i < j; ++i) {
                this.setOreBlock(aWorld, aChunkX + aRandom.nextInt(16), this.mMinY + aRandom.nextInt(Math.max(1, this.mMaxY - this.mMinY)), aChunkZ + aRandom.nextInt(16), this.mPrimaryMeta, true);
            }
        }
        return true;
    }

    public boolean setOreBlock(World aWorld, int aX, int aY, int aZ, int aMetaData, boolean isSmallOre) {
        TileEntity te = aWorld.func_147438_o(aX, aY, aZ);
        if (!(te instanceof BW_MetaGeneratedOreTE) && !(te instanceof GT_TileEntity_Ores)) {
            if (aMetaData == this.mSporadicMeta && (this.bwOres & 1) != 0 || aMetaData == this.mBetweenMeta && (this.bwOres & 2) != 0 || aMetaData == this.mPrimaryMeta && (this.bwOres & 8) != 0 || aMetaData == this.mSecondaryMeta && (this.bwOres & 4) != 0) {
                for (ModDBMDef e : this.pDimensionDef.getReplaceableBlocks()) {
                    boolean wasSet = isSmallOre ? BW_MetaGenerated_SmallOres.setOreBlock((World)aWorld, (int)aX, (int)aY, (int)aZ, (int)aMetaData, (this.pDimensionDef.getAirSetting() == Enums.AirReplaceRule.AllowReplaceAir ? 1 : 0) != 0, (Block)((Block)Block.field_149771_c.func_82594_a(e.getBlockName())), (int[])new int[]{e.getMeta()}) : BW_MetaGenerated_Ores.setOreBlock((World)aWorld, (int)aX, (int)aY, (int)aZ, (int)aMetaData, (this.pDimensionDef.getAirSetting() == Enums.AirReplaceRule.AllowReplaceAir ? 1 : 0) != 0, (Block)((Block)Block.field_149771_c.func_82594_a(e.getBlockName())), (int[])new int[]{e.getMeta()});
                    if (!wasSet) continue;
                    return true;
                }
                return false;
            }
            return GT_TileEntity_Ores_Space.setOuterSpaceOreBlock(this.pDimensionDef, aWorld, aX, aY, aZ, aMetaData, this.pDimensionDef.getAirSetting() == Enums.AirReplaceRule.AllowReplaceAir);
        }
        return true;
    }

    public Block getDefaultBlockToReplace() {
        return null;
    }

    public int[] getDefaultDamageToReplace() {
        return null;
    }

    public String getDimName() {
        return this.name;
    }
}

