/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.modules.findRecipes;

import java.util.Iterator;
import java.util.LinkedList;
import net.glease.tc4tweak.ConfigurationHandler;
import net.glease.tc4tweak.modules.FlushableCache;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import thaumcraft.api.crafting.IArcaneRecipe;

class ArcaneCraftingHistory
extends FlushableCache<ThreadLocal<LinkedList<IArcaneRecipe>>> {
    ArcaneCraftingHistory() {
    }

    @Override
    protected ThreadLocal<LinkedList<IArcaneRecipe>> createCache() {
        return ThreadLocal.withInitial(LinkedList::new);
    }

    IArcaneRecipe findInCache(IInventory inv, EntityPlayer player) {
        if (this.isEnabled()) {
            LinkedList history = (LinkedList)((ThreadLocal)this.getCache()).get();
            Iterator iterator = history.iterator();
            while (iterator.hasNext()) {
                IArcaneRecipe recipe = (IArcaneRecipe)iterator.next();
                if (!recipe.matches(inv, player.field_70170_p, player)) continue;
                iterator.remove();
                history.addFirst(recipe);
                return recipe;
            }
        }
        return null;
    }

    void addToCache(IArcaneRecipe r) {
        if (this.isEnabled()) {
            LinkedList history = (LinkedList)((ThreadLocal)this.getCache()).get();
            history.addFirst(r);
            if (history.size() > ConfigurationHandler.INSTANCE.getArcaneCraftingHistorySize()) {
                history.removeLast();
            }
        }
    }
}

