/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.minefactoryreloaded;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import cofh.lib.util.WeightedRandomItemStack;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.tile.machine.TileEntitySludgeBoiler;
import tonius.neiintegration.PositionedFluidTank;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerSludgeBoiler
extends RecipeHandlerBase {
    private static List<WeightedRandom.Item> drops;
    private static int totalWeight;
    private static int sludgePerOperation;
    private static int energyPerOperation;

    @Override
    public void prepare() {
        drops = MFRRegistry.getSludgeDrops();
        for (WeightedRandom.Item drop : drops) {
            totalWeight += drop.field_76292_a;
        }
        TileEntitySludgeBoiler dummy = new TileEntitySludgeBoiler();
        sludgePerOperation = dummy.getWorkMax() * 10;
        energyPerOperation = dummy.getActivationEnergy() * dummy.getWorkMax();
        dummy = null;
    }

    public String getRecipeName() {
        return Utils.translate("tile.mfr.machine.sludgeboiler.name", false);
    }

    @Override
    public String getRecipeID() {
        return "minefactoryreloaded.sludgeboiler";
    }

    public String getGuiTexture() {
        return "minefactoryreloaded:textures/gui/sludgeboiler.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(76, 25, 22, 15);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)11, (int)13, (int)160, (int)65);
        this.changeToOverlayTexture();
        GuiDraw.drawTexturedModalRect((int)76, (int)25, (int)0, (int)15, (int)22, (int)15);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(129, 0, 176, 58, 8, 62, 1.0f, 3);
        this.drawProgressBar(139, 0, 185, 58, 8, 62, 40, 3);
        CachedSludgeBoilerRecipe crecipe = (CachedSludgeBoilerRecipe)((Object)this.arecipes.get(recipe));
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMaximumFractionDigits(2);
        GuiDraw.drawStringC((String)percentFormat.format(crecipe.chance), (int)57, (int)44, (int)0x808080, (boolean)false);
    }

    @Override
    public List<String> provideTooltip(GuiRecipe<?> guiRecipe, List<String> currenttip, RecipeHandlerBase.CachedBaseRecipe crecipe, Point relMouse) {
        super.provideTooltip(guiRecipe, currenttip, crecipe, relMouse);
        if (new Rectangle(129, 2, 8, 60).contains(relMouse)) {
            currenttip.add(energyPerOperation + " RF");
        }
        return currenttip;
    }

    @Override
    public void loadAllRecipes() {
        for (WeightedRandom.Item drop : drops) {
            if (!(drop instanceof WeightedRandomItemStack)) continue;
            this.arecipes.add(new CachedSludgeBoilerRecipe(((WeightedRandomItemStack)drop).getStack(), drop.field_76292_a));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (WeightedRandom.Item drop : drops) {
            if (!(drop instanceof WeightedRandomItemStack) || !Utils.areStacksSameTypeCraftingSafe(((WeightedRandomItemStack)drop).getStack(), result)) continue;
            this.arecipes.add(new CachedSludgeBoilerRecipe(result, drop.field_76292_a));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        if (ingredient.getFluid().getName().equals("sludge")) {
            this.loadAllRecipes();
        }
    }

    public class CachedSludgeBoilerRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedFluidTank sludgeInput;
        public PositionedStack output;
        public float chance;

        public CachedSludgeBoilerRecipe(ItemStack output, int weight) {
            this.sludgeInput = new PositionedFluidTank(FluidRegistry.getFluidStack((String)"sludge", (int)sludgePerOperation), 4000, new Rectangle(111, 2, 16, 60), RecipeHandlerSludgeBoiler.this.getGuiTexture(), new Point(176, 0));
            this.output = new PositionedStack((Object)output, 48, 24);
            this.chance = (float)weight / (float)totalWeight;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.sludgeInput;
        }
    }
}

