/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config.preset;

import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.ItemList;
import codechicken.nei.ItemSorter;
import codechicken.nei.ItemsGrid;
import codechicken.nei.Label;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.RestartableTask;
import codechicken.nei.api.ItemFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public abstract class PresetItemsGrid
extends ItemsGrid<PresetsGridSlot, ItemsGrid.MouseContext> {
    protected static final int BUTTON_SIZE = 16;
    public Button pagePrev;
    public Label pageLabel;
    public Button pageNext;
    protected ArrayList<ItemStack> newItems;
    protected List<PresetsGridSlot> gridMask;
    protected final RestartableTask updateFilter = new RestartableTask("NEI Presets Item Filtering"){

        @Override
        public void execute() {
            ArrayList filtered;
            ItemFilter filter = PresetItemsGrid.this.getFilter();
            try {
                filtered = (ArrayList)((ForkJoinTask)ItemList.forkJoinPool.submit(() -> ItemList.items.parallelStream().filter(filter::matches).collect(Collectors.toCollection(ArrayList::new)))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                filtered = new ArrayList();
                e.printStackTrace();
                this.stop();
            }
            if (this.interrupted()) {
                return;
            }
            ItemSorter.sort(filtered);
            if (this.interrupted()) {
                return;
            }
            PresetItemsGrid.this.updateItemList(filtered);
        }
    };

    protected PresetItemsGrid() {
        this.pageLabel = new Label("0/0", true);
        this.pagePrev = new Button("<"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    PresetItemsGrid.this.setPage(0);
                } else {
                    PresetItemsGrid.this.shiftPage(-1);
                }
                return true;
            }
        };
        this.pageNext = new Button(">"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    PresetItemsGrid.this.setPage(PresetItemsGrid.this.getNumPages() - 1);
                } else {
                    PresetItemsGrid.this.shiftPage(1);
                }
                return true;
            }
        };
    }

    protected String getLabelText() {
        return String.format("%d/%d", this.getPage(), Math.max(1, this.getNumPages()));
    }

    @Override
    public void setGridSize(int mleft, int mtop, int w, int h) {
        this.pageLabel.text = this.getLabelText();
        this.pageNext.w = 16;
        this.pagePrev.w = 16;
        this.pageNext.h = 16;
        this.pagePrev.h = 16;
        this.pagePrev.y = this.pageNext.y = mtop;
        this.pagePrev.x = mleft;
        this.pageNext.x = mleft + w - this.pageNext.w;
        this.pageLabel.x = mleft + w / 2;
        this.pageLabel.y = this.pagePrev.y + 5;
        super.setGridSize(mleft, mtop + 16 + 2, w, h - 16 - 4);
    }

    @Override
    public void draw(int mousex, int mousey) {
        this.pagePrev.draw(mousex, mousey);
        this.pageNext.draw(mousex, mousey);
        this.pageLabel.draw(mousex, mousey);
        super.draw(mousex, mousey);
    }

    public void mouseClicked(int x, int y, int button) {
        if (this.pagePrev.contains(x, y)) {
            this.pagePrev.handleClick(x, y, button);
        }
        if (this.pageNext.contains(x, y)) {
            this.pageNext.handleClick(x, y, button);
        }
    }

    public void restartFilter() {
        this.updateFilter.restart();
    }

    protected void updateItemList(List<ItemStack> newItems) {
        this.newItems = new ArrayList<ItemStack>(newItems);
    }

    @Override
    protected void onGridChanged() {
        this.gridMask = null;
        super.onGridChanged();
    }

    @Override
    public List<PresetsGridSlot> getMask() {
        if (this.gridMask == null) {
            this.gridMask = new ArrayList<PresetsGridSlot>();
            int itemIndex = this.page * this.perPage;
            for (int slotIndex = 0; slotIndex < this.rows * this.columns && itemIndex < this.size(); ++itemIndex, ++slotIndex) {
                this.gridMask.add(new PresetsGridSlot(slotIndex, itemIndex, this.getItem(itemIndex)));
            }
        }
        return this.gridMask;
    }

    @Override
    public void refresh(GuiContainer gui) {
        if (this.newItems != null) {
            this.realItems = this.newItems;
            this.newItems = null;
            this.onItemsChanged();
        }
        super.refresh(gui);
    }

    protected abstract boolean isSelected(ItemStack var1);

    protected abstract ItemFilter getFilter();

    public class PresetsGridSlot
    extends ItemsGrid.ItemsGridSlot {
        public PresetsGridSlot(int slotIndex, int itemIndex, ItemStack itemStack) {
            super(slotIndex, itemIndex, itemStack);
        }

        public void beforeDraw(Rectangle4i rect, ItemsGrid.MouseContext mouseContext) {
            if (mouseContext != null && mouseContext.slotIndex == this.slotIndex || PresetItemsGrid.this.isSelected(this.getItemStack())) {
                NEIClientUtils.drawRect(rect.x, rect.y, rect.w, rect.h, ItemsGrid.HIGHLIGHT_COLOR);
            }
        }
    }
}

