/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.AbstractSubpanel;
import codechicken.nei.FavoriteRecipes;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.ItemSorter;
import codechicken.nei.ItemStackAmount;
import codechicken.nei.ItemsGrid;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.AutoCraftingManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.ReadableNumberConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class ItemCraftablesPanel
extends AbstractSubpanel<ItemsGrid<CraftablesGridSlot, ItemsGrid.MouseContext>> {
    public static List<String> guiBlacklist = new ArrayList<String>();
    private final int MIN_DELAY = 600;
    private Map<String, ArrayList<ICraftingHandler>> identHandlers = new HashMap<String, ArrayList<ICraftingHandler>>();
    private Map<ItemStack, Recipe.RecipeId> availableRecipes = new HashMap<ItemStack, Recipe.RecipeId>();
    private GuiContainer lastGuiContainer = null;
    private ItemStackAmount lastPlayerInventory = null;
    private long lastPlayerInventorySync = 0L;
    private int lastFavoritesCount = 0;

    public ItemCraftablesPanel() {
        this.grid = new ItemsGrid<CraftablesGridSlot, ItemsGrid.MouseContext>(){
            protected List<CraftablesGridSlot> gridMask;

            @Override
            protected void onGridChanged() {
                this.gridMask = null;
                super.onGridChanged();
            }

            @Override
            public List<CraftablesGridSlot> getMask() {
                if (this.gridMask == null) {
                    int maxSlotIndex = this.rows * this.columns;
                    ArrayList<CraftablesGridSlot> gridMask = new ArrayList<CraftablesGridSlot>();
                    this.realItems.clear();
                    if (!ItemCraftablesPanel.this.availableRecipes.isEmpty()) {
                        List entries = ItemCraftablesPanel.this.availableRecipes.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(FavoriteRecipes::contains).reversed().thenComparing(ItemSorter.instance))).limit(maxSlotIndex).collect(Collectors.toList());
                        int slotIndex = 0;
                        int itemIndex = 0;
                        for (Map.Entry entry : entries) {
                            if (!this.isInvalidSlot(slotIndex)) {
                                this.realItems.add((ItemStack)entry.getKey());
                                gridMask.add(new CraftablesGridSlot(slotIndex, itemIndex++, (ItemStack)entry.getKey(), (Recipe.RecipeId)entry.getValue()));
                            }
                            if (slotIndex++ < maxSlotIndex) continue;
                            break;
                        }
                        this.gridMask = gridMask;
                    } else {
                        this.gridMask = Collections.emptyList();
                    }
                    ItemCraftablesPanel.this.updateLinePadding();
                }
                return this.gridMask;
            }

            @Override
            protected ItemsGrid.MouseContext getMouseContext(int mousex, int mousey) {
                Object hovered = this.getSlotMouseOver(mousex, mousey);
                if (hovered != null) {
                    return new ItemsGrid.MouseContext(((ItemsGrid.ItemsGridSlot)hovered).slotIndex, ((ItemsGrid.ItemsGridSlot)hovered).slotIndex / this.columns, ((ItemsGrid.ItemsGridSlot)hovered).slotIndex % this.columns);
                }
                return null;
            }
        };
    }

    @Override
    protected ItemStack getDraggedStackWithQuantity(ItemStack itemStack) {
        return ItemQuantityField.prepareStackWithQuantity(itemStack, StackInfo.getAmount(itemStack));
    }

    @Override
    public void draw(int mousex, int mousey) {
        if (!this.availableRecipes.isEmpty()) {
            super.draw(mousex, mousey);
        }
    }

    @Override
    public int setPanelWidth(int width) {
        if (this.getGuiContainer() != this.lastGuiContainer) {
            this.updateCraftables();
        }
        int columns = width / ItemsGrid.SLOT_SIZE;
        int useRows = NEIClientConfig.getIntSetting("inventory.craftables.useRows");
        int rows = (int)Math.min(Math.ceil((float)this.availableRecipes.size() * 1.0f / (float)columns), (double)useRows);
        this.w = width;
        this.h = 8 + ItemsGrid.SLOT_SIZE * Math.max(rows, 1);
        return rows;
    }

    @Override
    public void update() {
        this.splittingLineColor = NEIClientConfig.getSetting("inventory.craftables.color").getHexValue();
        this.updateCraftables();
        super.update();
    }

    private void updateCraftables() {
        if (!NEIClientConfig.showCraftablesPanelWidget()) {
            this.clearCraftables();
        } else if (this.lastPlayerInventory == null || Math.abs(System.currentTimeMillis() - this.lastPlayerInventorySync) >= 600L) {
            GuiContainer firstGui = this.getGuiContainer();
            this.lastPlayerInventorySync = System.currentTimeMillis();
            if (firstGui != null && !guiBlacklist.contains(firstGui.getClass().getName())) {
                boolean showOnlyFavorites = NEIClientConfig.getBooleanSetting("inventory.craftables.favoritesOnly");
                ItemStackAmount inv = AutoCraftingManager.getInventoryItems(firstGui);
                if (this.lastGuiContainer != firstGui || showOnlyFavorites && this.lastFavoritesCount != FavoriteRecipes.size() || !inv.equals(this.lastPlayerInventory)) {
                    this.lastPlayerInventory = inv;
                    this.lastGuiContainer = firstGui;
                    this.lastFavoritesCount = FavoriteRecipes.size();
                    this.availableRecipes = this.generateCraftables(firstGui);
                    this.grid.onGridChanged();
                }
            } else {
                this.clearCraftables();
            }
        }
    }

    private void clearCraftables() {
        if (!this.availableRecipes.isEmpty()) {
            this.availableRecipes = Collections.emptyMap();
            this.lastPlayerInventory = null;
            this.grid.onGridChanged();
        }
    }

    private GuiContainer getGuiContainer() {
        GuiContainer guiContainer;
        GuiContainer firstGui = NEIClientUtils.getGuiContainer();
        if (firstGui instanceof GuiRecipe) {
            GuiRecipe gui = (GuiRecipe)firstGui;
            guiContainer = gui.firstGui;
        } else {
            guiContainer = firstGui;
        }
        return guiContainer;
    }

    private Map<ItemStack, Recipe.RecipeId> generateCraftables(GuiContainer firstGui) {
        List<IRecipeHandler> availableHandlers = this.getAvailableHandlers(firstGui);
        HashMap<ItemStack, Recipe.RecipeId> availableRecipes = new HashMap<ItemStack, Recipe.RecipeId>();
        if (!availableHandlers.isEmpty()) {
            List<ItemStack> invStacks = this.lastPlayerInventory.values();
            for (IRecipeHandler handler : availableHandlers) {
                availableRecipes.putAll(this.filterHandlerRecipes(handler, firstGui, invStacks));
            }
        }
        return availableRecipes;
    }

    private List<IRecipeHandler> getAvailableHandlers(GuiContainer firstGui) {
        ArrayList<IRecipeHandler> availableHandlers = new ArrayList<IRecipeHandler>();
        for (String ident : RecipeInfo.getOverlayHandlerIdents(firstGui)) {
            availableHandlers.addAll(this.identHandlers.computeIfAbsent(ident, x$0 -> GuiCraftingRecipe.getCraftingHandlers(x$0, new Object[0])));
        }
        return availableHandlers;
    }

    private Map<ItemStack, Recipe.RecipeId> filterHandlerRecipes(IRecipeHandler handler, GuiContainer firstGui, List<ItemStack> invStacks) {
        HashMap<ItemStack, Recipe.RecipeId> availableRecipes = new HashMap<ItemStack, Recipe.RecipeId>();
        boolean showOnlyFavorites = NEIClientConfig.getBooleanSetting("inventory.craftables.favoritesOnly");
        IntStream.range(0, handler.numRecipes()).parallel().forEach(recipeIndex -> {
            Recipe recipe;
            if (!(!this.existsIngredients(firstGui, handler.getIngredientStacks(recipeIndex), invStacks) || (recipe = Recipe.of(handler, recipeIndex)).getResults().isEmpty() || showOnlyFavorites && FavoriteRecipes.getFavorite(recipe.getRecipeId()) == null)) {
                Map map = availableRecipes;
                synchronized (map) {
                    availableRecipes.put(recipe.getResult(), recipe.getRecipeId());
                }
            }
        });
        return availableRecipes;
    }

    private boolean existsIngredients(GuiContainer firstGui, List<PositionedStack> ingredients, List<ItemStack> invStacks) {
        HashMap<ItemStack, Integer> usedItems = new HashMap<ItemStack, Integer>();
        for (PositionedStack pStack : ingredients) {
            ItemStack used = invStacks.stream().filter(is -> usedItems.getOrDefault(is, is.field_77994_a) >= pStack.item.field_77994_a && pStack.contains((ItemStack)is)).findAny().orElse(null);
            if (used != null) {
                usedItems.put(used, usedItems.getOrDefault(used, used.field_77994_a) - pStack.item.field_77994_a);
                continue;
            }
            return false;
        }
        return !usedItems.isEmpty();
    }

    public static class CraftablesGridSlot
    extends ItemsGrid.ItemsGridSlot {
        protected final long realAmount;
        protected final boolean isFluidDisplay;
        protected final Recipe.RecipeId recipeId;

        public CraftablesGridSlot(int slotIndex, int itemIndex, ItemStack itemStack, Recipe.RecipeId recipeId) {
            super(slotIndex, itemIndex, itemStack);
            this.realAmount = StackInfo.getAmount(itemStack);
            this.isFluidDisplay = StackInfo.itemStackToNBT(itemStack).func_74764_b("gtFluidName");
            this.recipeId = recipeId;
        }

        @Override
        public Recipe.RecipeId getRecipeId() {
            return this.recipeId;
        }

        @Override
        public <M extends ItemsGrid.MouseContext> void afterDraw(Rectangle4i rect, M mouseContext) {
            this.drawStackSize(rect);
        }

        protected void drawStackSize(Rectangle4i rect) {
            long stackSize = this.realAmount;
            if (stackSize > 1L) {
                float panelFactor = (float)(rect.w - 2) / 16.0f;
                String amountString = "";
                amountString = stackSize < 10000L ? String.valueOf(stackSize) : ReadableNumberConverter.INSTANCE.toWideReadableForm(stackSize);
                if (this.isFluidDisplay) {
                    amountString = amountString + "L";
                }
                NEIClientUtils.drawNEIOverlayText(amountString, new Rectangle4i(rect.x + 1, rect.y + 1, rect.w - 2, rect.h - 2), panelFactor, 0xFFFFFF, true, this.isFluidDisplay ? NEIClientUtils.Alignment.BottomLeft : NEIClientUtils.Alignment.BottomRight);
            }
        }
    }
}

