/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import logisticspipes.LPConstants;
import logisticspipes.items.LogisticsItem;
import logisticspipes.pipes.upgrades.AdvancedSatelliteUpgrade;
import logisticspipes.pipes.upgrades.CCRemoteControlUpgrade;
import logisticspipes.pipes.upgrades.CombinedSneakyUpgrade;
import logisticspipes.pipes.upgrades.CraftingByproductUpgrade;
import logisticspipes.pipes.upgrades.CraftingCleanupUpgrade;
import logisticspipes.pipes.upgrades.CraftingMonitoringUpgrade;
import logisticspipes.pipes.upgrades.FluidCraftingUpgrade;
import logisticspipes.pipes.upgrades.FuzzyUpgrade;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.LogicControllerUpgrade;
import logisticspipes.pipes.upgrades.OpaqueUpgrade;
import logisticspipes.pipes.upgrades.PatternUpgrade;
import logisticspipes.pipes.upgrades.PowerTransportationUpgrade;
import logisticspipes.pipes.upgrades.SpeedUpgrade;
import logisticspipes.pipes.upgrades.UpgradeModuleUpgrade;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeDOWN;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeEAST;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeNORTH;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeSOUTH;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeUP;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeWEST;
import logisticspipes.pipes.upgrades.power.IC2EVPowerSupplierUpgrade;
import logisticspipes.pipes.upgrades.power.IC2HVPowerSupplierUpgrade;
import logisticspipes.pipes.upgrades.power.IC2LVPowerSupplierUpgrade;
import logisticspipes.pipes.upgrades.power.IC2MVPowerSupplierUpgrade;
import logisticspipes.pipes.upgrades.power.RFPowerSupplierUpgrade;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeDOWN;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeEAST;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeNORTH;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeSOUTH;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeUP;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeWEST;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.lwjgl.input.Keyboard;

public class ItemUpgrade
extends LogisticsItem {
    public static final int SNEAKY_UP = 0;
    public static final int SNEAKY_DOWN = 1;
    public static final int SNEAKY_NORTH = 2;
    public static final int SNEAKY_SOUTH = 3;
    public static final int SNEAKY_EAST = 4;
    public static final int SNEAKY_WEST = 5;
    public static final int SNEAKY_COMBINATION = 6;
    public static final int CONNECTION_UP = 10;
    public static final int CONNECTION_DOWN = 11;
    public static final int CONNECTION_NORTH = 12;
    public static final int CONNECTION_SOUTH = 13;
    public static final int CONNECTION_EAST = 14;
    public static final int CONNECTION_WEST = 15;
    public static final int SPEED = 20;
    public static final int ADVANCED_SAT_CRAFTINGPIPE = 21;
    public static final int LIQUID_CRAFTING = 22;
    public static final int CRAFTING_BYPRODUCT_EXTRACTOR = 23;
    public static final int SUPPLIER_PATTERN = 24;
    public static final int FUZZY_CRAFTING = 25;
    public static final int CRAFTING_CLEANUP = 26;
    public static final int POWER_TRANSPORTATION = 30;
    public static final int POWER_RF_SUPPLIER = 32;
    public static final int POWER_IC2_LV_SUPPLIER = 33;
    public static final int POWER_IC2_MV_SUPPLIER = 34;
    public static final int POWER_IC2_HV_SUPPLIER = 35;
    public static final int POWER_IC2_EV_SUPPLIER = 36;
    public static final int CC_REMOTE_CONTROL = 40;
    public static final int CRAFTING_MONITORING = 41;
    public static final int OPAQUE_UPGRADE = 42;
    public static final int LOGIC_CONTROLLER_UPGRADE = 43;
    public static final int UPGRADE_MODULE_UPGRADE = 44;
    public static final int MAX_LIQUID_CRAFTER = 3;
    public static final int MAX_CRAFTING_CLEANUP = 4;
    List<Upgrade> upgrades = new ArrayList<Upgrade>();
    private IIcon[] icons;
    public static String SHIFT_INFO_PREFIX = "item.upgrade.info.";

    public ItemUpgrade() {
        this.field_77787_bX = true;
    }

    public void loadUpgrades() {
        this.registerUpgrade(0, SneakyUpgradeUP.class, 0);
        this.registerUpgrade(1, SneakyUpgradeDOWN.class, 1);
        this.registerUpgrade(2, SneakyUpgradeNORTH.class, 2);
        this.registerUpgrade(3, SneakyUpgradeSOUTH.class, 3);
        this.registerUpgrade(4, SneakyUpgradeEAST.class, 4);
        this.registerUpgrade(5, SneakyUpgradeWEST.class, 5);
        this.registerUpgrade(6, CombinedSneakyUpgrade.class, 6);
        this.registerUpgrade(20, SpeedUpgrade.class, 7);
        this.registerUpgrade(10, ConnectionUpgradeUP.class, 8);
        this.registerUpgrade(11, ConnectionUpgradeDOWN.class, 9);
        this.registerUpgrade(12, ConnectionUpgradeNORTH.class, 10);
        this.registerUpgrade(13, ConnectionUpgradeSOUTH.class, 11);
        this.registerUpgrade(14, ConnectionUpgradeEAST.class, 12);
        this.registerUpgrade(15, ConnectionUpgradeWEST.class, 13);
        this.registerUpgrade(21, AdvancedSatelliteUpgrade.class, 14);
        this.registerUpgrade(22, FluidCraftingUpgrade.class, 15);
        this.registerUpgrade(23, CraftingByproductUpgrade.class, 16);
        this.registerUpgrade(24, PatternUpgrade.class, 17);
        this.registerUpgrade(25, FuzzyUpgrade.class, 18);
        this.registerUpgrade(30, PowerTransportationUpgrade.class, 19);
        this.registerUpgrade(32, RFPowerSupplierUpgrade.class, 21);
        this.registerUpgrade(33, IC2LVPowerSupplierUpgrade.class, 22);
        this.registerUpgrade(34, IC2MVPowerSupplierUpgrade.class, 23);
        this.registerUpgrade(35, IC2HVPowerSupplierUpgrade.class, 24);
        this.registerUpgrade(36, IC2EVPowerSupplierUpgrade.class, 25);
        this.registerUpgrade(40, CCRemoteControlUpgrade.class, 26);
        this.registerUpgrade(41, CraftingMonitoringUpgrade.class, 27);
        this.registerUpgrade(42, OpaqueUpgrade.class, 28);
        this.registerUpgrade(26, CraftingCleanupUpgrade.class, 29);
        if (LPConstants.DEBUG) {
            this.registerUpgrade(43, LogicControllerUpgrade.class, 30);
        }
        this.registerUpgrade(44, UpgradeModuleUpgrade.class, 31);
    }

    public void registerUpgrade(int id, Class<? extends IPipeUpgrade> moduleClass, int textureId) {
        boolean flag = true;
        for (Upgrade upgrade : this.upgrades) {
            if (upgrade.getId() != id) continue;
            flag = false;
            break;
        }
        if (!flag) {
            if (!flag) {
                throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Upgrade. (Id " + id + " already in use)");
            }
            throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Upgrade. (No name given)");
        }
        this.upgrades.add(new Upgrade(id, moduleClass, textureId));
    }

    public int[] getRegisteredUpgradeIDs() {
        int[] array = new int[this.upgrades.size()];
        int i = 0;
        for (Upgrade upgrade : this.upgrades) {
            array[i++] = upgrade.getId();
        }
        return array;
    }

    public CreativeTabs func_77640_w() {
        return CreativeTabs.field_78028_d;
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        for (Upgrade upgrade : this.upgrades) {
            par3List.add(new ItemStack((Item)this, 1, upgrade.getId()));
        }
    }

    public IPipeUpgrade getUpgradeForItem(ItemStack itemStack, IPipeUpgrade currentUpgrade) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.func_77973_b() != this) {
            return null;
        }
        for (Upgrade upgrade : this.upgrades) {
            if (itemStack.func_77960_j() != upgrade.getId()) continue;
            if (upgrade.getIPipeUpgradeClass() == null) {
                return null;
            }
            if (currentUpgrade != null && upgrade.getIPipeUpgradeClass().equals(currentUpgrade.getClass())) {
                return currentUpgrade;
            }
            return upgrade.getIPipeUpgrade();
        }
        return null;
    }

    public String func_77667_c(ItemStack itemstack) {
        for (Upgrade upgrade : this.upgrades) {
            if (itemstack.func_77960_j() != upgrade.getId()) continue;
            return "item." + upgrade.getIPipeUpgradeClass().getSimpleName();
        }
        return null;
    }

    @Override
    public String func_77653_i(ItemStack itemstack) {
        return StringUtils.translate(this.func_77667_c(itemstack));
    }

    @Override
    public void func_94581_a(IIconRegister par1IIconRegister) {
        this.icons = new IIcon[32];
        this.icons[0] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakyUP");
        this.icons[1] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakyDOWN");
        this.icons[2] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakyNORTH");
        this.icons[3] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakySOUTH");
        this.icons[4] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakyEAST");
        this.icons[5] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakyWEST");
        this.icons[6] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakyCombination");
        this.icons[7] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/Speed");
        this.icons[8] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/DisUP");
        this.icons[9] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/DisDOWN");
        this.icons[10] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/DisNORTH");
        this.icons[11] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/DisSOUTH");
        this.icons[12] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/DisEAST");
        this.icons[13] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/DisWEST");
        this.icons[14] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/Satelite");
        this.icons[15] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/FluidCrafting");
        this.icons[16] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/CraftingByproduct");
        this.icons[17] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/PlacementRules");
        this.icons[18] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/FuzzyCrafting");
        this.icons[19] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/PowerTransport");
        this.icons[20] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/PowerTransportBC");
        this.icons[21] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/PowerTransportTE");
        this.icons[22] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/PowerTransportIC2-LV");
        this.icons[23] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/PowerTransportIC2-MV");
        this.icons[24] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/PowerTransportIC2-HV");
        this.icons[25] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/PowerTransportIC2-EV");
        this.icons[26] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/CCRemoteControl");
        this.icons[27] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/CraftingMonitoring");
        this.icons[28] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/OpaqueUpgrade");
        this.icons[29] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/CraftingCleanup");
        this.icons[30] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/LogicController");
        this.icons[31] = par1IIconRegister.func_94245_a("logisticspipes:itemUpgrade/UpgradeModule");
    }

    public IIcon func_77617_a(int i) {
        for (Upgrade upgrade : this.upgrades) {
            if (upgrade.getId() != i || upgrade.getTextureIndex() == -1) continue;
            return this.icons[upgrade.getTextureIndex()];
        }
        return this.icons[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List<String> list, boolean flag) {
        super.func_77624_a(stack, par2EntityPlayer, list, flag);
        IPipeUpgrade upgrade = this.getUpgradeForItem(stack, null);
        if (upgrade == null) {
            return;
        }
        List<String> pipe = Arrays.asList(upgrade.getAllowedPipes());
        List<String> module = Arrays.asList(upgrade.getAllowedModules());
        if (pipe.isEmpty() && module.isEmpty()) {
            return;
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            if (!pipe.isEmpty() && !module.isEmpty()) {
                String base1 = StringUtils.translate(SHIFT_INFO_PREFIX + "both1");
                String base2 = StringUtils.translate(SHIFT_INFO_PREFIX + "both2");
                list.add(MessageFormat.format(base1, this.join(pipe)));
                list.add(MessageFormat.format(base2, this.join(module)));
            } else if (!pipe.isEmpty()) {
                String base = StringUtils.translate(SHIFT_INFO_PREFIX + "pipe");
                list.add(MessageFormat.format(base, this.join(pipe)));
            } else if (!module.isEmpty()) {
                String base = StringUtils.translate(SHIFT_INFO_PREFIX + "module");
                list.add(MessageFormat.format(base, this.join(module)));
            }
        } else {
            String baseKey = MessageFormat.format("{0}.tip", stack.func_77973_b().func_77667_c(stack));
            String key = baseKey + 1;
            String translation = StringUtils.translate(key);
            if (translation.equals(key)) {
                list.add(StringUtils.translate("misc.holdshift"));
            }
        }
    }

    private String join(List<String> join) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < join.size() - 2; ++i) {
            builder.append(StringUtils.translate(SHIFT_INFO_PREFIX + join.get(i)));
            builder.append(", ");
        }
        if (join.size() > 1) {
            builder.append(StringUtils.translate(SHIFT_INFO_PREFIX + join.get(join.size() - 2)));
            builder.append(" and ");
        }
        builder.append(StringUtils.translate(SHIFT_INFO_PREFIX + join.get(join.size() - 1)));
        return builder.toString();
    }

    private static class Upgrade {
        private final int id;
        private final Class<? extends IPipeUpgrade> upgradeClass;
        private int textureIndex = -1;

        private Upgrade(int id, Class<? extends IPipeUpgrade> moduleClass, int textureIndex) {
            this.id = id;
            this.upgradeClass = moduleClass;
            this.textureIndex = textureIndex;
        }

        private IPipeUpgrade getIPipeUpgrade() {
            if (this.upgradeClass == null) {
                return null;
            }
            try {
                return this.upgradeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }

        private Class<? extends IPipeUpgrade> getIPipeUpgradeClass() {
            return this.upgradeClass;
        }

        private int getId() {
            return this.id;
        }

        private int getTextureIndex() {
            return this.textureIndex;
        }
    }
}

