/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.utils.future;

public class MathHelper {
    private static final float[] SIN_TABLE = new float[65536];
    private static final int[] multiplyDeBruijnBitPosition;

    public static int floor_double(double p_76128_0_) {
        int i = (int)p_76128_0_;
        return p_76128_0_ < (double)i ? i - 1 : i;
    }

    public static int roundUpToPowerOfTwo(int p_151236_0_) {
        int j = p_151236_0_ - 1;
        j |= j >> 1;
        j |= j >> 2;
        j |= j >> 4;
        j |= j >> 8;
        j |= j >> 16;
        return j + 1;
    }

    private static boolean isPowerOfTwo(int p_151235_0_) {
        return p_151235_0_ != 0 && (p_151235_0_ & p_151235_0_ - 1) == 0;
    }

    private static int calculateLogBaseTwoDeBruijn(int p_151241_0_) {
        p_151241_0_ = MathHelper.isPowerOfTwo(p_151241_0_) ? p_151241_0_ : MathHelper.roundUpToPowerOfTwo(p_151241_0_);
        return multiplyDeBruijnBitPosition[(int)((long)p_151241_0_ * 125613361L >> 27) & 0x1F];
    }

    public static int calculateLogBaseTwo(int p_151239_0_) {
        return MathHelper.calculateLogBaseTwoDeBruijn(p_151239_0_) - (MathHelper.isPowerOfTwo(p_151239_0_) ? 0 : 1);
    }

    static {
        for (int var0 = 0; var0 < 65536; ++var0) {
            MathHelper.SIN_TABLE[var0] = (float)Math.sin((double)var0 * Math.PI * 2.0 / 65536.0);
        }
        multiplyDeBruijnBitPosition = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};
    }
}

