/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.nether.biome.utils;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ganymedes01.etfuturum.world.nether.biome.NetherBiomeBase;
import ganymedes01.etfuturum.world.nether.dimension.WorldProviderEFRNether;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.ForgeModContainer;

public class BiomeFogEventHandler {
    public static final BiomeFogEventHandler INSTANCE = new BiomeFogEventHandler();

    @SubscribeEvent
    public void onGetFogColor(EntityViewRenderEvent.FogColors event) {
        EntityLivingBase entityLivingBase;
        if (event.entity.field_70170_p.field_73011_w instanceof WorldProviderEFRNether && (entityLivingBase = event.entity) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            World world = player.field_70170_p;
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int y = MathHelper.func_76128_c((double)player.field_70163_u);
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            Block blockAtEyes = ActiveRenderInfo.func_151460_a((World)world, (EntityLivingBase)event.entity, (float)((float)event.renderPartialTicks));
            if (blockAtEyes.func_149688_o() == Material.field_151587_i) {
                return;
            }
            Vec3 mixedColor = BiomeFogEventHandler.getFogBlendColour(world, (EntityLivingBase)player, x, y, z, event.red, event.green, event.blue, event.renderPartialTicks);
            event.red = (float)mixedColor.field_72450_a;
            event.green = (float)mixedColor.field_72448_b;
            event.blue = (float)mixedColor.field_72449_c;
        }
    }

    private static Vec3 postProcessColor(World world, EntityLivingBase player, float r, float g, float b, double renderPartialTicks) {
        int duration;
        double darkScale = (player.field_70137_T + (player.field_70163_u - player.field_70137_T) * renderPartialTicks) * world.field_73011_w.func_76565_k();
        if (player.func_70644_a(Potion.field_76440_q)) {
            duration = player.func_70660_b(Potion.field_76440_q).func_76459_b();
            darkScale *= duration < 20 ? (double)(1.0f - (float)duration / 20.0f) : 0.0;
        }
        if (darkScale < 1.0) {
            darkScale = darkScale < 0.0 ? 0.0 : darkScale * darkScale;
            r *= (float)darkScale;
            g *= (float)darkScale;
            b *= (float)darkScale;
        }
        if (player.func_70644_a(Potion.field_76439_r)) {
            duration = player.func_70660_b(Potion.field_76439_r).func_76459_b();
            float brightness = duration > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)((float)(((double)duration - renderPartialTicks) * Math.PI * (double)0.2f))) * 0.3f;
            float scale = 1.0f / r;
            scale = Math.min(scale, 1.0f / g);
            scale = Math.min(scale, 1.0f / b);
            r = r * (1.0f - brightness) + r * scale * brightness;
            g = g * (1.0f - brightness) + g * scale * brightness;
            b = b * (1.0f - brightness) + b * scale * brightness;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
            float aR = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            float aG = (r * 30.0f + g * 70.0f) / 100.0f;
            float aB = (r * 30.0f + b * 70.0f) / 100.0f;
            r = aR;
            g = aG;
            b = aB;
        }
        return Vec3.func_72443_a((double)r, (double)g, (double)b);
    }

    private static Vec3 getFogBlendColour(World world, EntityLivingBase playerEntity, int playerX, int playerY, int playerZ, float defR, float defG, float defB, double renderPartialTicks) {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.field_74347_j && settings.field_151451_c >= 0 && settings.field_151451_c < ranges.length) {
            distance = ranges[settings.field_151451_c];
        }
        float rBiomeFog = 0.0f;
        float gBiomeFog = 0.0f;
        float bBiomeFog = 0.0f;
        float weightBiomeFog = 0.0f;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                double zDiff;
                double xDiff;
                BiomeGenBase biome = world.func_72807_a(playerX + x, playerZ + z);
                if (!(biome instanceof NetherBiomeBase)) continue;
                int fogColour = ((NetherBiomeBase)biome).fogSkyColor;
                float rPart = (fogColour & 0xFF0000) >> 16;
                float gPart = (fogColour & 0xFF00) >> 8;
                float bPart = fogColour & 0xFF;
                float weightPart = 1.0f;
                if (x == -distance) {
                    xDiff = 1.0 - (playerEntity.field_70165_t - (double)playerX);
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                } else if (x == distance) {
                    xDiff = playerEntity.field_70165_t - (double)playerX;
                    rPart = (float)((double)rPart * xDiff);
                    gPart = (float)((double)gPart * xDiff);
                    bPart = (float)((double)bPart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                }
                if (z == -distance) {
                    zDiff = 1.0 - (playerEntity.field_70161_v - (double)playerZ);
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                } else if (z == distance) {
                    zDiff = playerEntity.field_70161_v - (double)playerZ;
                    rPart = (float)((double)rPart * zDiff);
                    gPart = (float)((double)gPart * zDiff);
                    bPart = (float)((double)bPart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                }
                rBiomeFog += rPart;
                gBiomeFog += gPart;
                bBiomeFog += bPart;
                weightBiomeFog += weightPart;
            }
        }
        if (weightBiomeFog == 0.0f || distance == 0) {
            return Vec3.func_72443_a((double)defR, (double)defG, (double)defB);
        }
        rBiomeFog /= 255.0f;
        gBiomeFog /= 255.0f;
        bBiomeFog /= 255.0f;
        float rScale = 0.3f;
        float gScale = 0.3f;
        float bScale = 0.3f;
        Vec3 processedColor = BiomeFogEventHandler.postProcessColor(world, playerEntity, rBiomeFog *= rScale / weightBiomeFog, gBiomeFog *= gScale / weightBiomeFog, bBiomeFog *= bScale / weightBiomeFog, renderPartialTicks);
        rBiomeFog = (float)processedColor.field_72450_a;
        gBiomeFog = (float)processedColor.field_72448_b;
        bBiomeFog = (float)processedColor.field_72449_c;
        float weightMixed = distance * 2 * (distance * 2);
        float weightDefault = weightMixed - weightBiomeFog;
        processedColor.field_72450_a = (rBiomeFog * weightBiomeFog + defR * weightDefault) / weightMixed;
        processedColor.field_72448_b = (gBiomeFog * weightBiomeFog + defG * weightDefault) / weightMixed;
        processedColor.field_72449_c = (bBiomeFog * weightBiomeFog + defB * weightDefault) / weightMixed;
        return processedColor;
    }
}

